/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.xml;

import edu.iris.Fissures.IfEvent.EventAccessOperations;
import edu.iris.Fissures.IfEvent.EventAttr;
import edu.iris.Fissures.IfEvent.Origin;
import edu.iris.Fissures.IfNetwork.Channel;
import edu.iris.Fissures.IfParameterMgr.ParameterRef;
import edu.iris.Fissures.event.OriginImpl;
import edu.iris.Fissures.network.ChannelImpl;
import edu.sc.seis.fissuresUtil.cache.CacheEvent;
import edu.sc.seis.fissuresUtil.xml.XMLChannel;
import edu.sc.seis.fissuresUtil.xml.XMLDataSet;
import edu.sc.seis.fissuresUtil.xml.XMLEvent;
import edu.sc.seis.fissuresUtil.xml.XMLUtil;
import java.io.OutputStream;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XMLParameter {
    private static final String xlinkNS = "http://www.w3.org/1999/xlink";
    private static final Logger logger = LoggerFactory.getLogger(XMLParameter.class);

    public static void insert(XMLStreamWriter writer, String name, String value) throws XMLStreamException {
        XMLParameter.insert(writer, name, "http://www.w3c.org/1999/xschema/", "xsd:string", value);
    }

    public static void insert(XMLStreamWriter writer, String name, String typeDef, String typeName, String value) throws XMLStreamException {
        XMLUtil.writeTextElement(writer, "name", name);
        writer.writeStartElement("type");
        XMLUtil.writeTextElement(writer, "definition", typeDef);
        XMLUtil.writeTextElement(writer, "name", typeName);
        XMLUtil.writeEndElementWithNewLine(writer);
        XMLUtil.writeTextElement(writer, "value", value);
    }

    public static void insert(XMLStreamWriter writer, String name, Object value) throws XMLStreamException {
        XMLUtil.writeTextElement(writer, "name", name);
        writer.writeStartElement("type");
        if (value instanceof CacheEvent || value instanceof ChannelImpl) {
            XMLUtil.writeTextElement(writer, "definition", "http://www.seis.sc.edu/xschema/fissures.xsd");
            if (value instanceof CacheEvent) {
                XMLUtil.writeTextElement(writer, "name", CacheEvent.class.getName());
            } else if (value instanceof ChannelImpl) {
                XMLUtil.writeTextElement(writer, "name", ChannelImpl.class.getName());
            }
        } else {
            XMLUtil.writeTextElement(writer, "definition", "http://www.w3.org/2002/XMLSchema/");
            XMLUtil.writeTextElement(writer, "name", "xsd:string");
        }
        XMLUtil.writeEndElementWithNewLine(writer);
        if (value instanceof CacheEvent || value instanceof ChannelImpl) {
            writer.writeStartElement("value");
            if (value instanceof CacheEvent) {
                writer.writeStartElement("event");
                XMLEvent.insert(writer, (EventAccessOperations)((CacheEvent)value));
            } else {
                writer.writeStartElement("channel");
                XMLChannel.insert(writer, (ChannelImpl)value);
            }
            XMLUtil.writeEndElementWithNewLine(writer);
            XMLUtil.writeEndElementWithNewLine(writer);
        } else {
            String valString = value instanceof ParameterRef ? ((ParameterRef)value).creator : (String)value;
            XMLUtil.writeTextElement(writer, "value", valString);
        }
    }

    public static void insertParameterRef(XMLStreamWriter writer, String name, String href, Object value) throws XMLStreamException {
        writer.writeAttribute("name", name);
        writer.writeAttribute("xlink", xlinkNS, "type", "type/xml");
        if (href.startsWith("file:")) {
            href = href.substring(href.indexOf("file:") + 5);
        }
        href = href.replace(' ', '_');
        writer.writeAttribute("xlink", xlinkNS, "href", href);
        if (!(value instanceof String)) {
            writer.writeAttribute("objectType", XMLParameter.getObjectType(value));
        }
    }

    public static void insert(Element element, String name, String typeDef, String typeName, String value) {
        Document doc = element.getOwnerDocument();
        element.appendChild(XMLUtil.createTextElement(doc, "name", name));
        Element type = doc.createElement("type");
        element.appendChild(type);
        Element typeDefElement = XMLUtil.createTextElement(doc, "definition", typeDef);
        type.appendChild(typeDefElement);
        Element typeNameElement = XMLUtil.createTextElement(doc, "name", typeName);
        type.appendChild(typeNameElement);
        Element valueElement = XMLUtil.createTextElement(doc, "value", value);
        element.appendChild(valueElement);
    }

    public static void insert(Element element, String name, String value) {
        Document doc = element.getOwnerDocument();
        element.appendChild(XMLUtil.createTextElement(doc, "name", name));
        Element typeName = doc.createElement("type");
        typeName.appendChild(XMLUtil.createTextElement(doc, "definition", "http://www.w3c.org/1999/xschema/"));
        typeName.appendChild(XMLUtil.createTextElement(doc, "name", "xsd:string"));
        element.appendChild(XMLUtil.createTextElement(doc, "value", value));
    }

    public static void insertParameterRef(Element paramRef, String name, String href, Object value) {
        paramRef.setAttribute("name", name);
        paramRef.setAttributeNS(xlinkNS, "xlink:type", "type/xml");
        if (href.startsWith("file:")) {
            href = href.substring(href.indexOf("file:") + 5);
        }
        href = href.replace(' ', '_');
        paramRef.setAttributeNS(xlinkNS, "xlink:href", href);
        if (!(value instanceof String)) {
            paramRef.setAttribute("objectType", XMLParameter.getObjectType(value));
        }
    }

    public static void write(OutputStream out, Object value) {
        try {
            DocumentBuilder builder = XMLDataSet.getDocumentBuilder();
            Document doc = builder.newDocument();
            TransformerFactory tfactory = TransformerFactory.newInstance();
            Transformer serializer = tfactory.newTransformer();
            Properties oprops = new Properties();
            oprops.put("method", "xml");
            oprops.put("indent", "yes");
            serializer.setOutputProperties(oprops);
            Element element = doc.createElement("parameter");
            XMLParameter.insert(element, "notused", value);
            serializer.transform(new DOMSource(element), new StreamResult(out));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void insert(Element element, String name, Object value) {
        Document doc = element.getOwnerDocument();
        element.appendChild(XMLUtil.createTextElement(doc, "name", name));
        Element typeName = doc.createElement("type");
        Element valueElement = doc.createElement("value");
        if (value instanceof CacheEvent) {
            typeName.appendChild(XMLUtil.createTextElement(doc, "definition", "http://www.seis.sc.edu/xschema/fissures.xsd"));
            typeName.appendChild(XMLUtil.createTextElement(doc, "name", CacheEvent.class.getName()));
            element.appendChild(typeName);
            Element event = doc.createElement("event");
            XMLEvent.insert(event, (EventAccessOperations)((CacheEvent)value));
            valueElement.appendChild(event);
            element.appendChild(valueElement);
        } else if (value instanceof Channel) {
            typeName.appendChild(XMLUtil.createTextElement(doc, "definition", "http://www.seis.sc.edu/xschema/fissures.xsd"));
            typeName.appendChild(XMLUtil.createTextElement(doc, "name", Channel.class.getName()));
            element.appendChild(typeName);
            Element channel = doc.createElement("channel");
            XMLChannel.insert(channel, (Channel)value);
            valueElement.appendChild(channel);
            element.appendChild(valueElement);
        } else if (value instanceof ParameterRef) {
            typeName.appendChild(XMLUtil.createTextElement(doc, "definition", "http://www.w3.org/2002/XMLSchema/"));
            typeName.appendChild(XMLUtil.createTextElement(doc, "name", "xsd:string"));
            element.appendChild(typeName);
            element.appendChild(XMLUtil.createTextElement(doc, "value", ((ParameterRef)value).creator));
        } else {
            typeName.appendChild(XMLUtil.createTextElement(doc, "definition", "http://www.w3.org/2002/XMLSchema/"));
            typeName.appendChild(XMLUtil.createTextElement(doc, "name", "xsd:string"));
            element.appendChild(typeName);
            element.appendChild(XMLUtil.createTextElement(doc, "value", (String)value));
        }
    }

    public static Object getParameter(Element base) {
        String name = XMLUtil.getText(XMLUtil.getElement(base, "name"));
        Element type = XMLUtil.getElement(base, "type");
        String className = XMLUtil.getText(XMLUtil.getElement(type, "name"));
        try {
            Class<?> c = Class.forName(className);
            while (!c.equals(Object.class)) {
                if (XMLParameter.isRecognizedClass(c)) {
                    return XMLParameter.makeForClass(c, base);
                }
                Class<?>[] interfaces = c.getInterfaces();
                for (int i = 0; i < interfaces.length; ++i) {
                    if (!XMLParameter.isRecognizedClass(interfaces[i])) continue;
                    return XMLParameter.makeForClass(interfaces[i], base);
                }
                c = c.getSuperclass();
            }
        }
        catch (ClassNotFoundException e) {
            logger.debug("unable to find class of type " + className + " loading parameter as a string", (Throwable)e);
        }
        String value = XMLUtil.getText(XMLUtil.getElement(base, "value"));
        return new ParameterRef(name, value);
    }

    public static Object getParameter(XMLStreamReader parser, String name) throws XMLStreamException {
        XMLUtil.gotoNextStartElement(parser, "name");
        String className = parser.getElementText();
        try {
            Class<?> c = Class.forName(className);
            while (!c.equals(Object.class)) {
                if (XMLParameter.isRecognizedClass(c)) {
                    return XMLParameter.makeForClass(c, parser);
                }
                Class<?>[] interfaces = c.getInterfaces();
                for (int i = 0; i < interfaces.length; ++i) {
                    if (!XMLParameter.isRecognizedClass(interfaces[i])) continue;
                    return XMLParameter.makeForClass(interfaces[i], parser);
                }
                c = c.getSuperclass();
            }
        }
        catch (ClassNotFoundException e) {
            logger.debug("unable to find class of type " + className + " loading parameter as a string", (Throwable)e);
        }
        XMLUtil.gotoNextStartElement(parser, "value");
        String value = parser.getElementText();
        return new ParameterRef(name, value);
    }

    public static boolean isRecognizedClass(Class c) {
        return c.equals(CacheEvent.class) || c.equals(Channel.class);
    }

    public static Object makeForClass(Class c, Element base) {
        if (c.equals(CacheEvent.class)) {
            return XMLParameter.makeEvent(base);
        }
        if (c.equals(Channel.class)) {
            return XMLParameter.makeChannel(base);
        }
        return null;
    }

    public static Object makeForClass(Class c, XMLStreamReader parser) throws XMLStreamException {
        if (c.equals(CacheEvent.class)) {
            return XMLParameter.makeEvent(parser);
        }
        if (c.equals(Channel.class)) {
            return XMLParameter.makeChannel(parser);
        }
        return null;
    }

    private static Channel makeChannel(Element base) {
        Element channelNode = XMLUtil.getElement(XMLUtil.getElement(base, "value"), "channel");
        Channel channel = XMLChannel.getChannel(channelNode);
        return channel;
    }

    private static Channel makeChannel(XMLStreamReader parser) throws XMLStreamException {
        XMLUtil.gotoNextStartElement(parser, "channel");
        Channel channel = XMLChannel.getChannel(parser);
        return channel;
    }

    private static CacheEvent makeEvent(Element base) {
        Element event = XMLUtil.getElement(XMLUtil.getElement(base, "value"), "event");
        EventAttr eventAttr = XMLEvent.getEvent(event);
        OriginImpl preferred_origin = XMLEvent.getPreferredOrigin(event);
        return new CacheEvent(eventAttr, (Origin[])new OriginImpl[0], preferred_origin);
    }

    private static CacheEvent makeEvent(XMLStreamReader parser) throws XMLStreamException {
        XMLUtil.gotoNextStartElement(parser, "event");
        EventAttr eventAttr = XMLEvent.getEvent(parser);
        OriginImpl preferred_origin = XMLEvent.getPreferredOrigin(parser);
        return new CacheEvent(eventAttr, (Origin[])new OriginImpl[0], preferred_origin);
    }

    public static String getObjectType(Object object) {
        if (object instanceof Channel) {
            return "edu.sc.seis.fissuresUtil.xml.XMLChannel";
        }
        if (object instanceof CacheEvent) {
            return "edu.sc.seis.fissuresUtil.xml.XMLEvent";
        }
        return "String";
    }
}

