/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.xml;

import edu.iris.Fissures.IfSeismogramDC.RequestFilter;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.seismogramDC.LocalSeismogramImpl;
import edu.sc.seis.fissuresUtil.cache.WorkerThreadPool;
import edu.sc.seis.fissuresUtil.xml.DataSet;
import edu.sc.seis.fissuresUtil.xml.DataSetSeismogram;
import edu.sc.seis.fissuresUtil.xml.SeisDataChangeListener;
import java.util.Date;

public class MemoryDataSetSeismogram
extends DataSetSeismogram
implements Cloneable {
    protected LocalSeismogramImpl[] memoryCache;

    public MemoryDataSetSeismogram(RequestFilter requestFilter, String name) {
        super(null, name, requestFilter);
        this.memoryCache = new LocalSeismogramImpl[0];
    }

    public MemoryDataSetSeismogram(LocalSeismogramImpl seis, String name) {
        this(MemoryDataSetSeismogram.makeSeisArray(seis), null, name);
    }

    public MemoryDataSetSeismogram(LocalSeismogramImpl seis) {
        this(MemoryDataSetSeismogram.makeSeisArray(seis), null);
    }

    public MemoryDataSetSeismogram(LocalSeismogramImpl seis, DataSet ds) {
        this(MemoryDataSetSeismogram.makeSeisArray(seis), ds);
    }

    public MemoryDataSetSeismogram(LocalSeismogramImpl seis, DataSet ds, String name) {
        this(MemoryDataSetSeismogram.makeSeisArray(seis), ds, name);
    }

    public MemoryDataSetSeismogram(LocalSeismogramImpl[] seis, DataSet ds) {
        this(seis, ds, null);
    }

    public MemoryDataSetSeismogram(LocalSeismogramImpl[] seis, DataSet ds, String name) {
        this(seis, ds, name, MemoryDataSetSeismogram.makeRequestFilter(seis));
    }

    public MemoryDataSetSeismogram(LocalSeismogramImpl[] seis, DataSet ds, String name, RequestFilter rf) {
        super(ds, name, rf);
        this.memoryCache = seis;
    }

    @Override
    public void retrieveData(final SeisDataChangeListener dataListener) {
        WorkerThreadPool.getDefaultPool().invokeLater(new Runnable(){

            @Override
            public void run() {
                MemoryDataSetSeismogram.this.pushData(MemoryDataSetSeismogram.this.memoryCache, dataListener);
                MemoryDataSetSeismogram.this.finished(dataListener);
            }
        });
    }

    public synchronized LocalSeismogramImpl[] getCache() {
        return this.memoryCache;
    }

    public synchronized void add(LocalSeismogramImpl seis) {
        LocalSeismogramImpl[] tmp = new LocalSeismogramImpl[this.memoryCache.length + 1];
        System.arraycopy(this.memoryCache, 0, tmp, 0, this.memoryCache.length);
        tmp[tmp.length - 1] = seis;
        this.memoryCache = tmp;
    }

    static final RequestFilter makeRequestFilter(LocalSeismogramImpl[] seis) {
        if (seis == null) {
            throw new IllegalArgumentException("Seismogram array cannot be null");
        }
        if (seis.length == 0) {
            throw new IllegalArgumentException("Seismogram array cannot be empty");
        }
        MicroSecondDate pre = seis[0].getBeginTime();
        MicroSecondDate post = seis[0].getEndTime();
        for (int i = 0; i < seis.length; ++i) {
            if (pre.after((Date)seis[i].getBeginTime())) {
                pre = seis[i].getBeginTime();
            }
            if (!post.before((Date)seis[i].getEndTime())) continue;
            post = seis[i].getEndTime();
        }
        RequestFilter out = new RequestFilter(seis[0].channel_id, pre.getFissuresTime(), post.getFissuresTime());
        return out;
    }

    static final LocalSeismogramImpl[] makeSeisArray(LocalSeismogramImpl seis) {
        LocalSeismogramImpl[] tmp = new LocalSeismogramImpl[]{seis};
        return tmp;
    }
}

