/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.stationxml;

import edu.iris.Fissures.IfNetwork.Channel;
import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.IfNetwork.Clock;
import edu.iris.Fissures.IfNetwork.CoefficientErrored;
import edu.iris.Fissures.IfNetwork.CoefficientFilter;
import edu.iris.Fissures.IfNetwork.ComplexNumberErrored;
import edu.iris.Fissures.IfNetwork.DataAcqSys;
import edu.iris.Fissures.IfNetwork.Decimation;
import edu.iris.Fissures.IfNetwork.Filter;
import edu.iris.Fissures.IfNetwork.Gain;
import edu.iris.Fissures.IfNetwork.NetworkAttr;
import edu.iris.Fissures.IfNetwork.NetworkId;
import edu.iris.Fissures.IfNetwork.Normalization;
import edu.iris.Fissures.IfNetwork.PoleZeroFilter;
import edu.iris.Fissures.IfNetwork.RecordingStyle;
import edu.iris.Fissures.IfNetwork.Response;
import edu.iris.Fissures.IfNetwork.Sensitivity;
import edu.iris.Fissures.IfNetwork.Sensor;
import edu.iris.Fissures.IfNetwork.Site;
import edu.iris.Fissures.IfNetwork.SiteId;
import edu.iris.Fissures.IfNetwork.Stage;
import edu.iris.Fissures.IfNetwork.StationId;
import edu.iris.Fissures.IfNetwork.TransferType;
import edu.iris.Fissures.Location;
import edu.iris.Fissures.LocationType;
import edu.iris.Fissures.Orientation;
import edu.iris.Fissures.Quantity;
import edu.iris.Fissures.Sampling;
import edu.iris.Fissures.Time;
import edu.iris.Fissures.TimeRange;
import edu.iris.Fissures.Unit;
import edu.iris.Fissures.UnitBase;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.model.QuantityImpl;
import edu.iris.Fissures.model.SamplingImpl;
import edu.iris.Fissures.model.TimeInterval;
import edu.iris.Fissures.model.UnitImpl;
import edu.iris.Fissures.network.ChannelIdUtil;
import edu.iris.Fissures.network.ChannelImpl;
import edu.iris.Fissures.network.ClockImpl;
import edu.iris.Fissures.network.DataAcqSysImpl;
import edu.iris.Fissures.network.InstrumentationImpl;
import edu.iris.Fissures.network.NetworkAttrImpl;
import edu.iris.Fissures.network.NetworkIdUtil;
import edu.iris.Fissures.network.SensorImpl;
import edu.iris.Fissures.network.SiteImpl;
import edu.iris.Fissures.network.StationImpl;
import edu.sc.seis.fissuresUtil.stationxml.ChannelSensitivityBundle;
import edu.sc.seis.fissuresUtil.stationxml.StationChannelBundle;
import edu.sc.seis.seisFile.fdsnws.stationxml.BaseFilterType;
import edu.sc.seis.seisFile.fdsnws.stationxml.Coefficients;
import edu.sc.seis.seisFile.fdsnws.stationxml.FIR;
import edu.sc.seis.seisFile.fdsnws.stationxml.FloatType;
import edu.sc.seis.seisFile.fdsnws.stationxml.InstrumentSensitivity;
import edu.sc.seis.seisFile.fdsnws.stationxml.Network;
import edu.sc.seis.seisFile.fdsnws.stationxml.PoleZero;
import edu.sc.seis.seisFile.fdsnws.stationxml.PolesZeros;
import edu.sc.seis.seisFile.fdsnws.stationxml.ResponseList;
import edu.sc.seis.seisFile.fdsnws.stationxml.ResponseStage;
import edu.sc.seis.seisFile.fdsnws.stationxml.Station;
import edu.sc.seis.seisFile.fdsnws.stationxml.StationXMLException;
import edu.sc.seis.seisFile.fdsnws.stationxml.Zero;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StationXMLToFissures {
    public static final Filter UNITY_POLE_ZERO = new Filter();
    public static final Filter UNITY_COEFFICENT_FILTER = new Filter();
    public static final String UNKNOWN = "";
    public static final TimeInterval ONE_SECOND;
    public static final String WAY_FUTURE = "24990101T00:00:00.000";
    public static final String WAY_PAST = "10010101T00:00:00.000";
    private static final Logger logger;

    public static NetworkAttrImpl convert(Network net) {
        String name = net.getDescription();
        if (name.length() > 80) {
            name = name.substring(0, 80);
        }
        Time startDate = StationXMLToFissures.convertTime(net.getStartDate(), WAY_PAST);
        return new NetworkAttrImpl(new NetworkId(net.getCode(), startDate), name, net.getDescription(), UNKNOWN, new TimeRange(startDate, StationXMLToFissures.convertTime(net.getEndDate(), WAY_FUTURE)));
    }

    public static StationImpl convert(Station xml, NetworkAttrImpl netAttr) throws StationXMLException {
        Time startDate = StationXMLToFissures.convertTime(xml.getStartDate(), WAY_PAST);
        TimeRange effectiveTime = new TimeRange(startDate, StationXMLToFissures.convertTime(xml.getEndDate(), WAY_FUTURE));
        String name = xml.getSite().getName();
        if (name == null) {
            name = (xml.getSite().getTown() != null ? xml.getSite().getTown() + " " : UNKNOWN) + (xml.getSite().getRegion() != null ? xml.getSite().getRegion() + " " : UNKNOWN) + (xml.getSite().getCountry() != null ? xml.getSite().getCountry() : UNKNOWN);
            name = name.trim();
        }
        if (UNKNOWN.equals(name)) {
            name = xml.getSite().getDescription();
        }
        if (null == name || UNKNOWN.equals(name)) {
            name = UNKNOWN;
        }
        return new StationImpl(new StationId(netAttr.getId(), xml.getCode(), effectiveTime.start_time), name, new Location(xml.getLatitude().getValue(), xml.getLongitude().getValue(), (Quantity)StationXMLToFissures.convertFloatType(xml.getElevation()), (Quantity)new QuantityImpl(0.0, (Unit)UnitImpl.METER), LocationType.GEOGRAPHIC), effectiveTime, UNKNOWN, UNKNOWN, UNKNOWN, (NetworkAttr)netAttr);
    }

    public static List<StationChannelBundle> convert(Station xml, List<NetworkAttrImpl> knownNets, boolean extractChannels) throws StationXMLException {
        NetworkAttrImpl attr = null;
        for (NetworkAttrImpl net : knownNets) {
            MicroSecondDate netBegin;
            if (!xml.getNetworkCode().equals(net.get_code())) continue;
            if (!NetworkIdUtil.isTemporary((NetworkId)net.get_id())) {
                attr = net;
                break;
            }
            MicroSecondDate staBegin = new MicroSecondDate(xml.getStartDate());
            if (!staBegin.after((Date)(netBegin = new MicroSecondDate(net.getBeginTime()))) || !staBegin.before((Date)new MicroSecondDate(net.getEndTime()))) continue;
            attr = net;
            break;
        }
        if (attr == null) {
            throw new StationXMLException("Can't find network for " + xml.getNetworkCode());
        }
        return StationXMLToFissures.convert(xml, attr, extractChannels);
    }

    public static List<StationChannelBundle> convert(Station xml, Network net, boolean extractChannels) throws StationXMLException {
        return StationXMLToFissures.convert(xml, StationXMLToFissures.convert(net), extractChannels);
    }

    public static List<StationChannelBundle> convert(Station xml, NetworkAttrImpl attr, boolean extractChannels) throws StationXMLException {
        ArrayList<StationChannelBundle> out = new ArrayList<StationChannelBundle>();
        StationImpl sta = StationXMLToFissures.convert(xml, attr);
        StationChannelBundle bundle = new StationChannelBundle(sta);
        out.add(bundle);
        if (extractChannels) {
            for (edu.sc.seis.seisFile.fdsnws.stationxml.Channel xmlChan : xml.getChannelList()) {
                ChannelSensitivityBundle chanSens = StationXMLToFissures.convert(xmlChan, sta);
                bundle.getChanList().add(chanSens);
                if (chanSens.getChan().getStationImpl().getNetworkAttrImpl().get_code().equals(xml.getNetworkCode()) && chanSens.getChan().getStationImpl().get_code().equals(xml.getCode())) continue;
                throw new StationXMLException("Chan doesn't match station or net: " + ChannelIdUtil.toStringNoDates((Channel)chanSens.getChan()) + "  " + xml.getNetworkCode() + "." + xml.getCode() + "  attr:" + NetworkIdUtil.toStringNoDates((NetworkAttr)attr));
            }
        }
        return out;
    }

    public static ChannelSensitivityBundle convert(edu.sc.seis.seisFile.fdsnws.stationxml.Channel channel, StationImpl station) throws StationXMLException {
        SamplingImpl samp = Math.abs((float)Math.round(channel.getSampleRate().getValue()) - channel.getSampleRate().getValue()) < 1.0E-4f ? new SamplingImpl(Math.round(channel.getSampleRate().getValue()), ONE_SECOND) : new SamplingImpl(1, new TimeInterval((double)(1.0f / channel.getSampleRate().getValue()), UnitImpl.SECOND));
        TimeRange chanTimeRange = new TimeRange(StationXMLToFissures.convertTime(channel.getStartDate(), WAY_PAST), StationXMLToFissures.convertTime(channel.getEndDate(), WAY_FUTURE));
        ChannelImpl chan = new ChannelImpl(new ChannelId(station.getId().network_id, station.get_code(), channel.getLocCode(), channel.getCode(), chanTimeRange.start_time), UNKNOWN, new Orientation(channel.getAzimuth().getValue(), channel.getDip().getValue()), (Sampling)samp, chanTimeRange, (Site)new SiteImpl(new SiteId(station.getId().network_id, station.get_code(), channel.getLocCode(), chanTimeRange.end_time), new Location(channel.getLatitude().getValue(), channel.getLon().getValue(), (Quantity)StationXMLToFissures.convertFloatType(channel.getElevation()), (Quantity)StationXMLToFissures.convertFloatType(channel.getDepth()), LocationType.GEOGRAPHIC), chanTimeRange, (edu.iris.Fissures.IfNetwork.Station)station, UNKNOWN));
        QuantityImpl sensitivity = null;
        if (channel.getResponse().getInstrumentSensitivity() != null && channel.getResponse().getInstrumentSensitivity().getInputUnits() != null && channel.getResponse().getInstrumentSensitivity().getOutputUnits() != null) {
            try {
                sensitivity = new QuantityImpl((double)channel.getResponse().getInstrumentSensitivity().getSensitivityValue(), (Unit)StationXMLToFissures.convertUnit(channel.getResponse().getInstrumentSensitivity().getInputUnits()));
            }
            catch (StationXMLException e) {
                logger.warn("Unable to extract unit: " + ChannelIdUtil.toStringFormatDates((ChannelId)chan.getId()), (Throwable)e);
            }
        } else {
            logger.info("No sensitivity for " + ChannelIdUtil.toStringFormatDates((ChannelId)chan.getId()));
        }
        return new ChannelSensitivityBundle(chan, sensitivity);
    }

    public static InstrumentationImpl convertInstrumentation(edu.sc.seis.seisFile.fdsnws.stationxml.Channel xmlChan) throws StationXMLException {
        ClockImpl clock = new ClockImpl(0, "unknown", "unknown", "unknown", "unknown");
        SensorImpl sensor = new SensorImpl(0, "unknown", "unknown", "unknown", 0.0f, 0.0f);
        if (xmlChan.getSensor() != null) {
            String model = StationXMLToFissures.makeNoNull(xmlChan.getSensor().getModel());
            if (model.length() == 0) {
                model = StationXMLToFissures.makeNoNull(xmlChan.getSensor().getType());
            }
            if (model.length() == 0) {
                model = StationXMLToFissures.makeNoNull(xmlChan.getSensor().getDescription());
            }
            sensor = new SensorImpl(0, StationXMLToFissures.makeNoNull(xmlChan.getSensor().getManufacturer()), StationXMLToFissures.makeNoNull(xmlChan.getSensor().getSerialNumber()), model, 0.0f, 0.0f);
        }
        DataAcqSysImpl dataLogger = new DataAcqSysImpl(0, "unknown", "unknown", "unknown", RecordingStyle.UNKNOWN);
        if (xmlChan.getDataLogger() != null) {
            String model = StationXMLToFissures.makeNoNull(xmlChan.getDataLogger().getModel());
            if (model.length() == 0) {
                model = StationXMLToFissures.makeNoNull(xmlChan.getDataLogger().getType());
            }
            dataLogger = new DataAcqSysImpl(0, StationXMLToFissures.makeNoNull(xmlChan.getDataLogger().getManufacturer()), StationXMLToFissures.makeNoNull(xmlChan.getDataLogger().getSerialNumber()), model, RecordingStyle.UNKNOWN);
        }
        TimeRange chanTimeRange = new TimeRange(StationXMLToFissures.convertTime(xmlChan.getStartDate()), StationXMLToFissures.convertTime(xmlChan.getEndDate()));
        if (xmlChan.getResponse().getResponseStageList().size() != 0) {
            InstrumentationImpl out = new InstrumentationImpl(StationXMLToFissures.convert(xmlChan.getResponse().getResponseStageList(), xmlChan.getResponse().getInstrumentSensitivity()), chanTimeRange, (Clock)clock, (Sensor)sensor, (DataAcqSys)dataLogger);
            return out;
        }
        throw new StationXMLException("Response not available");
    }

    public static Response convert(List<ResponseStage> respList, InstrumentSensitivity overallGain) throws StationXMLException {
        Sensitivity sense = null;
        if (overallGain != null) {
            sense = new Sensitivity(overallGain.getSensitivityValue(), overallGain.getFrequency());
        } else {
            for (ResponseStage response : respList) {
                if (response.getNumber() != 0) continue;
                sense = new Sensitivity(response.getStageSensitivity().getSensitivityValue(), response.getStageSensitivity().getFrequency());
                break;
            }
        }
        ArrayList<Stage> stages = new ArrayList<Stage>();
        for (ResponseStage response : respList) {
            Filter[] filt;
            UnitImpl outputUnits;
            UnitImpl inputUnits;
            if (response.getNumber() == 0) continue;
            Decimation[] dec = new Decimation[]{};
            if (response.getDecimation() != null) {
                dec = new Decimation[]{StationXMLToFissures.convertDecimation(response.getDecimation())};
            }
            Normalization[] norm = new Normalization[]{};
            if (response.getResponseItem() == null) {
                if (stages.size() == 0) {
                    throw new StationXMLException("No units on stage 0, cannot convert response");
                }
                outputUnits = inputUnits = (UnitImpl)((Stage)stages.get((int)(stages.size() - 1))).output_units;
                filt = response.getDecimation() != null ? new Filter[]{UNITY_COEFFICENT_FILTER} : new Filter[]{UNITY_POLE_ZERO};
            } else {
                filt = new Filter[]{StationXMLToFissures.convertFilter(response.getResponseItem())};
                inputUnits = StationXMLToFissures.convertUnit(response.getResponseItem().getInputUnits());
                outputUnits = StationXMLToFissures.convertUnit(response.getResponseItem().getOutputUnits());
                if (response.getResponseItem() instanceof PolesZeros) {
                    norm = new Normalization[]{StationXMLToFissures.convertNormalization((PolesZeros)response.getResponseItem())};
                }
            }
            Gain g = response.getStageSensitivity() != null ? new Gain(response.getStageSensitivity().getSensitivityValue(), response.getStageSensitivity().getFrequency()) : new Gain(1.0f, sense.frequency);
            stages.add(new Stage(StationXMLToFissures.getTransferType(response), (Unit)inputUnits, (Unit)outputUnits, norm, g, dec, filt));
        }
        return new Response(sense, stages.toArray(new Stage[0]));
    }

    public static Decimation convertDecimation(edu.sc.seis.seisFile.fdsnws.stationxml.Decimation dec) {
        return new Decimation((Sampling)new SamplingImpl(1, new TimeInterval((double)(1.0f / dec.getInputSampleRate()), UnitImpl.SECOND)), dec.getFactor(), dec.getOffset(), (Quantity)new TimeInterval((double)dec.getDelay().getValue(), UnitImpl.SECOND), (Quantity)new TimeInterval((double)dec.getCorrection().getValue(), UnitImpl.SECOND));
    }

    public static Filter convertFilter(BaseFilterType filterType) throws StationXMLException {
        Filter out = new Filter();
        if (filterType instanceof PolesZeros) {
            PolesZeros pz = (PolesZeros)filterType;
            ComplexNumberErrored[] poles = new ComplexNumberErrored[pz.getPoleList().size()];
            int i = 0;
            for (Object p : pz.getPoleList()) {
                poles[i++] = StationXMLToFissures.convertComplex((PoleZero)p);
            }
            ComplexNumberErrored[] zeros = new ComplexNumberErrored[pz.getZeroList().size()];
            i = 0;
            for (Zero p : pz.getZeroList()) {
                zeros[i++] = StationXMLToFissures.convertComplex((PoleZero)p);
            }
            out.pole_zero_filter(new PoleZeroFilter(poles, zeros));
        } else if (filterType instanceof Coefficients) {
            Coefficients coef = (Coefficients)filterType;
            CoefficientErrored[] num = new CoefficientErrored[coef.getNumeratorList().size()];
            int i = 0;
            for (FloatType p : coef.getNumeratorList()) {
                float error = 0.0f;
                if (p.hasPlusError()) {
                    error = Math.max(p.getPlusError().floatValue(), error);
                }
                if (p.hasMinusError()) {
                    error = Math.max(p.getMinusError().floatValue(), error);
                }
                num[i++] = new CoefficientErrored(p.getValue(), error);
            }
            CoefficientErrored[] denom = new CoefficientErrored[coef.getDenominatorList().size()];
            i = 0;
            for (FloatType p : coef.getDenominatorList()) {
                float error = 0.0f;
                if (p.hasPlusError()) {
                    error = Math.max(p.getPlusError().floatValue(), error);
                }
                if (p.hasMinusError()) {
                    error = Math.max(p.getMinusError().floatValue(), error);
                }
                denom[i++] = new CoefficientErrored(p.getValue(), error);
            }
            out.coeff_filter(new CoefficientFilter(num, denom));
        } else if (filterType instanceof FIR) {
            int i;
            CoefficientErrored[] num;
            FIR fir = (FIR)filterType;
            int numListSize = fir.getNumeratorCoefficientList().size();
            if (fir.getSymmetry().equals("NONE")) {
                num = new CoefficientErrored[numListSize];
                i = 0;
                for (Float p : fir.getNumeratorCoefficientList()) {
                    float error = 0.0f;
                    num[i++] = new CoefficientErrored(p.floatValue(), error);
                }
            } else if (fir.getSymmetry().equals("ODD")) {
                num = new CoefficientErrored[2 * numListSize - 1];
                i = 0;
                for (Float p : fir.getNumeratorCoefficientList()) {
                    float error = 0.0f;
                    num[i] = new CoefficientErrored(p.floatValue(), error);
                    num[2 * numListSize - 1 - i - 1] = new CoefficientErrored(p.floatValue(), error);
                    ++i;
                }
            } else if (fir.getSymmetry().equals("EVEN")) {
                num = new CoefficientErrored[2 * numListSize];
                i = 0;
                for (Float p : fir.getNumeratorCoefficientList()) {
                    float error = 0.0f;
                    num[i] = new CoefficientErrored(p.floatValue(), error);
                    num[2 * numListSize - i - 1] = new CoefficientErrored(p.floatValue(), error);
                    ++i;
                }
            } else {
                throw new StationXMLException("Unknown FIR symmetry: " + fir.getSymmetry());
            }
            CoefficientErrored[] denom = new CoefficientErrored[]{};
            out.coeff_filter(new CoefficientFilter(num, denom));
        } else {
            if (filterType instanceof ResponseList) {
                throw new StationXMLException("Can only handle PolesZeros or FIR response types. " + filterType.getClass());
            }
            throw new StationXMLException("Can only handle PolesZeros or FIR response types. " + filterType.getClass());
        }
        return out;
    }

    public static Normalization convertNormalization(PolesZeros poleZero) {
        return new Normalization(poleZero.getNormalizationFactor(), poleZero.getNormalizationFreq());
    }

    public static ComplexNumberErrored convertComplex(PoleZero pz) {
        return new ComplexNumberErrored((float)pz.getReal(), 0.0f, (float)pz.getImaginary(), 0.0f);
    }

    public static TransferType getTransferType(ResponseStage response) throws StationXMLException {
        if (response.getResponseItem() instanceof PolesZeros) {
            PolesZeros pz = (PolesZeros)response.getResponseItem();
            if (pz.getPzTransferType().equals("LAPLACE (RADIANS/SECOND)")) {
                return TransferType.LAPLACE;
            }
            if (pz.getPzTransferType().equals("LAPLACE (HERTZ)")) {
                return TransferType.ANALOG;
            }
            if (pz.getPzTransferType().equals("DIGITAL (Z-TRANSFORM)")) {
                return TransferType.DIGITAL;
            }
            throw new StationXMLException("Unknown PoleZero transfer type: " + ((PolesZeros)response.getResponseItem()).getPzTransferType());
        }
        if (response.getResponseItem() instanceof Coefficients) {
            Coefficients coeff = (Coefficients)response.getResponseItem();
            if (coeff.getCfTransferType().equals("ANALOG (RADIANS/SECOND)")) {
                return TransferType.LAPLACE;
            }
            if (coeff.getCfTransferType().equals("ANALOG (HERTZ)")) {
                return TransferType.ANALOG;
            }
            if (coeff.getCfTransferType().equals("DIGITAL")) {
                return TransferType.DIGITAL;
            }
            throw new StationXMLException("Unknown Coefficients transfer type: " + coeff.getCfTransferType());
        }
        if (response.getResponseItem() instanceof FIR) {
            return TransferType.DIGITAL;
        }
        if (response.getResponseItem() == null) {
            if (response.getDecimation() != null) {
                return TransferType.DIGITAL;
            }
            return TransferType.ANALOG;
        }
        throw new StationXMLException("Can only handle PolesZeros, Coefficients or FIR response types. " + response.getResponseItem().getClass());
    }

    public static QuantityImpl convertFloatType(FloatType val) throws StationXMLException {
        return new QuantityImpl((double)val.getValue(), (Unit)StationXMLToFissures.convertUnit(val.getUnit(), UNKNOWN));
    }

    public static UnitImpl convertUnit(edu.sc.seis.seisFile.fdsnws.stationxml.Unit unit) throws StationXMLException {
        String unitString = unit.getName().indexOf(" - ") != -1 ? unit.getName().substring(0, unit.getName().indexOf(" - ")).trim() : unit.getName().trim();
        if (unitString.length() == 0) {
            throw new StationXMLException("Unknown unit: " + unit.getName() + " " + unit.getDescription());
        }
        return StationXMLToFissures.convertUnit(unitString, unit.getDescription());
    }

    public static UnitImpl convertUnit(String unitString, String unitDescription) throws StationXMLException {
        if (unitDescription == null) {
            unitDescription = UNKNOWN;
        }
        unitString = unitString.trim();
        unitDescription = unitDescription.trim();
        if (unitString.equalsIgnoreCase("M") && !unitDescription.trim().equalsIgnoreCase("minute")) {
            return UnitImpl.METER;
        }
        if (unitString.equalsIgnoreCase("M") && unitDescription.trim().equalsIgnoreCase("minute")) {
            return UnitImpl.MINUTE;
        }
        if (unitString.equalsIgnoreCase("NM")) {
            return UnitImpl.NANOMETER;
        }
        if (unitString.equalsIgnoreCase("M/S")) {
            return UnitImpl.METER_PER_SECOND;
        }
        if (unitString.equalsIgnoreCase("NM/S") || unitString.equalsIgnoreCase("NM/SEC")) {
            return UnitImpl.NANOMETER_PER_SECOND;
        }
        if (unitString.equalsIgnoreCase("CM/SEC**2")) {
            return UnitImpl.CENTIMETER_PER_SECOND_PER_SECOND;
        }
        if (unitString.equalsIgnoreCase("M/S/S") || unitString.equalsIgnoreCase("M/S**2") || unitString.equalsIgnoreCase("M/(S**2)") || unitString.equalsIgnoreCase("M/S**2/ACCELERATION")) {
            return UnitImpl.METER_PER_SECOND_PER_SECOND;
        }
        if (unitString.equalsIgnoreCase("PA") || unitString.equalsIgnoreCase("PASSCAL") || unitString.equalsIgnoreCase("PASSCALS")) {
            return UnitImpl.PASCAL;
        }
        if (unitString.equalsIgnoreCase("HPA") || unitString.equalsIgnoreCase("HECTOPASCALS")) {
            return UnitImpl.HECTOPASCAL;
        }
        if (unitString.equalsIgnoreCase("KPA") || unitString.equalsIgnoreCase("KILOPASCALS")) {
            return UnitImpl.KILOPASCAL;
        }
        if (unitString.equalsIgnoreCase("H/M**2*S")) {
            return UnitImpl.multiply((UnitImpl)UnitImpl.SQUARE_METER, (UnitImpl)UnitImpl.SECOND).inverse("hail intensity in hits per meter squared second");
        }
        if (unitString.equalsIgnoreCase("PERCENT") || unitString.equalsIgnoreCase("P") || unitString.equalsIgnoreCase("%")) {
            return new UnitImpl(UnitBase.COUNT, -2, "PERCENT", 1.0, 1);
        }
        if (unitString.equalsIgnoreCase("MBAR")) {
            return UnitImpl.MILLIBAR;
        }
        if (unitString.equalsIgnoreCase("C") || unitString.equalsIgnoreCase("TC") || unitString.equalsIgnoreCase("CELSIUS") || unitString.equalsIgnoreCase("DEGC")) {
            return UnitImpl.CELSIUS;
        }
        if (unitString.equalsIgnoreCase("S") || unitString.equalsIgnoreCase("SEC")) {
            return UnitImpl.SECOND;
        }
        if (unitString.equalsIgnoreCase("USEC")) {
            return UnitImpl.MICROSECOND;
        }
        if (unitString.equalsIgnoreCase("A") || unitString.equalsIgnoreCase("AMPERES")) {
            return UnitImpl.AMPERE;
        }
        if (unitString.equalsIgnoreCase("T")) {
            return UnitImpl.TESLA;
        }
        if (unitString.equalsIgnoreCase("NT")) {
            return UnitImpl.multiply((double)1.0E-9, (UnitImpl)UnitImpl.TESLA, (String)"NANOTESLA");
        }
        if (unitString.equalsIgnoreCase("V") || unitString.equalsIgnoreCase("VOLTS") || unitString.equalsIgnoreCase("VOLT_UNIT")) {
            return UnitImpl.VOLT;
        }
        if (unitString.equalsIgnoreCase("MILLIVOLTS")) {
            return UnitImpl.multiply((double)0.001, (UnitImpl)UnitImpl.VOLT, (String)"MILLIVOLT");
        }
        if (unitString.equalsIgnoreCase("V/M")) {
            return UnitImpl.VOLT_PER_METER;
        }
        if (unitString.equalsIgnoreCase("W/M2") || unitString.equalsIgnoreCase("WATTS/M^2")) {
            return UnitImpl.divide((UnitImpl)UnitImpl.WATT, (UnitImpl)UnitImpl.SQUARE_METER);
        }
        if (unitString.equalsIgnoreCase("RAD") || unitString.equalsIgnoreCase("RADIAN") || unitString.equalsIgnoreCase("RADIANS") || unitString.equalsIgnoreCase("TILT")) {
            return UnitImpl.RADIAN;
        }
        if (unitString.equalsIgnoreCase("MICRORADIANS")) {
            return UnitImpl.multiply((double)1.0E-6, (UnitImpl)UnitImpl.RADIAN, (String)"MICRORADIAN");
        }
        if (unitString.equalsIgnoreCase("RAD/S")) {
            return UnitImpl.RADIAN_PER_SECOND;
        }
        if (unitString.equalsIgnoreCase("MM/HOUR")) {
            return UnitImpl.divide((UnitImpl)UnitImpl.MILLIMETER, (UnitImpl)UnitImpl.HOUR);
        }
        if (unitString.equalsIgnoreCase("D") || unitString.equalsIgnoreCase("DEGREES")) {
            return UnitImpl.DEGREE;
        }
        if (unitString.equalsIgnoreCase("DEGC")) {
            return UnitImpl.CELSIUS;
        }
        if (unitString.equalsIgnoreCase("COUNTS") || unitString.equalsIgnoreCase("COUNT_UNIT")) {
            return UnitImpl.COUNT;
        }
        if (unitString.equalsIgnoreCase("REBOOTS") || unitString.equalsIgnoreCase("CYCLES") || unitString.equalsIgnoreCase("ERROR") || unitString.equalsIgnoreCase("BYTES") || unitString.equalsIgnoreCase("GAPS")) {
            return UnitImpl.COUNT;
        }
        if (unitString.equalsIgnoreCase("B") && unitDescription.trim().equalsIgnoreCase("boolean")) {
            return UnitImpl.DIMENSONLESS;
        }
        if (unitString.equalsIgnoreCase("1") || unitString.equalsIgnoreCase("M/M") || unitString.equalsIgnoreCase("NULL")) {
            return UnitImpl.divide((UnitImpl)UnitImpl.METER, (UnitImpl)UnitImpl.METER);
        }
        if (unitString.equalsIgnoreCase("M**3/M**3")) {
            return UnitImpl.CUBIC_METER_PER_CUBIC_METER;
        }
        if (unitString.equalsIgnoreCase("BITS/SEC")) {
            return UnitImpl.divide((UnitImpl)UnitImpl.COUNT, (UnitImpl)UnitImpl.SECOND);
        }
        if (unitString.equalsIgnoreCase("C/S")) {
            return UnitImpl.divide((UnitImpl)UnitImpl.COULOMB, (UnitImpl)UnitImpl.SECOND);
        }
        try {
            return UnitImpl.getUnitFromString((String)unitString);
        }
        catch (NoSuchFieldException e) {
            throw new StationXMLException("Unknown unit: '" + unitString + "' described as " + unitDescription);
        }
    }

    public static Time convertTime(String xml) {
        return new MicroSecondDate(xml).getFissuresTime();
    }

    public static Time convertTime(String xml, String defaultTime) {
        String s = xml;
        if (xml == null) {
            s = defaultTime;
        }
        return new MicroSecondDate(s).getFissuresTime();
    }

    public static String makeNoNull(String s) {
        if (s == null) {
            return UNKNOWN;
        }
        return s;
    }

    static {
        UNITY_POLE_ZERO.pole_zero_filter(new PoleZeroFilter(new ComplexNumberErrored[]{new ComplexNumberErrored(0.0f, 0.0f, 0.0f, 0.0f)}, new ComplexNumberErrored[]{new ComplexNumberErrored(0.0f, 0.0f, 0.0f, 0.0f)}));
        UNITY_COEFFICENT_FILTER.coeff_filter(new CoefficientFilter(new CoefficientErrored[]{new CoefficientErrored(1.0f, 0.0f)}, new CoefficientErrored[0]));
        ONE_SECOND = new TimeInterval(1.0, UnitImpl.SECOND);
        logger = LoggerFactory.getLogger(StationXMLToFissures.class);
    }
}

