/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.rt130.packetTypes;

import edu.sc.seis.fissuresUtil.rt130.BCDRead;
import edu.sc.seis.fissuresUtil.rt130.HexRead;
import edu.sc.seis.fissuresUtil.rt130.PacketType;
import edu.sc.seis.fissuresUtil.rt130.RT130FormatException;
import java.io.DataInput;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataPacket
extends PacketType {
    public String dataFormat;
    public byte[] dataFrames;
    public byte flags;
    public int eventNumber;
    public int dataStreamNumber;
    public int channelNumber;
    public int numberOfSamples;
    private static final Logger logger = LoggerFactory.getLogger(DataPacket.class);

    public DataPacket(DataPacket original) throws RT130FormatException {
        if (original != null) {
            this.dataFormat = original.dataFormat;
            if (this.dataFormat.equals("C0")) {
                this.dataFrames = new byte[original.dataFrames.length];
                for (int i = 0; i < original.dataFrames.length; ++i) {
                    this.dataFrames[i] = original.dataFrames[i];
                }
            } else {
                logger.error("The data in this packet is not in compressed format. This file reader is not prepaired to read uncompressed seismogram data. Throwing a format exception even though this format is valid.");
                throw new RT130FormatException("Can not currently read uncompressed format.");
            }
            this.flags = original.flags;
            this.eventNumber = original.eventNumber;
            this.dataStreamNumber = original.dataStreamNumber;
            this.channelNumber = original.channelNumber;
            this.numberOfSamples = original.numberOfSamples;
        }
    }

    public DataPacket(DataInput in, boolean processData) throws IOException, RT130FormatException {
        this.read(in, processData);
    }

    private void read(DataInput in, boolean processData) throws IOException, RT130FormatException {
        this.eventNumber = BCDRead.toInt(this.readBytes(in, 2));
        this.dataStreamNumber = BCDRead.toInt(this.readBytes(in, 1));
        this.channelNumber = BCDRead.toInt(this.readBytes(in, 1));
        this.numberOfSamples = BCDRead.toInt(this.readBytes(in, 2));
        byte[] flagsArray = this.readBytes(in, 1);
        this.flags = flagsArray[0];
        this.dataFormat = HexRead.toString(this.readBytes(in, 1));
        if (this.dataFormat.equals("C0")) {
            in.skipBytes(40);
            if (processData) {
                this.dataFrames = this.readBytes(in, 960);
            } else {
                this.dataFrames = new byte[0];
                in.skipBytes(960);
            }
        } else {
            logger.error("The data in this packet is not in compressed format. This file reader is not prepaired to read uncompressed seismogram data. Throwing a format exception even though this format is valid.");
            throw new RT130FormatException("Can not currently read uncompressed format.");
        }
    }

    private byte[] readBytes(DataInput in, int numBytes) throws IOException {
        byte[] seqBytes = new byte[numBytes];
        in.readFully(seqBytes);
        return seqBytes;
    }
}

