/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.rt130;

import edu.iris.Fissures.IfNetwork.Channel;
import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.IfParameterMgr.ParameterRef;
import edu.iris.Fissures.IfSeismogramDC.Property;
import edu.iris.Fissures.IfTimeSeries.TimeSeriesDataSel;
import edu.iris.Fissures.Quantity;
import edu.iris.Fissures.Sampling;
import edu.iris.Fissures.Unit;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.model.SamplingImpl;
import edu.iris.Fissures.model.TimeInterval;
import edu.iris.Fissures.model.UnitImpl;
import edu.iris.Fissures.network.ChannelIdUtil;
import edu.iris.Fissures.seismogramDC.LocalSeismogramImpl;
import edu.sc.seis.fissuresUtil.rt130.DASChannelCreator;
import edu.sc.seis.fissuresUtil.rt130.LeapSecondApplier;
import edu.sc.seis.fissuresUtil.rt130.PacketType;
import edu.sc.seis.fissuresUtil.rt130.PropParser;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RT130ToLocalSeismogram {
    private Channel[] channel;
    public static final String DATA_STREAM = "dataStream.";
    private Map dataStreamToSampleRate;
    private DASChannelCreator chanCreator;
    private static final Logger logger = LoggerFactory.getLogger(RT130ToLocalSeismogram.class);

    public RT130ToLocalSeismogram() {
    }

    public static RT130ToLocalSeismogram create(Properties props) throws IOException {
        PropParser pp = new PropParser(props);
        return new RT130ToLocalSeismogram(new DASChannelCreator(props), RT130ToLocalSeismogram.makeDataStreamToSampleRate(props, pp));
    }

    public static Map makeDataStreamToSampleRate(Properties props, PropParser pp) {
        HashMap<Integer, Integer> dataStreamToSampleRate = new HashMap<Integer, Integer>();
        for (int i = 1; i < 7; ++i) {
            if (!props.containsKey(DATA_STREAM + i)) continue;
            dataStreamToSampleRate.put(new Integer(i - 1), new Integer(pp.getInt(DATA_STREAM + i)));
        }
        return dataStreamToSampleRate;
    }

    public RT130ToLocalSeismogram(DASChannelCreator chanCreator, Map dataStreamToSampleRate) {
        this.chanCreator = chanCreator;
        this.dataStreamToSampleRate = dataStreamToSampleRate;
    }

    public LocalSeismogramImpl[] convert(PacketType[] seismogramDataPacket) {
        LocalSeismogramImpl[] seismogramDataArray = new LocalSeismogramImpl[seismogramDataPacket.length];
        this.channel = null;
        for (int i = 0; i < seismogramDataPacket.length; ++i) {
            seismogramDataArray[i] = this.convert(seismogramDataPacket[i], i);
        }
        return seismogramDataArray;
    }

    private LocalSeismogramImpl convert(PacketType seismogramData, int i) {
        if (this.channel == null) {
            this.channel = this.createChannel(seismogramData);
        }
        int numPoints = seismogramData.number_of_samples;
        if (seismogramData.sample_rate == 0) {
            logger.debug("A sample rate of 0 samples per second was detected for data stream number " + seismogramData.data_stream_number + ".");
            Integer dataStream = new Integer(seismogramData.data_stream_number);
            if (this.dataStreamToSampleRate.containsKey(dataStream)) {
                seismogramData.sample_rate = (Integer)this.dataStreamToSampleRate.get(dataStream);
                logger.debug("The sample rate of " + seismogramData.sample_rate + " was found in the props file, and will be used.");
            } else {
                logger.error("The props file does not contain a sample rate for this data stream, and can not be used to correct the problem.");
            }
        }
        SamplingImpl sampling = new SamplingImpl(seismogramData.sample_rate, new TimeInterval(1.0, UnitImpl.SECOND));
        ChannelId id = this.channel[seismogramData.channel_number].get_id();
        TimeSeriesDataSel timeSeriesDataSel = new TimeSeriesDataSel();
        timeSeriesDataSel.encoded_values(seismogramData.encoded_data);
        MicroSecondDate beginTimeOfSeismogram = LeapSecondApplier.applyLeapSecondCorrection(seismogramData.unitIdNumber, seismogramData.getBeginTimeOfSeismogram());
        Property[] properties = new Property[]{};
        TimeInterval correction = seismogramData.getBeginTimeOfSeismogram().subtract(beginTimeOfSeismogram);
        properties = new Property[]{new Property("SNEP Server Leap Seconds", "" + correction.getValue(UnitImpl.SECOND))};
        LocalSeismogramImpl out = new LocalSeismogramImpl(ChannelIdUtil.toString((ChannelId)id), properties, beginTimeOfSeismogram.getFissuresTime(), numPoints, (Sampling)sampling, (Unit)UnitImpl.COUNT, id, new ParameterRef[0], new Quantity[0], new Sampling[0], timeSeriesDataSel);
        return out;
    }

    private Channel[] createChannel(PacketType seismogramData) {
        return this.chanCreator.create(seismogramData.unitIdNumber, seismogramData.getBeginTimeOfSeismogram(), "" + seismogramData.data_stream_number + 1, seismogramData.sample_rate);
    }

    public Channel[] getChannels() {
        return this.channel;
    }
}

