/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.netConnChecker;

import edu.sc.seis.fissuresUtil.cache.WorkerThreadPool;
import edu.sc.seis.fissuresUtil.netConnChecker.ConnChecker;
import edu.sc.seis.fissuresUtil.netConnChecker.ConnStatus;
import edu.sc.seis.fissuresUtil.netConnChecker.ConnStatusResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Checker {
    private List connCheckers = Collections.synchronizedList(new ArrayList());
    private static Logger logger = LoggerFactory.getLogger(Checker.class);
    private WorkerThreadPool pool = new WorkerThreadPool("Connection Checker Pool", 3);
    private ThreadGroup checkerThreadGroup = new ThreadGroup("Connection Checker");

    public Checker() {
    }

    public Checker(Collection connCheckerCollectionReceived) {
        this.connCheckers.addAll(connCheckerCollectionReceived);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runChecks() {
        List list = this.connCheckers;
        synchronized (list) {
            Iterator it = this.connCheckers.iterator();
            while (it.hasNext()) {
                this.pool.invokeLater((ConnChecker)it.next());
            }
        }
    }

    public void add(ConnChecker connChecker) {
        this.connCheckers.add(connChecker);
        this.pool.invokeLater(connChecker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnStatus getStatus(Class checkerClass) {
        boolean trying = false;
        boolean foundOne = false;
        List list = this.connCheckers;
        synchronized (list) {
            for (ConnChecker connChecker : this.connCheckers) {
                if (checkerClass.isAssignableFrom(connChecker.getClass())) {
                    ConnStatusResult curStatus = connChecker.getStatus();
                    if (curStatus.getStatus() == ConnStatus.SUCCESSFUL) {
                        return ConnStatus.SUCCESSFUL;
                    }
                    if (curStatus.getStatus() != ConnStatus.TRYING) continue;
                    trying = true;
                    continue;
                }
                logger.warn("Skipping " + checkerClass.getName() + "  " + connChecker.getClass().getName());
            }
        }
        if (trying && foundOne) {
            return ConnStatus.TRYING;
        }
        return ConnStatus.FAILED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnStatus getStatus() {
        boolean trying = false;
        List list = this.connCheckers;
        synchronized (list) {
            Iterator it = this.connCheckers.iterator();
            while (it.hasNext()) {
                ConnStatusResult curStatus = ((ConnChecker)it.next()).getStatus();
                if (curStatus.getStatus() == ConnStatus.SUCCESSFUL) {
                    return ConnStatus.SUCCESSFUL;
                }
                if (curStatus.getStatus() != ConnStatus.TRYING) continue;
                trying = true;
            }
        }
        if (trying) {
            return ConnStatus.TRYING;
        }
        return ConnStatus.FAILED;
    }

    public ConnChecker[] getCheckers() {
        ConnChecker[] checkers = new ConnChecker[this.connCheckers.size()];
        return this.connCheckers.toArray(checkers);
    }
}

