/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.map.graphics;

import com.bbn.openmap.Layer;
import com.bbn.openmap.event.CenterEvent;
import com.bbn.openmap.omGraphics.OMCircle;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicList;
import edu.iris.Fissures.IfEvent.NoPreferredOrigin;
import edu.sc.seis.fissuresUtil.cache.ProxyEventAccessOperations;
import edu.sc.seis.fissuresUtil.display.DisplayUtils;
import edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler;
import edu.sc.seis.fissuresUtil.flow.extractor.event.MagnitudeValueExtractor;
import edu.sc.seis.fissuresUtil.flow.extractor.model.LocationExtractor;
import edu.sc.seis.fissuresUtil.map.OpenMap;
import edu.sc.seis.fissuresUtil.map.colorizer.event.DefaultEventColorizer;
import edu.sc.seis.fissuresUtil.map.graphics.FissuresGraphic;
import java.awt.Color;
import java.awt.Paint;

public class OMEvent
extends OMGraphicList
implements FissuresGraphic {
    private ProxyEventAccessOperations event;
    private OpenMap map;
    private OMCircle lilCircle;
    private OMCircle bigCircle;

    public OMEvent(ProxyEventAccessOperations eao, Layer eventLayer, OpenMap map) {
        super(2);
        this.map = map;
        LocationExtractor le = new LocationExtractor();
        float lat = le.extract((Object)eao).latitude;
        float lon = le.extract((Object)eao).longitude;
        float mag = new MagnitudeValueExtractor().extract(eao);
        double scale = 1.8;
        int lilDiameter = (int)Math.pow(scale, 3.0);
        this.lilCircle = new OMCircle(lat, lon, lilDiameter, lilDiameter);
        if ((double)mag <= 3.0) {
            this.bigCircle = new OMCircle(lat, lon, lilDiameter, lilDiameter);
        } else {
            mag = (float)Math.pow(scale, mag);
            this.bigCircle = new OMCircle(lat, lon, (int)Math.floor(mag), (int)Math.floor(mag));
        }
        this.event = eao;
        this.lilCircle.setLinePaint((Paint)Color.BLACK);
        this.bigCircle.setStroke(DisplayUtils.THREE_PIXEL_STROKE);
        this.setPaint(DefaultEventColorizer.DEFAULT_EVENT);
        this.add((OMGraphic)this.bigCircle);
        this.add((OMGraphic)this.lilCircle);
        this.generate(eventLayer.getProjection());
    }

    public ProxyEventAccessOperations getEvent() {
        return this.event;
    }

    public void select() {
        super.select();
        this.bigCircle.setFillPaint((Paint)new Color(0, 0, 0, 64));
        if (this.map.getWidthDegrees() > 300.0f) {
            try {
                this.map.getMapBean().center(new CenterEvent((Object)this, 0.0f, this.event.get_preferred_origin().getLocation().longitude));
            }
            catch (NoPreferredOrigin e) {
                GlobalExceptionHandler.handle("For some reason, a NoPreferredOrigin has been called.", e);
            }
        }
    }

    public void deselect() {
        super.deselect();
        this.bigCircle.setFillPaint((Paint)OMGraphicList.clear);
    }

    public OMCircle getBigCircle() {
        return this.bigCircle;
    }

    public void setPaint(Paint paint) {
        this.lilCircle.setFillPaint(paint);
        this.bigCircle.setLinePaint(paint);
        this.bigCircle.setSelectPaint(paint);
    }
}

