/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.freq;

import edu.sc.seis.fissuresUtil.freq.Cmplx;

public class CmplxArray2D {
    float[][] real;
    float[][] imag;

    public CmplxArray2D(int x, int y) {
        this(new float[x][y], new float[x][y]);
    }

    public CmplxArray2D(float[][] real, float[][] imag) {
        if (real.length != imag.length) {
            throw new IllegalArgumentException("real and imag arrays must have same length: " + real.length + " " + imag.length);
        }
        for (int i = 0; i < real.length; ++i) {
            if (real[0].length != real[i].length) {
                throw new IllegalArgumentException("real array must be square: " + i + "  " + real[0].length + " " + real[i].length);
            }
            if (real[i].length == imag[i].length) continue;
            throw new IllegalArgumentException("real[i] and imag[i] arrays must have same length: " + i + "  " + real[i].length + " " + imag[i].length);
        }
        this.real = real;
        this.imag = imag;
    }

    public int getXLength() {
        return this.real.length;
    }

    public int getYLength() {
        return this.real[0].length;
    }

    public float getReal(int x, int y) {
        return this.real[x][y];
    }

    public float getImag(int x, int y) {
        return this.imag[x][y];
    }

    public void setReal(int x, int y, float val) {
        this.real[x][y] = val;
    }

    public void setImag(int x, int y, float val) {
        this.imag[x][y] = val;
    }

    public Cmplx get(int x, int y) {
        return new Cmplx(this.getReal(x, y), this.getImag(x, y));
    }

    public void set(int x, int y, Cmplx val) {
        this.setReal(x, y, (float)val.real());
        this.setImag(x, y, (float)val.imag());
    }

    public final float mag(int x, int y) {
        return (float)Math.sqrt(this.getReal(x, y) * this.getReal(x, y) + this.getImag(x, y) * this.getImag(x, y));
    }
}

