/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.display.registrar;

import edu.iris.Fissures.Unit;
import edu.iris.Fissures.model.UnitImpl;
import edu.iris.Fissures.model.UnitRangeImpl;
import edu.sc.seis.fissuresUtil.display.registrar.LayoutData;
import java.util.Iterator;

public class LayoutEvent {
    public String name = "EMPTY EVENT";
    public static final UnitRangeImpl ONE_DEGREE = new UnitRangeImpl(0.0, 1.0, (Unit)UnitImpl.DEGREE);
    public static final LayoutEvent EMPTY_EVENT = new LayoutEvent(new LayoutData[0], ONE_DEGREE);
    private LayoutData[] data;
    private UnitRangeImpl distance = ONE_DEGREE;

    public LayoutEvent(LayoutData[] organizedSeismograms, UnitRangeImpl distance) {
        this.data = organizedSeismograms;
        if (distance == null) {
            throw new IllegalArgumentException("distance can not be null");
        }
        this.distance = distance;
        this.name = "not empty event";
    }

    public LayoutData getItemAt(int index) {
        return this.data[index];
    }

    public UnitRangeImpl getDistance() {
        return this.distance;
    }

    public Iterator iterator() {
        return new Iterator(){
            private int index = 0;

            @Override
            public void remove() {
                throw new UnsupportedOperationException("cannot remove from a layout event iterator");
            }

            @Override
            public boolean hasNext() {
                return this.index < LayoutEvent.this.data.length;
            }

            public Object next() {
                return LayoutEvent.this.data[this.index++];
            }
        };
    }

    public String toString() {
        return this.name;
    }
}

