/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.display.borders;

import edu.iris.Fissures.Quantity;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.model.TimeInterval;
import edu.iris.Fissures.model.UnitImpl;
import edu.iris.Fissures.model.UnitRangeImpl;
import edu.sc.seis.fissuresUtil.chooser.ThreadSafeSimpleDateFormat;
import edu.sc.seis.fissuresUtil.display.DisplayUtils;
import edu.sc.seis.fissuresUtil.display.SeismogramDisplay;
import edu.sc.seis.fissuresUtil.display.borders.Border;
import edu.sc.seis.fissuresUtil.display.borders.TitleProvider;
import edu.sc.seis.fissuresUtil.display.registrar.RTTimeRangeConfig;
import edu.sc.seis.fissuresUtil.display.registrar.RelativeTimeConfig;
import edu.sc.seis.fissuresUtil.display.registrar.TimeConfig;
import edu.sc.seis.fissuresUtil.time.MicroSecondTimeRange;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.TimeZone;

public class TimeBorder
extends Border
implements TitleProvider {
    private static double[] secDivs = new double[]{0.01, 0.02, 0.05, 0.1, 0.25, 0.5, 1.0, 2.5};
    private static double[][] minSecDivs = new double[][]{{5.0, 5.0}, {10.0, 5.0}, {20.0, 4.0}, {30.0, 6.0}};
    private static double[][] minDivs = new double[][]{{1.0, 6.0}, {2.0, 6.0}, {5.0, 5.0}, {10.0, 10.0}, {20.0, 10.0}, {30.0, 10.0}};
    private static double[][] hourDivs = new double[][]{{1.0, 6.0}, {2.0, 4.0}, {6.0, 6.0}, {12.0, 6.0}, {24.0, 4.0}, {48.0, 4.0}, {96.0, 4.0}};
    private SeismogramDisplay disp;
    private Color c = null;
    private Font titleFont = DisplayUtils.DEFAULT_FONT;
    private Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
    private ThreadSafeSimpleDateFormat axisFormat = new ThreadSafeSimpleDateFormat("MM/dd/yyyy (zzz)", TimeZone.getTimeZone("GMT"));
    public static MicroSecondTimeRange roundTheEpoch = new MicroSecondTimeRange(new MicroSecondDate(0L), new TimeInterval(20.0, UnitImpl.DAY));
    private static Date FULL_DATE;

    public TimeBorder(SeismogramDisplay disp) {
        this(disp, 2);
    }

    public TimeBorder(SeismogramDisplay disp, int position) {
        super(position, 0);
        this.add(this);
        this.disp = disp;
        this.setPreferredSize(new Dimension(250, 50));
    }

    public RelativeTimeConfig getRelative(TimeConfig tc) {
        if (tc instanceof RTTimeRangeConfig) {
            return this.getRelative(((RTTimeRangeConfig)tc).getInternalConfig());
        }
        return (RelativeTimeConfig)tc;
    }

    @Override
    public String getTitle() {
        MicroSecondTimeRange time = this.disp.getTimeConfig().getTime();
        if (roundTheEpoch.intersects(time)) {
            return this.getRelative(this.disp.getTimeConfig()).getTypeOfRelativity();
        }
        MicroSecondDate middleDate = time.getBeginTime().add(new TimeInterval((Quantity)time.getInterval().divideBy(2.0)));
        this.calendar.setTime((Date)middleDate);
        return this.axisFormat.format(this.calendar.getTime());
    }

    @Override
    public void setTitleFont(Font f) {
        this.titleFont = f;
    }

    @Override
    public Font getTitleFont() {
        return this.titleFont;
    }

    @Override
    protected UnitRangeImpl getRange() {
        return this.disp.getTimeConfig().getTime().getMillis();
    }

    @Override
    protected List createFormats() {
        ArrayList<TimeBorderFormat> formats = new ArrayList<TimeBorderFormat>();
        formats.add(new TimeBorderFormat("mm:ss.SSS", new TimeInterval(1.0, UnitImpl.MILLISECOND)));
        formats.add(new TimeBorderFormat("mm:ss.SSS", new TimeInterval(10.0, UnitImpl.MILLISECOND)));
        this.createSecondFormats(secDivs, formats);
        this.createMinuteSecondFormats(minSecDivs, formats);
        this.createMinuteFormats(minDivs, formats);
        this.createHourFormats(hourDivs, formats);
        return formats;
    }

    private void createSecondFormats(double[] secondsPerDivision, List recip) {
        for (int i = 0; i < secondsPerDivision.length; ++i) {
            this.createSecondFormat(secondsPerDivision[i], recip);
        }
    }

    private void createSecondFormat(double secondsPerDivision, List recip) {
        TimeInterval inter = new TimeInterval(secondsPerDivision, UnitImpl.SECOND);
        recip.add(new TimeBorderFormat("mm:ss.SSS", inter));
    }

    private void createMinuteSecondFormats(double[][] divs, List recip) {
        for (int i = 0; i < divs.length; ++i) {
            this.createHourFormat(divs[i][0], (int)divs[i][1], recip, UnitImpl.SECOND);
        }
    }

    private void createMinuteFormats(double[][] divs, List recip) {
        for (int i = 0; i < divs.length; ++i) {
            this.createHourFormat(divs[i][0], (int)divs[i][1], recip, UnitImpl.MINUTE);
        }
    }

    private void createHourFormat(double minutesPerDivision, int divPerLabel, List recip, UnitImpl unit) {
        TimeInterval inter = new TimeInterval(minutesPerDivision, unit);
        recip.add(new TimeBorderFormat("HH:mm:ss", inter, divPerLabel));
    }

    private void createHourFormats(double[][] divs, List recip) {
        for (int i = 0; i < divs.length; ++i) {
            this.createDayFormat(divs[i][0], (int)divs[i][1], recip);
        }
    }

    private void createDayFormat(double hoursPerDivision, int divPerLabel, List recip) {
        TimeInterval inter = new TimeInterval(hoursPerDivision, UnitImpl.HOUR);
        recip.add(new TimeBorderFormat("MM/dd HH:mm", inter, divPerLabel));
    }

    @Override
    public String getMaxLengthFormattedString() {
        return "MM/dd HH:mm";
    }

    @Override
    public Color getTitleColor() {
        return this.c;
    }

    @Override
    public void setTitleColor(Color newColor) {
        this.c = newColor;
    }

    static {
        Calendar cal = GregorianCalendar.getInstance();
        cal.setTimeZone(TimeZone.getTimeZone("EST"));
        cal.set(1999, 12, 31, 12, 59, 59);
        FULL_DATE = cal.getTime();
        FULL_DATE.setTime(FULL_DATE.getTime() + 999L);
    }

    class TimeBorderFormat
    extends Border.BorderFormat {
        private ThreadSafeSimpleDateFormat format;

        public TimeBorderFormat(String format, TimeInterval labelInterval) {
            this(format, labelInterval, 10);
        }

        public TimeBorderFormat(String format, TimeInterval labelInterval, int ticksPerDivision) {
            super(labelInterval.convertTo(UnitImpl.MILLISECOND).getValue(), ticksPerDivision);
            this.format = new ThreadSafeSimpleDateFormat(format, TimeZone.getTimeZone("GMT"));
        }

        @Override
        public String getLabel(double value) {
            return this.format.format(new Date((long)value));
        }

        @Override
        public String getMaxString() {
            return this.format.format(FULL_DATE);
        }
    }
}

