/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.display;

import edu.iris.Fissures.IfSeismogramDC.LocalSeismogram;
import edu.iris.Fissures.Plottable;
import edu.iris.Fissures.Quantity;
import edu.iris.Fissures.Unit;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.model.QuantityImpl;
import edu.iris.Fissures.model.SamplingImpl;
import edu.iris.Fissures.model.TimeInterval;
import edu.iris.Fissures.model.UnitImpl;
import edu.iris.Fissures.model.UnitRangeImpl;
import edu.iris.Fissures.seismogramDC.LocalSeismogramImpl;
import edu.iris.dmc.seedcodec.CodecException;
import edu.sc.seis.fissuresUtil.display.IntRange;
import edu.sc.seis.fissuresUtil.hibernate.PlottableChunk;
import edu.sc.seis.fissuresUtil.time.MicroSecondTimeRange;
import java.awt.Dimension;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimplePlotUtil {
    public static final TimeInterval ONE_DAY = new TimeInterval(1.0, UnitImpl.DAY);
    private static final Logger logger = LoggerFactory.getLogger(SimplePlotUtil.class);

    public static Plottable makePlottable(LocalSeismogramImpl seis, int pixelsPerDay) throws CodecException {
        MicroSecondTimeRange correctedSeisRange = SimplePlotUtil.correctTimeRangeForPixelData((LocalSeismogram)seis, pixelsPerDay);
        int startPoint = SimplePlotUtil.getPoint(seis, correctedSeisRange.getBeginTime());
        int endPoint = SimplePlotUtil.getPoint(seis, correctedSeisRange.getEndTime());
        IntRange seisPixelRange = SimplePlotUtil.getDayPixelRange((LocalSeismogram)seis, pixelsPerDay, seis.getBeginTime());
        int numPixels = seisPixelRange.getDifference();
        MicroSecondDate rangeEnd = correctedSeisRange.getBeginTime().add(new TimeInterval((Quantity)SimplePlotUtil.getPixelPeriod(pixelsPerDay).multiplyBy((double)numPixels)));
        boolean corrected = false;
        if (rangeEnd.after((Date)correctedSeisRange.getEndTime())) {
            --numPixels;
            corrected = true;
        }
        int startPixel = seisPixelRange.getMin();
        int[][] pixels = new int[2][numPixels * 2];
        int pixelPoint = startPixel < 0 ? 0 : startPoint;
        MicroSecondDate pixelEndTime = correctedSeisRange.getBeginTime();
        TimeInterval pixelPeriod = SimplePlotUtil.getPixelPeriod(pixelsPerDay);
        if (corrected) {
            // empty if block
        }
        for (int i = 0; i < numPixels; ++i) {
            pixelEndTime = pixelEndTime.add(pixelPeriod);
            int pos = 2 * i;
            int nextPos = pos + 1;
            pixels[0][pos] = startPixel + i;
            pixels[0][nextPos] = pixels[0][pos];
            int nextPixelPoint = SimplePlotUtil.getPixel(startPoint, endPoint, correctedSeisRange.getBeginTime(), correctedSeisRange.getEndTime(), pixelEndTime);
            QuantityImpl min = seis.getMinValue(pixelPoint, nextPixelPoint);
            pixels[1][pos] = (int)min.getValue();
            QuantityImpl max = seis.getMaxValue(pixelPoint, nextPixelPoint);
            pixels[1][nextPos] = (int)max.getValue();
            if (corrected && (i < 2 || i >= numPixels - 2)) {
                logger.debug(pixels[0][pos] + ": min " + min.value + " max " + max.value);
            }
            pixelPoint = nextPixelPoint;
        }
        return new Plottable(pixels[0], pixels[1]);
    }

    public static Plottable getEmptyPlottable() {
        int[] empty = new int[]{};
        return new Plottable(empty, empty);
    }

    public static void debugExtraPixel(MicroSecondTimeRange correctedSeisRange, MicroSecondDate rangeEnd, LocalSeismogramImpl seis, int startPoint, int endPoint, int numPixels, IntRange seisPixelRange, int startPixel, TimeInterval pixelPeriod) {
        logger.warn("corrected for freak extra pixel!");
        logger.debug("correctedSeisRange: " + correctedSeisRange);
        logger.debug("end of range would have been " + rangeEnd + " without correction");
        logger.debug("seis.num_points: " + seis.num_points);
        logger.debug("startPoint: " + startPoint);
        logger.debug("endPoint: " + endPoint);
        logger.debug("seisPixelRange: " + seisPixelRange);
        logger.debug("numPixels after correction: " + numPixels);
        logger.debug("startPixel: " + startPixel);
        logger.debug("pixelPeriod: " + pixelPeriod);
    }

    public static TimeInterval getPixelPeriod(int pixelsPerDay) {
        double pixelPeriod = 1.0 / (double)pixelsPerDay;
        return new TimeInterval(pixelPeriod, UnitImpl.DAY);
    }

    public static MicroSecondDate getBeginningOfDay(MicroSecondDate date) {
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        cal.setTime((Date)date);
        cal.set(13, 0);
        cal.set(12, 0);
        cal.set(11, 0);
        cal.set(14, 0);
        return new MicroSecondDate(cal.getTime());
    }

    public static MicroSecondTimeRange getDay(MicroSecondDate date) {
        return new MicroSecondTimeRange(SimplePlotUtil.getBeginningOfDay(date), ONE_DAY);
    }

    public static MicroSecondDate getPixelBeginTime(MicroSecondTimeRange day, int pixel, int pixelsPerDay) {
        TimeInterval pixelPeriod = SimplePlotUtil.getPixelPeriod(pixelsPerDay);
        return day.getBeginTime().add(new TimeInterval((Quantity)pixelPeriod.multiplyBy((double)pixel)));
    }

    public static MicroSecondTimeRange getPixelTimeRange(MicroSecondDate point, int pixelsPerDay, boolean after) {
        TimeInterval pixelPeriod = SimplePlotUtil.getPixelPeriod(pixelsPerDay);
        MicroSecondTimeRange day = SimplePlotUtil.getDay(point);
        int pixel = SimplePlotUtil.getPixel(pixelsPerDay, day, point);
        if (after) {
            ++pixel;
        }
        MicroSecondDate pixelBegin = SimplePlotUtil.getPixelBeginTime(day, pixel, pixelsPerDay);
        return new MicroSecondTimeRange(pixelBegin, pixelPeriod);
    }

    public static IntRange getDayPixelRange(LocalSeismogram seis, int pixelsPerDay) {
        return SimplePlotUtil.getDayPixelRange(seis, pixelsPerDay, SimplePlotUtil.getBeginningOfDay(new MicroSecondDate(seis.begin_time)));
    }

    public static IntRange getDayPixelRange(LocalSeismogram seis, int pixelsPerDay, MicroSecondDate startOfDay) {
        int endPixel;
        MicroSecondTimeRange seisTR = new MicroSecondTimeRange((LocalSeismogramImpl)seis);
        MicroSecondTimeRange dayTR = new MicroSecondTimeRange(startOfDay, ONE_DAY);
        int startPixel = SimplePlotUtil.getPixel(pixelsPerDay, dayTR, seisTR.getBeginTime());
        if (SimplePlotUtil.getPixelTimeRange(seisTR.getBeginTime(), pixelsPerDay, false).getBeginTime().before((Date)seisTR.getBeginTime())) {
            ++startPixel;
        }
        if ((endPixel = SimplePlotUtil.getPixel(pixelsPerDay, dayTR, seisTR.getEndTime())) < startPixel) {
            endPixel = startPixel;
        }
        return new IntRange(startPixel, endPixel);
    }

    public static boolean canMakeAtLeastOnePixel(LocalSeismogram seis, int pixelsPerDay) {
        IntRange pixelRange = SimplePlotUtil.getDayPixelRange(seis, pixelsPerDay);
        return pixelRange.getMax() > pixelRange.getMin();
    }

    public static MicroSecondTimeRange correctTimeRangeForPixelData(LocalSeismogram seis, int pixelsPerDay) {
        IntRange pixelRange = SimplePlotUtil.getDayPixelRange(seis, pixelsPerDay);
        MicroSecondTimeRange day = SimplePlotUtil.getDay(new MicroSecondDate(seis.begin_time));
        MicroSecondDate start = SimplePlotUtil.getPixelBeginTime(day, pixelRange.getMin(), pixelsPerDay);
        MicroSecondDate end = SimplePlotUtil.getPixelBeginTime(day, pixelRange.getMax(), pixelsPerDay);
        return new MicroSecondTimeRange(start, end);
    }

    public static int[][] compressXvalues(LocalSeismogram seismogram, MicroSecondTimeRange timeRange, Dimension size) throws CodecException {
        LocalSeismogramImpl seis = (LocalSeismogramImpl)seismogram;
        int width = size.width;
        int[][] out = new int[2][];
        if (seis.getEndTime().before((Date)timeRange.getBeginTime()) || seis.getBeginTime().after((Date)timeRange.getEndTime())) {
            out[0] = new int[0];
            out[1] = new int[0];
            logger.info("The end time is before the beginTime in simple seismogram");
            return out;
        }
        MicroSecondDate tMin = timeRange.getBeginTime();
        MicroSecondDate tMax = timeRange.getEndTime();
        int seisStartIndex = SimplePlotUtil.getPoint(seis, tMin);
        int seisEndIndex = SimplePlotUtil.getPoint(seis, tMax);
        if (seisStartIndex < 0) {
            seisStartIndex = 0;
        }
        if (seisEndIndex >= seis.getNumPoints()) {
            seisEndIndex = seis.getNumPoints() - 1;
        }
        MicroSecondDate tempdate = SimplePlotUtil.getValue(seis.getNumPoints(), seis.getBeginTime(), seis.getEndTime(), seisStartIndex);
        int pixelStartIndex = SimplePlotUtil.getPixel(width, timeRange, tempdate);
        tempdate = SimplePlotUtil.getValue(seis.getNumPoints(), seis.getBeginTime(), seis.getEndTime(), seisEndIndex);
        int pixelEndIndex = SimplePlotUtil.getPixel(width, timeRange, tempdate);
        int pixels = seisEndIndex - seisStartIndex + 1;
        out[0] = new int[2 * pixels];
        out[1] = new int[out[0].length];
        int[] tempYvalues = new int[out[0].length];
        int seisIndex = seisStartIndex;
        int numAdded = 0;
        int xvalue = Math.round((float)SimplePlotUtil.linearInterp(seisStartIndex, pixelStartIndex, seisEndIndex, pixelEndIndex, seisIndex));
        int tempValue = 0;
        ++seisIndex;
        int j = 0;
        while (seisIndex <= seisEndIndex) {
            tempValue = Math.round((float)SimplePlotUtil.linearInterp(seisStartIndex, pixelStartIndex, seisEndIndex, pixelEndIndex, seisIndex));
            tempYvalues[j++] = (int)seis.getValueAt(seisIndex).getValue();
            if (tempValue != xvalue) {
                out[0][numAdded] = xvalue;
                out[0][numAdded + 1] = xvalue;
                out[1][numAdded] = SimplePlotUtil.getMinValue(tempYvalues, 0, j - 1);
                out[1][numAdded + 1] = SimplePlotUtil.getMaxValue(tempYvalues, 0, j - 1);
                j = 0;
                xvalue = tempValue;
                numAdded += 2;
            }
            ++seisIndex;
        }
        int[][] temp = new int[2][numAdded];
        System.arraycopy(out[0], 0, temp[0], 0, numAdded);
        System.arraycopy(out[1], 0, temp[1], 0, numAdded);
        return temp;
    }

    private static int getMinValue(int[] yValues, int startIndex, int endIndex) {
        int minValue = Integer.MAX_VALUE;
        for (int i = startIndex; i <= endIndex; ++i) {
            if (yValues[i] >= minValue) continue;
            minValue = yValues[i];
        }
        return minValue;
    }

    private static int getMaxValue(int[] yValues, int startIndex, int endIndex) {
        int maxValue = Integer.MIN_VALUE;
        for (int i = startIndex; i <= endIndex; ++i) {
            if (yValues[i] <= maxValue) continue;
            maxValue = yValues[i];
        }
        return maxValue;
    }

    public static final double linearInterp(double xa, double ya, double xb, double yb, double x) {
        if (x == xa) {
            return ya;
        }
        if (x == xb) {
            return yb;
        }
        return (yb - ya) * (x - xa) / (xb - xa) + ya;
    }

    public static final int getPixel(int totalPixels, MicroSecondTimeRange tr, MicroSecondDate value) {
        return SimplePlotUtil.getPixel(totalPixels, tr.getBeginTime(), tr.getEndTime(), value);
    }

    public static final int getPoint(LocalSeismogramImpl seis, MicroSecondDate time) {
        return SimplePlotUtil.getPixel(seis.getNumPoints(), seis.getBeginTime(), seis.getEndTime(), time);
    }

    public static final int getPixel(int totalPixels, MicroSecondDate begin, MicroSecondDate end, MicroSecondDate value) {
        return SimplePlotUtil.getPixel(0, totalPixels, begin, end, value);
    }

    public static final int getPixel(int startPixel, int endPixel, MicroSecondDate begin, MicroSecondDate end, MicroSecondDate value) {
        return (int)SimplePlotUtil.linearInterp(begin.getMicroSecondTime(), startPixel, end.getMicroSecondTime(), endPixel, value.getMicroSecondTime());
    }

    public static final MicroSecondDate getValue(int totalPixels, MicroSecondDate begin, MicroSecondDate end, int pixel) {
        return SimplePlotUtil.getValue(0, totalPixels, begin, end, pixel);
    }

    public static final MicroSecondDate getValue(int startPixel, int endPixel, MicroSecondDate begin, MicroSecondDate end, int pixel) {
        double value = SimplePlotUtil.linearInterp(startPixel, 0.0, endPixel, end.getMicroSecondTime() - begin.getMicroSecondTime(), pixel);
        return new MicroSecondDate(begin.getMicroSecondTime() + (long)value);
    }

    public static final int getPixel(int totalPixels, UnitRangeImpl range, QuantityImpl value) {
        QuantityImpl converted = value.convertTo(range.getUnit());
        return SimplePlotUtil.getPixel(totalPixels, range, converted.getValue());
    }

    public static final int getPixel(int totalPixels, UnitRangeImpl range, double value) {
        return (int)SimplePlotUtil.linearInterp(range.getMinValue(), 0.0, range.getMaxValue(), totalPixels, value);
    }

    public static final QuantityImpl getValue(int totalPixels, UnitRangeImpl range, int pixel) {
        double value = SimplePlotUtil.linearInterp(0.0, range.getMinValue(), totalPixels, range.getMaxValue(), pixel);
        return new QuantityImpl(value, (Unit)range.getUnit());
    }

    public static final MicroSecondDate getTimeForIndex(int index, MicroSecondDate beginTime, SamplingImpl sampling) {
        TimeInterval width = sampling.getPeriod();
        width = (TimeInterval)width.multiplyBy((double)index);
        return beginTime.add(width);
    }

    public static List<PlottableChunk> makePlottables(LocalSeismogram[] seis, int pixelsPerDay) throws IOException {
        ArrayList<PlottableChunk> chunks = new ArrayList<PlottableChunk>();
        for (int i = 0; i < seis.length; ++i) {
            LocalSeismogramImpl curSeis = (LocalSeismogramImpl)seis[i];
            if (curSeis.getNumPoints() <= 0 || !SimplePlotUtil.canMakeAtLeastOnePixel(seis[i], pixelsPerDay)) continue;
            try {
                Plottable plott = SimplePlotUtil.makePlottable(curSeis, pixelsPerDay);
                if (plott.x_coor.length <= 0) continue;
                MicroSecondDate plotStartTime = SimplePlotUtil.getBeginningOfDay(curSeis.getBeginTime());
                PlottableChunk chunk = new PlottableChunk(plott, SimplePlotUtil.getDayPixelRange(seis[i], pixelsPerDay, plotStartTime).getMin(), plotStartTime, pixelsPerDay, curSeis.channel_id.network_id.network_code, curSeis.channel_id.station_code, curSeis.channel_id.site_code, curSeis.channel_id.channel_code);
                chunks.add(chunk);
                continue;
            }
            catch (CodecException e) {
                logger.warn("unable to make plottable for " + curSeis + ", skipping.", (Throwable)e);
            }
        }
        return chunks;
    }

    public static List<PlottableChunk> convertToCommonPixelScale(List<PlottableChunk> chunks, MicroSecondTimeRange requestRange, int pixelsPerDay) {
        int requestPixels = SimplePlotUtil.getPixels(pixelsPerDay, requestRange);
        ArrayList<PlottableChunk> outChunks = new ArrayList<PlottableChunk>();
        for (PlottableChunk pc : chunks) {
            if (pc.getEndTime().before((Date)requestRange.getBeginTime())) continue;
            MicroSecondDate rowBeginTime = pc.getBeginTime();
            int offsetIntoRequestPixels = SimplePlotUtil.getPixel(requestPixels, requestRange, rowBeginTime);
            int numPixels = pc.getNumPixels();
            int firstPixelForRequest = 0;
            if (offsetIntoRequestPixels < 0) {
                firstPixelForRequest = -1 * offsetIntoRequestPixels;
            }
            int lastPixelForRequest = numPixels;
            if (offsetIntoRequestPixels + numPixels > requestPixels) {
                lastPixelForRequest = requestPixels - offsetIntoRequestPixels;
            }
            if (firstPixelForRequest > lastPixelForRequest) {
                throw new NegativeArraySizeException("first pixel > last pixel: f=" + firstPixelForRequest + "  l=" + lastPixelForRequest);
            }
            int pixelsUsed = lastPixelForRequest - firstPixelForRequest;
            int[] x = new int[pixelsUsed * 2];
            int[] y = new int[pixelsUsed * 2];
            int[] ploty = pc.getYData();
            System.arraycopy(ploty, firstPixelForRequest * 2, y, 0, pixelsUsed * 2);
            for (int i = 0; i < pixelsUsed * 2; ++i) {
                x[i] = firstPixelForRequest + offsetIntoRequestPixels + i / 2;
            }
            Plottable p = new Plottable(x, y);
            PlottableChunk shiftPC = new PlottableChunk(p, PlottableChunk.getPixel(rowBeginTime, pixelsPerDay) + firstPixelForRequest, PlottableChunk.getJDay(rowBeginTime), PlottableChunk.getYear(rowBeginTime), pixelsPerDay, pc.getNetworkCode(), pc.getStationCode(), pc.getSiteCode(), pc.getChannelCode());
            outChunks.add(shiftPC);
        }
        return outChunks;
    }

    public static int getPixels(int pixelsPerDay, MicroSecondTimeRange tr) {
        TimeInterval inter = tr.getInterval();
        inter = (TimeInterval)inter.convertTo(UnitImpl.DAY);
        double samples = (double)pixelsPerDay * inter.getValue();
        return (int)Math.floor(samples);
    }
}

