/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.display;

import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfTemplate;
import com.itextpdf.text.pdf.PdfWriter;
import edu.sc.seis.fissuresUtil.display.BasicSeismogramDisplay;
import edu.sc.seis.fissuresUtil.display.Graphics2DRenderer;
import edu.sc.seis.fissuresUtil.display.VerticalSeismogramDisplay;
import edu.sc.seis.fissuresUtil.display.borders.TimeBorder;
import edu.sc.seis.fissuresUtil.display.borders.TitleBorder;
import edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComponent;

public class SeismogramPDFBuilder {
    private int topMargin;
    private int rightMargin;
    private int bottomMargin;
    private int leftMargin;
    private int horizMargins;
    private int vertMargins;
    private Rectangle pageSize;
    private int dispPerPage;
    private boolean separateDisplays;
    private TitleBorder header;
    public static final Rectangle PAGE_SIZE = PageSize.LETTER;
    public static final int MARGIN = 50;

    public SeismogramPDFBuilder() {
        this(true, 1, true);
    }

    public SeismogramPDFBuilder(boolean landscape, int dispPerPage, boolean separateDisplays) {
        this(landscape, PAGE_SIZE, 50, dispPerPage, separateDisplays);
    }

    public SeismogramPDFBuilder(boolean landscape, Rectangle pageSize, int margin, int dispPerPage, boolean separateDisplays) {
        this(landscape, pageSize, margin, margin, margin, margin, dispPerPage, separateDisplays);
    }

    public SeismogramPDFBuilder(boolean landscape, Rectangle pageSize, int topMargin, int rightMargin, int bottomMargin, int leftMargin, int dispPerPage, boolean separateDisplays) {
        this.setPageSize(landscape ? pageSize.rotate() : pageSize);
        this.setMargins(topMargin, rightMargin, bottomMargin, leftMargin);
        this.setDispPerPage(dispPerPage);
    }

    public void setPageSize(Rectangle pageSize) {
        this.pageSize = pageSize;
    }

    public Rectangle getPageSize() {
        return this.pageSize;
    }

    public void setMargins(int margin) {
        this.setMargins(margin, margin, margin, margin);
    }

    public void setMargins(int topMargin, int rightMargin, int bottomMargin, int leftMargin) {
        this.setTopMargin(topMargin);
        this.setRightMargin(rightMargin);
        this.setBottomMargin(bottomMargin);
        this.setLeftMargin(leftMargin);
    }

    public void setTopMargin(int topMargin) {
        this.topMargin = topMargin;
        this.recalculateVertMargins();
    }

    public int getTopMargin() {
        return this.topMargin;
    }

    public void setRightMargin(int rightMargin) {
        this.rightMargin = rightMargin;
        this.recalculateHorizMargins();
    }

    public int getRightMargin() {
        return this.rightMargin;
    }

    public void setBottomMargin(int bottomMargin) {
        this.bottomMargin = bottomMargin;
        this.recalculateVertMargins();
    }

    public int getBottomMargin() {
        return this.bottomMargin;
    }

    public void setLeftMargin(int leftMargin) {
        this.leftMargin = leftMargin;
        this.recalculateHorizMargins();
    }

    public int getLeftMargin() {
        return this.leftMargin;
    }

    public void setDispPerPage(int dispPerPage) {
        this.dispPerPage = dispPerPage;
    }

    public int getDispPerPage() {
        return this.dispPerPage;
    }

    public void setSeparateDisplays(boolean separateDisplays) {
        this.separateDisplays = separateDisplays;
    }

    public boolean getSeparateDisplays() {
        return this.separateDisplays;
    }

    public void setHeader(TitleBorder header) {
        this.header = header;
    }

    public TitleBorder getHeader() {
        return this.header;
    }

    public Dimension getPrintableSize() {
        return new Dimension((int)(this.pageSize.getWidth() - (float)this.leftMargin - (float)this.rightMargin), (int)(this.pageSize.getHeight() - (float)this.topMargin - (float)this.bottomMargin));
    }

    public void createPDF(JComponent disp, File file) throws IOException {
        file.getCanonicalFile().getParentFile().mkdirs();
        File temp = File.createTempFile(file.getName(), null, file.getParentFile());
        this.createPDF(disp, (OutputStream)new FileOutputStream(temp));
        file.delete();
        temp.renameTo(file);
    }

    public void createPDF(JComponent comp, OutputStream out) {
        ArrayList<JComponent> displays = new ArrayList<JComponent>();
        if (this.separateDisplays && comp instanceof VerticalSeismogramDisplay) {
            displays.addAll(this.breakOutSeparateDisplays((VerticalSeismogramDisplay)comp));
        } else {
            displays.add(comp);
        }
        this.createPDF(displays.toArray(new JComponent[0]), out);
    }

    public void createPDF(JComponent[] comps, OutputStream out) {
        Document document = new Document(this.pageSize);
        try {
            int headerHeight = 0;
            if (this.header != null) {
                this.header.setSize(this.header.getPreferredSize());
                headerHeight = this.header.getHeight();
            }
            PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)out);
            document.open();
            int pageW = (int)this.pageSize.getWidth();
            int pageH = (int)this.pageSize.getHeight();
            int pixelsPerDisplayH = (int)Math.floor((double)(pageH - this.vertMargins - headerHeight) / (double)this.dispPerPage);
            int pixelsPerDisplayW = (int)Math.floor(pageW - this.horizMargins);
            PdfContentByte cb = writer.getDirectContent();
            PdfTemplate tpTraces = cb.createTemplate((float)pageW, (float)pageH);
            Graphics2D g2Traces = tpTraces.createGraphics((float)pageW, (float)pageH);
            g2Traces.translate(this.rightMargin, this.topMargin);
            if (this.header != null) {
                this.header.setSize(new Dimension(pixelsPerDisplayW, headerHeight));
                boolean bufferingStatus = this.header.isDoubleBuffered();
                this.header.setDoubleBuffered(false);
                this.header.paint(g2Traces);
                this.header.setDoubleBuffered(bufferingStatus);
                g2Traces.translate(0, headerHeight);
            }
            int seisOnCurPage = 0;
            for (int i = 0; i < comps.length; ++i) {
                boolean bufferingStatus = comps[i].isDoubleBuffered();
                comps[i].setDoubleBuffered(false);
                if (comps[i] instanceof Graphics2DRenderer) {
                    ((Graphics2DRenderer)((Object)comps[i])).renderToGraphics(g2Traces, new Dimension(pixelsPerDisplayW, pixelsPerDisplayH));
                } else {
                    comps[i].paint(g2Traces);
                }
                comps[i].setDoubleBuffered(bufferingStatus);
                if (++seisOnCurPage == this.dispPerPage) {
                    cb.addTemplate(tpTraces, 0.0f, 0.0f);
                    g2Traces.dispose();
                    document.newPage();
                    tpTraces = cb.createTemplate((float)pageW, (float)pageH);
                    g2Traces = tpTraces.createGraphics((float)pageW, (float)pageH);
                    g2Traces.translate(this.rightMargin, this.topMargin);
                    seisOnCurPage = 0;
                    continue;
                }
                g2Traces.translate(0, pixelsPerDisplayH);
            }
            if (seisOnCurPage != 0) {
                cb.addTemplate(tpTraces, 0.0f, 0.0f);
            }
            g2Traces.dispose();
        }
        catch (DocumentException ex) {
            GlobalExceptionHandler.handle("problem saving to pdf", ex);
        }
        document.close();
    }

    private List breakOutSeparateDisplays(VerticalSeismogramDisplay disp) {
        LinkedList displays = disp.getDisplays();
        for (BasicSeismogramDisplay cur : displays) {
            cur.clear(7);
            if (cur.isFilled(1)) continue;
            cur.add(new TimeBorder(cur), 1);
        }
        return displays;
    }

    private void recalculateHorizMargins() {
        this.horizMargins = this.leftMargin + this.rightMargin;
    }

    private void recalculateVertMargins() {
        this.vertMargins = this.topMargin + this.bottomMargin;
    }
}

