/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.display;

import edu.iris.Fissures.IfNetwork.Channel;
import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.sc.seis.fissuresUtil.display.DisplayUtils;
import edu.sc.seis.fissuresUtil.display.ParticleMotionDisplay;
import edu.sc.seis.fissuresUtil.display.registrar.TimeConfig;
import edu.sc.seis.fissuresUtil.xml.DataSetSeismogram;
import java.awt.Color;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParticleMotionDisplayThread {
    private boolean completion = false;
    private DataSetSeismogram dataSetSeismogram;
    private DataSetSeismogram[] dssArray;
    private TimeConfig tc;
    private ParticleMotionDisplay particleMotionDisplay;
    private Color displayColor;
    private static Logger logger = LoggerFactory.getLogger((String)ParticleMotionDisplayThread.class.getName());

    public ParticleMotionDisplayThread(DataSetSeismogram dataSetSeismogram, TimeConfig tc, ParticleMotionDisplay particleMotionDisplay, Color displayColor) {
        this.dataSetSeismogram = dataSetSeismogram;
        this.tc = tc;
        this.particleMotionDisplay = particleMotionDisplay;
        this.displayColor = displayColor;
    }

    public void execute() {
        int counter;
        this.dssArray = DisplayUtils.getComponents(this.dataSetSeismogram);
        if (this.dssArray.length < 2) {
            this.completion = false;
            return;
        }
        ChannelId[] channelGroup = new ChannelId[this.dssArray.length];
        for (counter = 0; counter < this.dssArray.length; ++counter) {
            channelGroup[counter] = this.dssArray[counter].getRequestFilter().channel_id;
        }
        for (counter = 0; counter < this.dssArray.length; ++counter) {
            String counterOrientation = DisplayUtils.getOrientationName(channelGroup[counter].channel_code);
            for (int subcounter = counter + 1; subcounter < this.dssArray.length; ++subcounter) {
                String orientationString;
                DataSetSeismogram hSeis;
                DataSetSeismogram vSeis;
                boolean horizPlane = this.isHorizontalPlane(this.dssArray[counter].getChannel(), this.dssArray[subcounter].getChannel());
                String subCounterOrientation = DisplayUtils.getOrientationName(channelGroup[subcounter].channel_code);
                if (counterOrientation.equals("Up")) {
                    vSeis = this.dssArray[counter];
                    hSeis = this.dssArray[subcounter];
                    orientationString = counterOrientation + "-" + subCounterOrientation;
                } else if (counterOrientation.equals("East")) {
                    vSeis = this.dssArray[subcounter];
                    hSeis = this.dssArray[counter];
                    orientationString = subCounterOrientation + "-" + counterOrientation;
                } else if (subCounterOrientation.equals("East")) {
                    vSeis = this.dssArray[counter];
                    hSeis = this.dssArray[subcounter];
                    orientationString = counterOrientation + "-" + subCounterOrientation;
                } else {
                    vSeis = this.dssArray[subcounter];
                    hSeis = this.dssArray[counter];
                    orientationString = subCounterOrientation + "-" + counterOrientation;
                }
                this.particleMotionDisplay.getView().add(hSeis, vSeis, this.tc, this.displayColor, orientationString, horizPlane);
            }
        }
        this.completion = true;
    }

    public boolean isHorizontalPlane(Channel one, Channel two) {
        return one.getOrientation().dip == 0.0f && two.getOrientation().dip == 0.0f;
    }

    public boolean getCompletion() {
        return this.completion;
    }
}

