/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.display;

import edu.iris.Fissures.IfNetwork.Channel;
import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.IfNetwork.Instrumentation;
import edu.iris.Fissures.IfNetwork.NetworkAttr;
import edu.iris.Fissures.IfNetwork.Site;
import edu.iris.Fissures.IfNetwork.Station;
import edu.iris.Fissures.network.ResponsePrint;
import edu.sc.seis.fissuresUtil.display.TextInfoDisplay;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class NetInfoDisplay
extends TextInfoDisplay {
    public void displayNetwork(NetworkAttr attr) {
        Document doc = this.textPane.getDocument();
        try {
            doc.remove(0, doc.getLength());
            this.appendNetwork(attr, doc);
            this.toTop();
        }
        catch (BadLocationException ble) {
            System.err.println("Couldn't insert message.");
        }
    }

    protected void appendNetwork(NetworkAttr attr) throws BadLocationException {
        this.appendNetwork(attr, this.textPane.getDocument());
    }

    protected void appendNetwork(NetworkAttr attr, Document doc) throws BadLocationException {
        this.appendHeader(doc, "Network");
        this.appendLabelValue(doc, "Code", attr.get_code());
        this.appendLabelValue(doc, "Name", attr.getName());
        this.appendLabelValue(doc, "Description", attr.getDescription());
        this.appendLabelValue(doc, "Owner", attr.getOwner());
        this.appendLabelValue(doc, "Begin", attr.getEffectiveTime().start_time.date_time);
        this.appendLabelValue(doc, "End", attr.getEffectiveTime().end_time.date_time);
        this.appendLine(doc, "");
    }

    public void displayStation(Station sta) {
        Document doc = this.textPane.getDocument();
        try {
            doc.remove(0, doc.getLength());
            this.appendNetwork(sta.getNetworkAttr(), doc);
            this.appendStation(sta, doc);
            this.toTop();
        }
        catch (BadLocationException ble) {
            System.err.println("Couldn't insert message.");
        }
    }

    protected void appendStation(Station sta) throws BadLocationException {
        this.appendStation(sta, this.textPane.getDocument());
    }

    protected void appendStation(Station sta, Document doc) throws BadLocationException {
        this.appendHeader(doc, "Station");
        this.appendLabelValue(doc, "Code", sta.get_id().station_code);
        this.appendLabelValue(doc, "Name", sta.getName());
        this.appendLabelValue(doc, "Location", "(" + sta.getLocation().latitude + ", " + sta.getLocation().longitude + ")");
        this.appendLabelValue(doc, "Begin", sta.getBeginTime().date_time);
        this.appendLabelValue(doc, "End", sta.getEndTime().date_time);
        this.appendLabelValue(doc, "Operator", sta.getOperator());
        this.appendLabelValue(doc, "Description", sta.getDescription());
        this.appendLabelValue(doc, "Comment", sta.getComment());
        this.appendLine(doc, "");
    }

    public void displaySite(Site site) {
        Document doc = this.textPane.getDocument();
        try {
            doc.remove(0, doc.getLength());
            this.appendNetwork(site.getStation().getNetworkAttr(), doc);
            this.appendStation(site.getStation(), doc);
            this.appendSite(site, doc);
            this.toTop();
        }
        catch (BadLocationException ble) {
            System.err.println("Couldn't insert message.");
        }
    }

    protected void appendSite(Site site) throws BadLocationException {
        this.appendSite(site, this.textPane.getDocument());
    }

    protected void appendSite(Site site, Document doc) throws BadLocationException {
        this.appendHeader(doc, "Site");
        this.appendLabelValue(doc, "Location", "(" + site.getLocation().latitude + ", " + site.getLocation().longitude + ")");
        this.appendLabelValue(doc, "Begin", site.getEffectiveTime().start_time.date_time);
        this.appendLabelValue(doc, "End", site.getEffectiveTime().end_time.date_time);
        this.appendLabelValue(doc, "Comment", site.getComment());
        this.appendLine(doc, "");
    }

    public void displayChannel(Channel chan) {
        Document doc = this.textPane.getDocument();
        try {
            doc.remove(0, doc.getLength());
            this.appendNetwork(chan.getSite().getStation().getNetworkAttr(), doc);
            this.appendStation(chan.getSite().getStation(), doc);
            this.appendSite(chan.getSite(), doc);
            this.appendChannel(chan, doc);
            this.toTop();
        }
        catch (BadLocationException ble) {
            System.err.println("Couldn't insert message.");
        }
    }

    protected void appendChannel(Channel chan) throws BadLocationException {
        this.appendChannel(chan, this.textPane.getDocument());
    }

    protected void appendChannel(Channel chan, Document doc) throws BadLocationException {
        this.appendHeader(doc, "Channel");
        this.appendLabelValue(doc, "Chan Code", chan.get_code());
        this.appendLabelValue(doc, "Orientation", "(" + chan.getOrientation().azimuth + ", " + chan.getOrientation().dip + ")");
        if (chan.getSamplingInfo() != null) {
            this.appendLabelValue(doc, "Sampling", chan.getSamplingInfo().numPoints + " points in " + chan.getSamplingInfo().interval.toString());
        } else {
            this.appendLabelValue(doc, "Sampling", "null value");
        }
        this.appendLabelValue(doc, "Begin", chan.getBeginTime().date_time);
        this.appendLabelValue(doc, "End", chan.getEndTime().date_time);
        this.appendLine(doc, "");
    }

    public void displayResponse(ChannelId chan, Instrumentation inst) {
        Document doc = this.textPane.getDocument();
        try {
            doc.remove(0, doc.getLength());
            doc.insertString(doc.getLength(), ResponsePrint.printResponse((ChannelId)chan, (Instrumentation)inst), this.textPane.getStyle("response"));
            this.toTop();
        }
        catch (BadLocationException ble) {
            System.err.println("Couldn't insert message.");
        }
    }
}

