/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.display;

import edu.iris.Fissures.seismogramDC.LocalSeismogramImpl;
import edu.sc.seis.fissuresUtil.display.AbstractSeismogramContainer;
import edu.sc.seis.fissuresUtil.display.SeismogramContainerListener;
import edu.sc.seis.fissuresUtil.display.SeismogramIterator;
import edu.sc.seis.fissuresUtil.time.MicroSecondTimeRange;
import edu.sc.seis.fissuresUtil.time.RangeTool;
import edu.sc.seis.fissuresUtil.xml.DataSetSeismogram;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class HardRefSeismogramContainer
extends AbstractSeismogramContainer {
    private List seis = new ArrayList();

    public HardRefSeismogramContainer(DataSetSeismogram seis) {
        this(null, seis);
    }

    public HardRefSeismogramContainer(SeismogramContainerListener initial, DataSetSeismogram seis) {
        super(initial, seis);
        this.reset();
    }

    @Override
    protected synchronized void addSeismograms(LocalSeismogramImpl[] seismograms) {
        for (int i = 0; i < seismograms.length; ++i) {
            Iterator it = this.seis.iterator();
            boolean found = false;
            while (it.hasNext() && !found) {
                LocalSeismogramImpl cur = (LocalSeismogramImpl)it.next();
                if (!new MicroSecondTimeRange(cur).equals(new MicroSecondTimeRange(seismograms[i]))) continue;
                found = true;
            }
            if (found) continue;
            System.out.println(this + " got data  " + seismograms[i].getBeginTime() + " to " + seismograms[i].getEndTime());
            this.seis.add(seismograms[i]);
        }
        this.noData = false;
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            ((SeismogramContainerListener)it.next()).updateData();
        }
    }

    @Override
    public synchronized SeismogramIterator getIterator() {
        return this.getIterator(RangeTool.getFullTime(this.getSeismograms()));
    }

    @Override
    public synchronized SeismogramIterator getIterator(MicroSecondTimeRange timeRange) {
        return new SeismogramIterator(this.getDataSetSeismogram().getName(), this.getSeismograms(), timeRange);
    }

    @Override
    public synchronized LocalSeismogramImpl[] getSeismograms() {
        return this.seis.toArray(new LocalSeismogramImpl[0]);
    }

    @Override
    protected synchronized void reset() {
        this.seis.clear();
        super.reset();
    }
}

