/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.display;

import edu.iris.Fissures.model.MicroSecondDate;
import edu.sc.seis.fissuresUtil.chooser.ThreadSafeSimpleDateFormat;
import edu.sc.seis.fissuresUtil.display.SimplePlotUtil;
import edu.sc.seis.fissuresUtil.display.TimeScaleMapper;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class AbsTimeScaleMapper
extends TimeScaleMapper {
    protected ThreadSafeSimpleDateFormat longTimeFormat = new ThreadSafeSimpleDateFormat("HH:MM:ss.S", TimeZone.getTimeZone("GMT"));
    protected ThreadSafeSimpleDateFormat mediumTimeFormat = new ThreadSafeSimpleDateFormat("MM:ss.S", TimeZone.getTimeZone("GMT"));
    protected ThreadSafeSimpleDateFormat shortTimeFormat = new ThreadSafeSimpleDateFormat("ss.S", TimeZone.getTimeZone("GMT"));
    protected Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
    protected int firstMajorTick;

    public AbsTimeScaleMapper(int totalPixels, int hintPixels, MicroSecondDate beginTime, MicroSecondDate endTime) {
        super(totalPixels, hintPixels, beginTime, endTime);
        this.calculateTicks();
    }

    @Override
    public int getPixelLocation(int i) {
        return SimplePlotUtil.getPixel(this.totalPixels, this.beginTime, this.endTime, new MicroSecondDate(Math.round((double)this.minTick.getMicroSecondTime() + (double)i * this.tickInc)));
    }

    @Override
    public String getLabel(int i) {
        if (this.isLabelTick(i)) {
            MicroSecondDate date = new MicroSecondDate(Math.round((double)this.minTick.getMicroSecondTime() + (double)i * this.tickInc));
            this.calendar.setTime((Date)date);
            if (i == this.firstMajorTick) {
                return this.longTimeFormat.format(this.calendar.getTime());
            }
            return this.shortTimeFormat.format(this.calendar.getTime());
        }
        return "";
    }

    @Override
    public int getNumTicks() {
        return this.numTicks;
    }

    @Override
    public int getTotalPixels() {
        return this.totalPixels;
    }

    @Override
    protected void calculateTicks() {
        if (this.totalPixels == 0) {
            this.numTicks = 0;
            return;
        }
        double hintNumber = (double)this.totalPixels / (double)this.hintPixels;
        long microSecWidth = this.endTime.getMicroSecondTime() - this.beginTime.getMicroSecondTime();
        this.tickInc = Math.pow(10.0, Math.floor(Math.log(microSecWidth) / Math.log(10.0)));
        double goalTickInc = microSecWidth / (long)this.totalPixels * (long)this.hintPixels;
        this.majorTickStep = 10;
        StartTickReturn retValue = this.startTick(goalTickInc, (Date)this.beginTime);
        this.minTick = retValue.minTick;
        this.majorTickStep = retValue.majorTickStep;
        this.tickInc = retValue.tickInc;
        retValue = this.startTick(this.tickInc * (double)this.majorTickStep, (Date)this.beginTime);
        this.minTick = retValue.minTick;
        long beginMicros = this.beginTime.getMicroSecondTime();
        long endMicros = this.endTime.getMicroSecondTime();
        long minMicros = this.minTick.getMicroSecondTime();
        this.firstMajorTick = 0;
        while (minMicros < beginMicros) {
            minMicros = (long)((double)minMicros + this.tickInc);
            --this.firstMajorTick;
        }
        while (minMicros > beginMicros) {
            minMicros = (long)((double)minMicros - this.tickInc);
            ++this.firstMajorTick;
        }
        if (this.firstMajorTick < 0) {
            this.firstMajorTick += this.majorTickStep;
        }
        this.minTick = new MicroSecondDate(minMicros);
        this.numTicks = 1;
        while ((double)minMicros + (double)this.numTicks * this.tickInc < (double)endMicros) {
            ++this.numTicks;
        }
    }

    public StartTickReturn startTick(double goalTickInc, Date startTime) {
        this.calendar.setTime(startTime);
        StartTickReturn retValue = new StartTickReturn();
        retValue.majorTickStep = this.majorTickStep;
        if (goalTickInc < 500000.0) {
            retValue.tickInc = Math.pow(10.0, Math.floor(Math.log(goalTickInc) * Math.log(10.0)));
            retValue.tickInc *= 2.0;
            retValue.majorTickStep = 5;
            this.calendar.set(14, 0);
            int sec = this.calendar.get(13);
            this.calendar.set(13, --sec);
        } else if (goalTickInc < 2000000.0) {
            retValue.tickInc = 1000000.0;
            this.calendar.set(14, 0);
        } else if (goalTickInc < 5000000.0) {
            retValue.tickInc = 2000000.0;
            this.calendar.set(14, 0);
            int sec = this.calendar.get(13);
            sec -= sec % 2;
            this.calendar.set(13, sec);
            retValue.majorTickStep = 5;
        } else if (goalTickInc < 2.0E7) {
            retValue.tickInc = 1.0E7;
            this.calendar.set(14, 0);
            int sec = this.calendar.get(13);
            sec -= sec % 10;
            this.calendar.set(13, sec);
            retValue.majorTickStep = 6;
        } else if (goalTickInc < 1.2E8) {
            retValue.tickInc = 6.0E7;
            this.calendar.set(14, 0);
            this.calendar.set(13, 0);
        } else if (goalTickInc < 1.2E9) {
            retValue.tickInc = 6.0E8;
            this.calendar.set(14, 0);
            this.calendar.set(13, 0);
            int min = this.calendar.get(12);
            min -= min % 10;
            this.calendar.set(12, min);
            retValue.majorTickStep = 6;
        } else if (goalTickInc < 7.2E9) {
            retValue.tickInc = 3.6E9;
            this.calendar.set(14, 0);
            this.calendar.set(13, 0);
            this.calendar.set(12, 0);
            retValue.majorTickStep = 24;
        } else if (goalTickInc < 1.728E11) {
            retValue.tickInc = 8.64E10;
            this.calendar.set(14, 0);
            this.calendar.set(13, 0);
            this.calendar.set(12, 0);
            this.calendar.set(10, 0);
        } else if (goalTickInc < 1.728E12) {
            this.calendar.set(14, 0);
            this.calendar.set(13, 0);
            this.calendar.set(12, 0);
            this.calendar.set(10, 0);
            int jday = this.calendar.get(6);
            jday -= jday % 10;
            this.calendar.set(6, jday);
            retValue.tickInc = 8.64E11;
        } else if (goalTickInc < 1.728E13) {
            this.calendar.set(14, 0);
            this.calendar.set(13, 0);
            this.calendar.set(12, 0);
            this.calendar.set(10, 0);
            int jday = this.calendar.get(6);
            jday -= jday % 100;
            this.calendar.set(6, jday);
            retValue.tickInc = 8.64E12;
        }
        retValue.minTick = new MicroSecondDate(this.calendar.getTime());
        return retValue;
    }

    protected final class StartTickReturn {
        MicroSecondDate minTick;
        double tickInc;
        int majorTickStep;

        protected StartTickReturn() {
        }
    }
}

