/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.database.seismogram;

import com.itextpdf.text.Document;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.DefaultFontMapper;
import com.itextpdf.text.pdf.FontMapper;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfTemplate;
import com.itextpdf.text.pdf.PdfWriter;
import edu.iris.Fissures.IfNetwork.Channel;
import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.IfNetwork.StationId;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.network.ChannelIdUtil;
import edu.iris.Fissures.network.StationIdUtil;
import edu.sc.seis.fissuresUtil.database.seismogram.RT130ReportFactory;
import edu.sc.seis.fissuresUtil.database.seismogram.StationDataSummary;
import edu.sc.seis.fissuresUtil.time.MicroSecondTimeRange;
import edu.sc.seis.fissuresUtil.time.ReduceTool;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Rectangle2D;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.GanttRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.gantt.Task;
import org.jfree.data.gantt.TaskSeries;
import org.jfree.data.gantt.TaskSeriesCollection;

public class RT130Report {
    private Date start;
    private Date end;
    private Set stationCodesToDisplay;
    private RT130ReportFactory reportFactory;
    private int numSacFiles;
    private int numMSeedFiles;
    private int numRefTekEntries;
    private Map fileFormatException = new HashMap();
    private Map malformedFileNameException = new HashMap();
    private Map unsupportedFileException = new HashMap();
    private Map channelIdWithTime = new HashMap();
    private Map channelIdStringToChannel = new HashMap();
    private Map channelIdStringToChannelId = new HashMap();
    private Map channelToIdString = new HashMap();
    private Map channelIdToIdString = new HashMap();

    public RT130Report() {
        this(null, null, null);
    }

    public RT130Report(Date start, Date end, Set stationCodesToDisplay) {
        this.start = start;
        this.end = end;
        this.stationCodesToDisplay = stationCodesToDisplay;
    }

    public void addRefTekSeismogram(Channel channel, MicroSecondDate beginTime, MicroSecondDate endTime) {
        if (!this.shouldDisplay(channel.get_id())) {
            return;
        }
        ++this.numRefTekEntries;
        this.addSeismogram(channel, beginTime, endTime);
    }

    public void addSacSeismogram(Channel channel, MicroSecondDate beginTime, MicroSecondDate endTime) {
        if (!this.shouldDisplay(channel.get_id())) {
            return;
        }
        ++this.numSacFiles;
        this.addSeismogram(channel, beginTime, endTime);
    }

    public void addMSeedSeismogram(ChannelId channelid, MicroSecondDate beginTime, MicroSecondDate endTime) {
        if (!this.shouldDisplay(channelid)) {
            return;
        }
        ++this.numMSeedFiles;
        this.addSeismogram(channelid, beginTime, endTime);
    }

    private void addSeismogram(Channel channel, MicroSecondDate beginTime, MicroSecondDate endTime) {
        String channelIdString = this.getIdString(channel);
        this.channelIdStringToChannel.put(channelIdString, channel);
        this.channelIdStringToChannelId.put(channelIdString, channel.get_id());
        MicroSecondTimeRange timeRange = new MicroSecondTimeRange(beginTime, endTime);
        if (!this.channelIdWithTime.containsKey(channelIdString)) {
            this.channelIdWithTime.put(channelIdString, new ArrayList());
        }
        List list = (List)this.channelIdWithTime.get(channelIdString);
        list.add(timeRange);
        if (list.size() > 1) {
            this.mergeTimes(list);
        }
    }

    private boolean shouldDisplay(ChannelId id) {
        return this.stationCodesToDisplay == null || this.stationCodesToDisplay.contains(id.station_code);
    }

    private void addSeismogram(ChannelId channelId, MicroSecondDate beginTime, MicroSecondDate endTime) {
        String channelIdString = this.getIdString(channelId);
        this.channelIdStringToChannelId.put(channelIdString, channelId);
        MicroSecondTimeRange timeRange = new MicroSecondTimeRange(beginTime, endTime);
        if (!this.channelIdWithTime.containsKey(channelId)) {
            this.channelIdWithTime.put(channelId, new ArrayList());
        }
        List list = (List)this.channelIdWithTime.get(channelId);
        list.add(timeRange);
        if (list.size() > 1) {
            this.mergeTimes(list);
        }
    }

    private void mergeTimes(List channelTimes) {
        MicroSecondTimeRange latest = RT130Report.pop(channelTimes);
        MicroSecondTimeRange[] timeRangeArray = ReduceTool.merge(new MicroSecondTimeRange[]{RT130Report.pop(channelTimes), latest});
        for (int i = 0; i < timeRangeArray.length; ++i) {
            channelTimes.add(timeRangeArray[i]);
        }
    }

    private static MicroSecondTimeRange pop(List channelTimes) {
        return (MicroSecondTimeRange)channelTimes.remove(channelTimes.size() - 1);
    }

    public void addMSeedSeismogram() {
        ++this.numMSeedFiles;
    }

    public void addSacSeismogram() {
        ++this.numSacFiles;
    }

    public void outputReport(String reportName) {
        String name = reportName == null ? this.getCurrentDate() + "_RT130Report" : reportName;
        this.printReport(name);
        this.makeReportImage(name);
    }

    private void makeReportImage(String reportName) {
        RT130ReportFactory factory = new RT130ReportFactory(this.channelIdWithTime, this.channelIdStringToChannelId);
        int numStations = 0;
        TaskSeries taskSeries = new TaskSeries("Stations");
        List stationDataSummaryList = factory.getSortedStationDataSummaryList();
        for (StationDataSummary stationDataSummary : stationDataSummaryList) {
            MicroSecondTimeRange firstTimeRange = stationDataSummary.getEncompassingTimeRange();
            Task task = new Task(stationDataSummary.getStationCode(), (Date)firstTimeRange.getBeginTime(), (Date)firstTimeRange.getEndTime());
            MicroSecondTimeRange[] recordedTimes = stationDataSummary.getRecordedTimes();
            for (int i = 0; i < recordedTimes.length; ++i) {
                task.addSubtask(new Task(stationDataSummary.getStationCode(), (Date)recordedTimes[i].getBeginTime(), (Date)recordedTimes[i].getEndTime()));
            }
            ++numStations;
            taskSeries.add(task);
        }
        TaskSeriesCollection dataset = new TaskSeriesCollection();
        dataset.add(taskSeries);
        DateAxis dateAxis = new DateAxis("Time");
        GanttRenderer renderer = new GanttRenderer();
        CategoryPlot plot = new CategoryPlot((CategoryDataset)dataset, new CategoryAxis("Station"), (ValueAxis)dateAxis, (CategoryItemRenderer)renderer);
        plot.setOrientation(PlotOrientation.HORIZONTAL);
        JFreeChart chart = new JFreeChart(reportName, JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, false);
        renderer.setSeriesPaint(0, (Paint)Color.PINK);
        renderer.setOutlinePaint((Paint)Color.BLACK);
        if (numStations > 0) {
            if (this.start == null) {
                this.start = dateAxis.getMinimumDate();
            }
            if (this.end == null) {
                this.end = dateAxis.getMaximumDate();
            }
            dateAxis.setRange(this.start, this.end);
        }
        this.printChartToPDF(chart, 1600, numStations * 25 + 100, reportName + ".pdf");
    }

    private void printChartToPDF(JFreeChart chart, int width, int height, String fileName) {
        try {
            Document document = new Document(new Rectangle((float)width, (float)height));
            PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(fileName));
            document.addAuthor("University of South Carolina, United States of America, Geological Sciences");
            document.open();
            PdfContentByte cb = writer.getDirectContent();
            PdfTemplate tp = cb.createTemplate((float)width, (float)height);
            Graphics2D g2 = tp.createGraphics((float)width, (float)height, (FontMapper)new DefaultFontMapper());
            Rectangle2D.Double rectangle2D = new Rectangle2D.Double(0.0, 0.0, width, height);
            chart.draw(g2, (Rectangle2D)rectangle2D);
            g2.dispose();
            cb.addTemplate(tp, 0.0f, 0.0f);
            document.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void printReport(String reportName) {
        FileWriter report = null;
        try {
            report = new FileWriter(reportName + ".log");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        PrintWriter reportStream = new PrintWriter(report);
        reportStream.println("Report");
        reportStream.println("-------");
        reportStream.println("  Number of RT130 stations read: " + this.getNumStations());
        reportStream.println("  Number of channels read: " + this.getNumChannels());
        reportStream.println("  Number of channels read with incontiguous data: " + this.getNumIncontiguousChannels());
        reportStream.println();
        reportStream.println("SAC Files");
        reportStream.println("----------");
        reportStream.println("  Number of files read: " + this.getNumSacFiles());
        reportStream.println();
        reportStream.println("MSEED Files");
        reportStream.println("------------");
        reportStream.println("  Number of files read: " + this.getNumMSeedFiles());
        reportStream.println();
        reportStream.println("RT130 Files");
        reportStream.println("------------");
        reportStream.println("  Number of seismogram entries: " + this.getNumRefTekEntries());
        reportStream.println();
        reportStream.println("  Days Of Coverage");
        reportStream.println("  -----------------");
        this.printRefTekDaysOfCoverage(reportStream);
        reportStream.println();
        reportStream.println("  Gap Description");
        reportStream.println("  ----------------");
        this.printRefTekGapDescription(reportStream);
        reportStream.println();
        reportStream.println("Unsupported File Exceptions");
        reportStream.println("----------------------------");
        this.printExceptionFiles(reportStream, this.unsupportedFileException, "No Unsupported File Exceptions.");
        reportStream.println();
        reportStream.println("File Format Exceptions");
        reportStream.println("-----------------------");
        this.printExceptionFiles(reportStream, this.fileFormatException, "No File Format Exceptions.");
        reportStream.println();
        reportStream.println("Malformed File Name Exceptions");
        reportStream.println("-------------------------------");
        this.printExceptionFiles(reportStream, this.malformedFileNameException, "No Malformed File Name Exceptions.");
        reportStream.close();
        try {
            report.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void addFileFormatException(String fileLoc, String problemDescription) {
        this.fileFormatException.put(fileLoc, problemDescription);
    }

    public void addMalformedFileNameException(String fileLoc, String problemDescription) {
        this.malformedFileNameException.put(fileLoc, problemDescription);
    }

    public void addUnsupportedFileException(String fileLoc, String problemDescription) {
        this.unsupportedFileException.put(fileLoc, problemDescription);
    }

    public int getNumStations() {
        int numStations = 0;
        HashSet<String> stations = new HashSet<String>();
        for (String key : this.channelIdWithTime.keySet()) {
            stations.add(StationIdUtil.toString((StationId)((Channel)this.channelIdStringToChannel.get(key)).getSite().getStation().get_id()));
        }
        numStations = stations.size();
        return numStations;
    }

    public int getNumChannels() {
        return this.channelIdWithTime.keySet().size();
    }

    public int getNumIncontiguousChannels() {
        int numIncontiguousChannels = 0;
        HashSet<String> incontiguousChannels = new HashSet<String>();
        for (String key : this.channelIdWithTime.keySet()) {
            if (((List)this.channelIdWithTime.get(key)).size() <= 1) continue;
            incontiguousChannels.add(key);
        }
        numIncontiguousChannels = incontiguousChannels.size();
        return numIncontiguousChannels;
    }

    public int getNumSacFiles() {
        return this.numSacFiles;
    }

    public int getNumMSeedFiles() {
        return this.numMSeedFiles;
    }

    public int getNumRefTekEntries() {
        return this.numRefTekEntries;
    }

    private void printExceptionFiles(PrintWriter reportStream, Map exceptions, String emptyMessage) {
        Iterator it = exceptions.keySet().iterator();
        if (!it.hasNext()) {
            reportStream.println("  " + emptyMessage);
        }
        while (it.hasNext()) {
            String key = (String)it.next();
            reportStream.println("  " + key);
            reportStream.println("  " + exceptions.get(key));
            reportStream.println();
        }
    }

    private void printRefTekGapDescription(PrintWriter reportStream) {
        if (this.reportFactory == null) {
            this.reportFactory = new RT130ReportFactory(this.channelIdWithTime, this.channelIdStringToChannelId);
        }
        this.reportFactory.printGapDescription(reportStream);
    }

    private void printRefTekDaysOfCoverage(PrintWriter reportStream) {
        if (this.reportFactory == null) {
            this.reportFactory = new RT130ReportFactory(this.channelIdWithTime, this.channelIdStringToChannelId);
        }
        this.reportFactory.printDaysOfCoverage(reportStream);
    }

    private String getIdString(Channel chan) {
        if (!this.channelToIdString.containsKey(chan)) {
            this.channelToIdString.put(chan, ChannelIdUtil.toString((ChannelId)chan.get_id()));
        }
        return (String)this.channelToIdString.get(chan);
    }

    private String getIdString(ChannelId channelId) {
        if (!this.channelIdToIdString.containsKey(channelId)) {
            this.channelIdToIdString.put(channelId, ChannelIdUtil.toString((ChannelId)channelId));
        }
        return (String)this.channelIdToIdString.get(channelId);
    }

    private String getCurrentDate() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Date date = new Date();
        return dateFormat.format(date);
    }
}

