/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.database;

import edu.iris.Fissures.Unit;
import edu.iris.Fissures.UnitBase;
import edu.iris.Fissures.model.UnitImpl;
import edu.sc.seis.fissuresUtil.database.JDBCSequence;
import edu.sc.seis.fissuresUtil.database.JDBCTable;
import edu.sc.seis.fissuresUtil.database.NotFound;
import edu.sc.seis.fissuresUtil.database.util.TableSetup;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class JDBCUnit
extends JDBCTable {
    private JDBCSequence seq;
    protected PreparedStatement putStmt;
    protected PreparedStatement getDBIdStmt;
    protected PreparedStatement getStmt;
    protected HashMap cache = new HashMap();

    public JDBCUnit(Connection conn) throws SQLException {
        super("unit", conn);
        this.seq = new JDBCSequence(conn, "unit_seq");
        TableSetup.setup(this.getTableName(), conn, this, "edu/sc/seis/fissuresUtil/database/props/default.props");
        this.putStmt = conn.prepareStatement("INSERT INTO unit ( unit_id, unit_name, unit_base, unit_subunit_id,  unit_exponent, unit_multFactor, unit_power ) VALUES ( ?, ?, ?, ?, ?, ?, ? )");
        this.getDBIdStmt = conn.prepareStatement("SELECT unit_id FROM unit WHERE  unit_name = ? ");
        this.getStmt = conn.prepareStatement("SELECT * FROM unit WHERE unit_id = ?");
        this.createCache();
    }

    public Unit get(int dbid) throws SQLException, NotFound {
        Unit cachedUnit = (Unit)this.cache.get(new Integer(dbid));
        if (cachedUnit != null) {
            return cachedUnit;
        }
        this.getStmt.setInt(1, dbid);
        ResultSet results = this.getStmt.executeQuery();
        if (results.next()) {
            String name = results.getString("unit_name");
            int exponent = results.getInt("unit_exponent");
            double multFactor = results.getDouble("unit_multFactor");
            int power = results.getInt("unit_power");
            String base = results.getString("unit_base");
            if (base == null || base.equals("COMPOSITE")) {
                String strSequence = results.getString("unit_subunit_id");
                ArrayList<Integer> intList = new ArrayList<Integer>();
                int start = strSequence.indexOf(123) + 1;
                int end = strSequence.indexOf(44, start);
                if (end == -1) {
                    end = strSequence.indexOf(125, start);
                }
                do {
                    String strInt = strSequence.substring(start, end);
                    intList.add(new Integer(strInt));
                    start = end + 1;
                    end = strSequence.indexOf(44, start);
                    if (end != -1) continue;
                    end = strSequence.indexOf(125, start);
                } while (end != -1);
                Unit[] subunits = new Unit[intList.size()];
                Iterator iter = intList.iterator();
                int unitNum = 0;
                while (iter.hasNext()) {
                    Integer subunit_dbid = (Integer)iter.next();
                    subunits[unitNum++] = this.get(subunit_dbid);
                }
                return new UnitImpl(subunits, power, name, multFactor, exponent);
            }
            return new UnitImpl(JDBCUnit.stringToBase(base), power, name, multFactor, exponent);
        }
        throw new NotFound("dbid=" + dbid);
    }

    public int put(UnitImpl aUnit) throws SQLException {
        try {
            return this.getDBId((Unit)aUnit);
        }
        catch (NotFound notFound) {
            String subunitString;
            String base;
            if (aUnit.isBaseUnit()) {
                UnitImpl[] subunits = new UnitImpl[]{};
                int[] subunit_dbid = new int[]{};
                base = UnitImpl.baseToString((UnitBase)aUnit.getBaseUnit());
                subunitString = "";
            } else {
                UnitImpl[] subunits = aUnit.getSubUnits();
                int[] subunit_dbid = new int[subunits.length];
                subunitString = "{";
                for (int i = 0; i < subunits.length; ++i) {
                    subunit_dbid[i] = this.put(subunits[i]);
                    subunitString = subunitString + subunit_dbid[i];
                    if (i == subunits.length - 1) continue;
                    subunitString = subunitString + ",";
                }
                subunitString = subunitString + "}";
                base = UnitImpl.baseToString((UnitBase)aUnit.getBaseUnit());
            }
            String unitName = aUnit.name;
            if (!aUnit.isNamed()) {
                unitName = aUnit.toString();
            }
            int nextDBId = this.seq.next();
            this.putStmt.setInt(1, nextDBId);
            this.putStmt.setString(2, unitName);
            this.putStmt.setString(3, base);
            this.putStmt.setString(4, subunitString);
            this.putStmt.setInt(5, aUnit.getExponent());
            this.putStmt.setDouble(6, aUnit.getMultiFactor());
            this.putStmt.setInt(7, aUnit.getPower());
            this.putStmt.executeUpdate();
            this.cache.put(new Integer(nextDBId), aUnit);
            return nextDBId;
        }
    }

    public int getDBId(Unit aUnit) throws SQLException, NotFound {
        if (this.cache.containsValue(aUnit)) {
            for (Integer id : this.cache.keySet()) {
                if (!((Unit)this.cache.get(id)).equals(aUnit)) continue;
                return id;
            }
        }
        this.getDBIdStmt.setString(1, aUnit.toString());
        ResultSet rs = this.getDBIdStmt.executeQuery();
        if (rs.next()) {
            return rs.getInt("unit_id");
        }
        throw new NotFound(aUnit.toString());
    }

    public static final UnitBase stringToBase(String inString) {
        if (inString.equals("METER")) {
            return UnitBase.from_int((int)0);
        }
        if (inString.equals("GRAM")) {
            return UnitBase.from_int((int)1);
        }
        if (inString.equals("SECOND")) {
            return UnitBase.from_int((int)2);
        }
        if (inString.equals("AMPERE")) {
            return UnitBase.from_int((int)3);
        }
        if (inString.equals("KELVIN")) {
            return UnitBase.from_int((int)4);
        }
        if (inString.equals("MOLE")) {
            return UnitBase.from_int((int)5);
        }
        if (inString.equals("CANDELA")) {
            return UnitBase.from_int((int)6);
        }
        if (inString.equals("COUNT")) {
            return UnitBase.from_int((int)7);
        }
        if (inString.equals("COMPOSITE")) {
            return UnitBase.from_int((int)8);
        }
        return null;
    }

    protected void createCache() throws SQLException {
        ArrayList<UnitImpl> common = new ArrayList<UnitImpl>();
        common.add(UnitImpl.SECOND);
        common.add(UnitImpl.MILLISECOND);
        common.add(UnitImpl.MICROSECOND);
        common.add(UnitImpl.NANOSECOND);
        common.add(UnitImpl.HERTZ);
        common.add(UnitImpl.METER);
        common.add(UnitImpl.KILOMETER);
        common.add(UnitImpl.MILLIMETER);
        common.add(UnitImpl.MICROMETER);
        common.add(UnitImpl.NANOMETER);
        common.add(UnitImpl.METER_PER_SECOND);
        common.add(UnitImpl.GRAM);
        common.add(UnitImpl.KILOGRAM);
        common.add(UnitImpl.METER_PER_SECOND_PER_SECOND);
        common.add(UnitImpl.NEWTON);
        common.add(UnitImpl.RADIAN);
        common.add(UnitImpl.DEGREE);
        common.add(UnitImpl.AMPERE);
        common.add(UnitImpl.JOULE);
        common.add(UnitImpl.COULOMB);
        common.add(UnitImpl.VOLT);
        common.add(UnitImpl.MICROMETER_PER_SECOND);
        common.add(UnitImpl.NANOMETER_PER_SECOND);
        common.add(UnitImpl.COUNT);
        for (UnitImpl unit : common) {
            int n = this.put(unit);
        }
    }
}

