/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.database;

import edu.iris.Fissures.Time;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.model.TimeUtils;
import edu.sc.seis.fissuresUtil.database.ConnMgr;
import edu.sc.seis.fissuresUtil.database.JDBCSequence;
import edu.sc.seis.fissuresUtil.database.JDBCTable;
import edu.sc.seis.fissuresUtil.database.NotFound;
import edu.sc.seis.fissuresUtil.database.util.TableSetup;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;

public class JDBCTime
extends JDBCTable {
    private PreparedStatement getById;
    private PreparedStatement getByValues;
    private PreparedStatement put;
    public static final MicroSecondDate future = TimeUtils.future;
    public static final MicroSecondDate futurePlusOne = TimeUtils.futurePlusOne;
    public static final Time timeUnknown = TimeUtils.timeUnknown;
    private JDBCSequence seq;

    public JDBCTime() throws SQLException {
        this(ConnMgr.createConnection());
    }

    public JDBCTime(Connection conn) throws SQLException {
        super("time", conn);
        TableSetup.setup(this, "edu/sc/seis/fissuresUtil/database/props/default.props");
        this.seq = new JDBCSequence(conn, "TimeSeq");
        this.getById = conn.prepareStatement("SELECT * FROM time WHERE time_id = ?");
        this.put = conn.prepareStatement("INSERT INTO time (time_id, time_stamp, time_nanos, time_leapsec) VALUES (?, ?, ?, ?)");
        this.getByValues = conn.prepareStatement("SELECT time_id FROM time WHERE time_stamp = ? AND time_nanos = ? AND time_leapsec = ?");
    }

    public Time get(int dbid) throws SQLException, NotFound {
        this.getById.setInt(1, dbid);
        ResultSet rs = this.getById.executeQuery();
        if (rs.next()) {
            return JDBCTime.makeTime(rs.getTimestamp("time_stamp"), rs.getInt("time_nanos"), rs.getInt("time_leapsec"));
        }
        throw new NotFound("No time for id " + dbid);
    }

    public int put(Time time) throws SQLException {
        JDBCTime.insert(time, this.getByValues, 1);
        ResultSet rs = this.getByValues.executeQuery();
        if (rs.next()) {
            return rs.getInt("time_id");
        }
        int dbid = this.seq.next();
        this.put.setInt(1, dbid);
        JDBCTime.insert(time, this.put, 2);
        this.put.executeUpdate();
        return dbid;
    }

    public static int insert(Time time, PreparedStatement stmt, int index) throws SQLException {
        Timestamp ts;
        if (time.date_time.equals(JDBCTime.timeUnknown.date_time)) {
            ts = futurePlusOne.getTimestamp();
        } else {
            MicroSecondDate ms = new MicroSecondDate(time);
            ts = ms.getTimestamp();
        }
        int nanos = ts.getNanos();
        ts.setNanos(0);
        stmt.setTimestamp(index++, ts);
        stmt.setInt(index++, nanos);
        stmt.setInt(index++, time.leap_seconds_version);
        return index;
    }

    public static Time makeTime(Timestamp ts, int nanos, int leapsec) {
        if (ts.after((Date)future)) {
            return timeUnknown;
        }
        ts = new Timestamp(ts.getTime());
        ts.setNanos(nanos);
        MicroSecondDate micro = new MicroSecondDate(ts, leapsec);
        return micro.getFissuresTime();
    }
}

