/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.database;

import edu.iris.Fissures.FissuresException;
import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.IfSeismogramDC.DataCenterOperations;
import edu.iris.Fissures.IfSeismogramDC.LocalSeismogram;
import edu.iris.Fissures.IfSeismogramDC.RequestFilter;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.network.ChannelIdUtil;
import edu.iris.Fissures.seismogramDC.LocalSeismogramImpl;
import edu.iris.dmc.seedcodec.CodecException;
import edu.sc.seis.fissuresUtil.chooser.ClockUtil;
import edu.sc.seis.fissuresUtil.database.AbstractDb;
import edu.sc.seis.fissuresUtil.database.UniqueNumberGenerator;
import edu.sc.seis.fissuresUtil.sac.FissuresToSac;
import edu.sc.seis.fissuresUtil.sac.SacToFissures;
import edu.sc.seis.seisFile.sac.SacTimeSeries;
import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HSQLRequestFilterDb
extends AbstractDb {
    private String dataDirectoryName;
    private UniqueNumberGenerator ung;
    private PreparedStatement getTotalSizeStmt;
    private PreparedStatement rfInsertStmt;
    private PreparedStatement fiInsertStmt;
    private PreparedStatement rfGetStmt;
    private PreparedStatement fiGetStmt;
    private PreparedStatement maxFileIDStmt;
    private DataCenterOperations dataCenterRouter;
    private PreparedStatement rfGetFileIdStmt;
    private PreparedStatement rfGetInfoStmt;
    private PreparedStatement availableDataStmt;
    private PreparedStatement getOldestStmt;
    private PreparedStatement deleteStmt;
    private PreparedStatement deleteStmt2;
    private long maxDataSize;
    private static final String PREFIX = "edu.sc.seis.fissuresUtil.database.seismogram";
    private static Logger logger = LoggerFactory.getLogger((String)HSQLRequestFilterDb.class.getName());

    public HSQLRequestFilterDb(String directoryName, String databaseName) throws SQLException {
        this(directoryName, databaseName, null);
    }

    public HSQLRequestFilterDb(String directoryName, String databaseName, DataCenterOperations router) throws SQLException {
        super(directoryName, databaseName);
        this.dataDirectoryName = this.directoryName + "/data/";
        this.ung = UniqueNumberGenerator.getUNG(this.directoryName, this.databaseName);
        this.maxDataSize = 0x3200000L;
        this.dataCenterRouter = router;
        this.create();
    }

    public void setMaxDataSize(long size) {
        this.maxDataSize = size;
    }

    @Override
    public void create() throws SQLException {
        this.connection = this.getConnection();
        if (this.connection == null) {
            if (JOptionPane.showConfirmDialog(null, "It appears that another instance of the program is running.\nSome features may not work in this instance. Quit program?", "Program already running", 2, 2) == 0) {
                System.exit(0);
            }
            return;
        }
        try {
            Statement stmt = this.connection.createStatement();
            stmt.executeUpdate(" CREATE TABLE requestFilterDB (  id INTEGER IDENTITY PRIMARY KEY,  channel_id VARCHAR_IGNORECASE ,  begin_time TIMESTAMP,  end_time TIMESTAMP,  access_time TIMESTAMP,  fileid int ) ");
            stmt.executeUpdate(" CREATE TABLE fileInfoDB(  fileid INTEGER,  filename VARCHAR_IGNORECASE,  filesize BIGINT) ");
        }
        catch (SQLException sqle) {
            logger.warn("Caught SQLException creating database tables. This is probably not a problem.", (Throwable)sqle);
        }
        this.getTotalSizeStmt = this.connection.prepareStatement(" SELECT sum(filesize) from fileInfoDB ");
        this.getOldestStmt = this.connection.prepareStatement(" SELECT * from requestFilterDB, fileInfoDB where fileInfoDB.fileid = requestFilterDB.fileid order by access_time");
        this.rfInsertStmt = this.connection.prepareStatement(" INSERT INTO requestFilterDB  ( channel_id, begin_time,  end_time, access_time,  fileid )  VALUES(?,?,?,?,?) ");
        this.fiInsertStmt = this.connection.prepareStatement(" INSERT INTO fileInfoDB  VALUES(?,?, ?) ");
        this.rfGetStmt = this.connection.prepareStatement(" SELECT fileid FROM requestFilterDB  WHERE channel_id = ? AND  NOT ((begin_time >= ? AND begin_time >= ? )      OR (end_time <= ? AND end_time <= ?)  ) ");
        this.fiGetStmt = this.connection.prepareStatement(" SELECT filename FROM fileInfoDB  WHERE fileid = ? ");
        this.maxFileIDStmt = this.connection.prepareStatement(" SELECT max(fileid) FROM fileInfoDB ");
        this.rfGetFileIdStmt = this.connection.prepareStatement(" SELECT id FROM requestFilterDB  WHERE channel_id = ? AND  NOT ((begin_time >= ? AND begin_time >= ? )      OR (end_time <= ? AND end_time <= ?)  ) ");
        this.rfGetInfoStmt = this.connection.prepareStatement(" SELECT channel_id, begin_time,  end_time FROM requestFilterDB  WHERE id = ? ");
        this.availableDataStmt = this.connection.prepareStatement(" SELECT begin_time, end_time FROM  requestFilterDB  WHERE channel_id = ? ORDER BY begin_time ");
        this.deleteStmt = this.connection.prepareStatement("DELETE from requestFilterDB WHERE fileid = ?");
        this.deleteStmt2 = this.connection.prepareStatement("DELETE from fileInfoDB WHERE fileid = ?");
    }

    public RequestFilter[] available_data(RequestFilter[] a_filterseq) throws SQLException {
        ArrayList<RequestFilter> arrayList = new ArrayList<RequestFilter>();
        for (int counter = 0; counter < a_filterseq.length; ++counter) {
            RequestFilter[] tempArray = this.available_data(a_filterseq[counter]);
            for (int subCounter = 0; subCounter < tempArray.length; ++subCounter) {
                arrayList.add(tempArray[subCounter]);
            }
        }
        RequestFilter[] rtnValues = new RequestFilter[arrayList.size()];
        rtnValues = arrayList.toArray(rtnValues);
        return rtnValues;
    }

    public RequestFilter[] available_data(RequestFilter a_filterseq) throws SQLException {
        ArrayList<RequestFilter> arrayList = new ArrayList<RequestFilter>();
        this.availableDataStmt.setString(1, ChannelIdUtil.toString((ChannelId)a_filterseq.channel_id));
        ResultSet rs = this.availableDataStmt.executeQuery();
        while (rs.next()) {
            MicroSecondDate beginDate = new MicroSecondDate(rs.getTimestamp("begin_time"));
            MicroSecondDate endDate = new MicroSecondDate(rs.getTimestamp("end_time"));
            RequestFilter requestFilter = new RequestFilter(a_filterseq.channel_id, beginDate.getFissuresTime(), endDate.getFissuresTime());
            arrayList.add(requestFilter);
        }
        RequestFilter[] rtnValues = new RequestFilter[arrayList.size()];
        rtnValues = arrayList.toArray(rtnValues);
        return rtnValues;
    }

    public void addSeismogram(LocalSeismogramImpl[] seismos) throws SQLException, CodecException, IOException {
        this.insertFileInfo(seismos);
    }

    public void insertRequestFilterInfo(String channel_id, MicroSecondDate begin_date, MicroSecondDate end_date, int fileid) throws SQLException {
        this.rfInsertStmt.setString(1, channel_id);
        this.rfInsertStmt.setTimestamp(2, begin_date.getTimestamp());
        this.rfInsertStmt.setTimestamp(3, end_date.getTimestamp());
        this.rfInsertStmt.setTimestamp(4, ClockUtil.now().getTimestamp());
        this.rfInsertStmt.setInt(5, fileid);
        this.rfInsertStmt.executeUpdate();
    }

    public void insertFileInfo(LocalSeismogramImpl[] seismograms) throws CodecException, IOException, SQLException {
        for (int counter = 0; counter < seismograms.length; ++counter) {
            LocalSeismogramImpl seis = seismograms[counter];
            SacTimeSeries sac = FissuresToSac.getSAC(seis);
            File directory = new File(this.dataDirectoryName);
            if (!directory.exists()) {
                directory.mkdirs();
            }
            int id = this.ung.getUniqueIdentifier();
            File sacDirectory = new File(directory, PREFIX + id);
            sac.write(sacDirectory);
            long fileLength = sacDirectory.length();
            int fileid = this.getMaxFileID();
            this.fiInsertStmt.setInt(1, fileid);
            this.fiInsertStmt.setString(2, this.dataDirectoryName + PREFIX + id);
            this.fiInsertStmt.setLong(3, fileLength);
            this.fiInsertStmt.executeUpdate();
            this.insertRequestFilterInfo(ChannelIdUtil.toString((ChannelId)seis.getChannelID()), seis.getBeginTime(), seis.getEndTime(), fileid);
        }
        this.trimToMaxSize();
    }

    protected synchronized void trimToMaxSize() throws SQLException {
        try {
            if (this.getTotalSize() > this.maxDataSize) {
                logger.debug("trim to max size, currently at " + this.getTotalSize());
                ResultSet rs = this.getOldestStmt.executeQuery();
                int[] idArray = new int[1];
                for (int i = 0; i < 5 && rs.next(); ++i) {
                    idArray[0] = rs.getInt("fileid");
                    String[] paths = this.getFilePaths(idArray);
                    for (int j = 0; j < paths.length; ++j) {
                        File f = new File(paths[j]);
                        if (!f.delete()) {
                            logger.warn("Unable to delete " + paths[j]);
                            continue;
                        }
                        this.deleteStmt.setInt(1, idArray[0]);
                        this.deleteStmt.executeUpdate();
                        this.deleteStmt2.setInt(1, idArray[0]);
                        this.deleteStmt2.executeUpdate();
                        this.connection.commit();
                        logger.debug("trimed " + paths[j]);
                    }
                }
                rs.close();
                logger.debug("finished trim, size is now " + this.getTotalSize());
            }
        }
        catch (SQLException e) {
            logger.warn("Problem while deleting old data from cache.", (Throwable)e);
            throw e;
        }
    }

    public long getTotalSize() throws SQLException {
        ResultSet rs = this.getTotalSizeStmt.executeQuery();
        if (rs.next()) {
            return rs.getLong(1);
        }
        return -1L;
    }

    private int getMaxFileID() throws SQLException {
        ResultSet rs = this.maxFileIDStmt.executeQuery();
        if (rs.next()) {
            return rs.getInt("fileid") + 1;
        }
        return 0;
    }

    public int[] getFileIds(RequestFilter[] requestFilters) throws SQLException {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int counter = 0; counter < requestFilters.length; ++counter) {
            String channel_id = ChannelIdUtil.toString((ChannelId)requestFilters[counter].channel_id);
            MicroSecondDate beginDate = new MicroSecondDate(requestFilters[counter].start_time);
            MicroSecondDate endDate = new MicroSecondDate(requestFilters[counter].end_time);
            int[] ids = this.getFileIds(channel_id, beginDate, endDate);
            for (int subCounter = 0; subCounter < ids.length; ++subCounter) {
                arrayList.add(new Integer(ids[subCounter]));
            }
        }
        Integer[] rtnValues = new Integer[arrayList.size()];
        rtnValues = arrayList.toArray(rtnValues);
        int[] intValues = new int[rtnValues.length];
        for (int counter = 0; counter < rtnValues.length; ++counter) {
            intValues[counter] = rtnValues[counter];
        }
        return intValues;
    }

    public int[] getFileIds(String channel_id, MicroSecondDate beginDate, MicroSecondDate endDate) throws SQLException {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        this.rfGetStmt.setString(1, channel_id);
        this.rfGetStmt.setTimestamp(2, beginDate.getTimestamp());
        this.rfGetStmt.setTimestamp(3, endDate.getTimestamp());
        this.rfGetStmt.setTimestamp(4, beginDate.getTimestamp());
        this.rfGetStmt.setTimestamp(5, endDate.getTimestamp());
        ResultSet rs = this.rfGetStmt.executeQuery();
        while (rs.next()) {
            arrayList.add(new Integer(Integer.parseInt(rs.getString("fileid"))));
        }
        Integer[] rtnValues = new Integer[arrayList.size()];
        rtnValues = arrayList.toArray(rtnValues);
        int[] intValues = new int[rtnValues.length];
        for (int counter = 0; counter < rtnValues.length; ++counter) {
            intValues[counter] = rtnValues[counter];
        }
        return intValues;
    }

    public String[] getFilePaths(int[] fileids) throws SQLException {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int counter = 0; counter < fileids.length; ++counter) {
            this.fiGetStmt.setInt(1, fileids[counter]);
            ResultSet rs = this.fiGetStmt.executeQuery();
            while (rs.next()) {
                arrayList.add(rs.getString("filename"));
            }
        }
        String[] rtnValues = new String[arrayList.size()];
        rtnValues = arrayList.toArray(rtnValues);
        return rtnValues;
    }

    public LocalSeismogramImpl[] getSeismograms(RequestFilter[] requestFilters) throws SQLException, IOException, FissuresException {
        ArrayList<LocalSeismogramImpl> arrayList = new ArrayList<LocalSeismogramImpl>();
        int[] ids = this.getFileIds(requestFilters);
        String[] fileNames = this.getFilePaths(ids);
        for (int counter = 0; counter < fileNames.length; ++counter) {
            FileInputStream fis = new FileInputStream(fileNames[counter]);
            DataInputStream dis = new DataInputStream(new BufferedInputStream(fis));
            SacTimeSeries sac = new SacTimeSeries();
            sac.read((DataInput)dis);
            LocalSeismogramImpl seis = SacToFissures.getSeismogram(sac);
            arrayList.add(seis);
        }
        LocalSeismogramImpl[] rtnValues = new LocalSeismogramImpl[arrayList.size()];
        rtnValues = arrayList.toArray(rtnValues);
        return rtnValues;
    }

    public String getFileIds(ChannelId channel_id, MicroSecondDate beginDate, MicroSecondDate endDate) throws SQLException {
        this.rfGetFileIdStmt.setString(1, ChannelIdUtil.toString((ChannelId)channel_id));
        this.rfGetFileIdStmt.setTimestamp(2, beginDate.getTimestamp());
        this.rfGetFileIdStmt.setTimestamp(3, endDate.getTimestamp());
        this.rfGetFileIdStmt.setTimestamp(4, beginDate.getTimestamp());
        this.rfGetFileIdStmt.setTimestamp(5, endDate.getTimestamp());
        ResultSet rs = this.rfGetFileIdStmt.executeQuery();
        if (rs.next()) {
            Integer rtn = new Integer(rs.getInt("id"));
            return rtn.toString();
        }
        return null;
    }

    public LocalSeismogram getSeismogram(String fileids) throws SQLException, IOException, FissuresException {
        int value = Integer.parseInt(fileids);
        this.rfGetInfoStmt.setInt(1, value);
        ResultSet rs = this.rfGetInfoStmt.executeQuery();
        if (rs.next()) {
            MicroSecondDate endDate;
            MicroSecondDate beginDate;
            String channel_id = rs.getString("channel_id");
            int[] ids = this.getFileIds(channel_id, beginDate = new MicroSecondDate(rs.getTimestamp("begin_time")), endDate = new MicroSecondDate(rs.getTimestamp("end_time")));
            String[] fileNames = this.getFilePaths(ids);
            if (fileNames.length == 0) {
                return null;
            }
            FileInputStream fis = new FileInputStream(fileNames[0]);
            DataInputStream dis = new DataInputStream(new BufferedInputStream(fis));
            SacTimeSeries sac = new SacTimeSeries();
            sac.read((DataInput)dis);
            LocalSeismogramImpl seis = SacToFissures.getSeismogram(sac);
            return seis;
        }
        return null;
    }
}

