/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.database;

import edu.iris.Fissures.AuditInfo;
import edu.iris.Fissures.FissuresException;
import edu.iris.Fissures.seismogramDC.LocalSeismogramImpl;
import edu.sc.seis.fissuresUtil.database.DBDataCenter;
import edu.sc.seis.fissuresUtil.database.SeisInfoDb;
import java.io.IOException;
import java.sql.SQLException;

public class DataSetCache {
    String directoryName;
    String databaseName;

    public DataSetCache(String directoryName, String databaseName) {
        this.directoryName = directoryName;
        this.databaseName = databaseName;
    }

    public void addSeismogram(LocalSeismogramImpl seis, String name, AuditInfo[] auditInfo) throws SQLException {
        String fileids = DBDataCenter.getDataCenter(this.directoryName, this.databaseName).getFileIds(seis.getChannelID(), seis.getBeginTime(), seis.getEndTime());
        SeisInfoDb.getSeisInfoDb(this.directoryName, this.databaseName).insert(name, fileids);
    }

    public LocalSeismogramImpl getSeismogram(String name) throws SQLException, IOException, FissuresException {
        String fileids = SeisInfoDb.getSeisInfoDb(this.directoryName, this.databaseName).getFileIds(name);
        if (fileids == null) {
            return null;
        }
        return (LocalSeismogramImpl)DBDataCenter.getDataCenter(this.directoryName, this.databaseName).getSeismogram(fileids);
    }
}

