/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.database;

import edu.sc.seis.fissuresUtil.simple.Initializer;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.BasicConfigurator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnMgr {
    private static boolean firstConnection = true;
    private static String lastDriverForConnection;
    private static boolean firstTime;
    private static final String DEFAULT_LOC = "edu/sc/seis/fissuresUtil/database/props/";
    public static final String DEFAULT = "default";
    private static String DEFAULT_PROPS;
    public static final String HSQL = "HSQL";
    private static String HSQL_PROPS;
    public static final String MCKOI = "MCKOI";
    private static String MCKOI_PROPS;
    public static final String MYSQL = "MYSQL";
    public static final String MYSQL_PROPS = "Mysql.props";
    public static final String ORACLE = "ORACLE";
    public static final String ORACLE_PROPS = "Oracle.props";
    public static final String POSTGRES = "POSTGRES";
    public static final String POSTGRES_PROPS = "Postgres.props";
    public static final String EDB = "EDB";
    public static final String EDB_PROPS = "Edb.props";
    public static final String DB_SERVER_PORT = "server.port";
    public static final String DBURL_KEY = "fissuresUtil.database.url";
    public static final String DBUSER_KEY = "fissuresUtil.database.user";
    public static final String DBPASSWORD_KEY = "fissuresUtil.database.password";
    private static String DB_NAME;
    private static Properties props;
    private static Properties dbProperties;
    private static List propLocs;
    private static final Logger logger;
    private static String url;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addPropsLocation(String loc) {
        List list = propLocs;
        synchronized (list) {
            if (!propLocs.contains(loc)) {
                propLocs.add(loc);
            }
            if (props != null) {
                try {
                    ConnMgr.load(loc, props);
                }
                catch (IOException e) {
                    throw new RuntimeException("Bad props location " + loc, e);
                }
            }
        }
    }

    public static void setDB() throws IOException {
        ConnMgr.setDB(DB_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDB(String dbName) throws IOException {
        DB_NAME = dbName;
        Properties props = new Properties();
        List list = propLocs;
        synchronized (list) {
            Iterator it = propLocs.iterator();
            while (it.hasNext()) {
                ConnMgr.load((String)it.next(), props);
            }
        }
        ConnMgr.setDB(props);
    }

    private static void load(String loc, Properties existing) throws IOException {
        ClassLoader cl = ConnMgr.class.getClassLoader();
        ConnMgr.load(cl, loc + DEFAULT_PROPS, existing);
        if (DB_NAME == HSQL) {
            ConnMgr.load(cl, loc + HSQL_PROPS, existing);
        } else if (DB_NAME == MCKOI) {
            ConnMgr.load(cl, loc + MCKOI_PROPS, existing);
        } else if (DB_NAME == POSTGRES) {
            ConnMgr.load(cl, loc + POSTGRES_PROPS, existing);
        } else if (DB_NAME == EDB) {
            ConnMgr.load(cl, loc + EDB_PROPS, existing);
        } else if (DB_NAME == MYSQL) {
            ConnMgr.load(cl, loc + MYSQL_PROPS, existing);
        } else if (DB_NAME == ORACLE) {
            ConnMgr.load(cl, loc + ORACLE_PROPS, existing);
        }
    }

    private static void load(ClassLoader cl, String loc, Properties existing) throws IOException {
        InputStream in = cl.getResourceAsStream(loc);
        if (in != null) {
            existing.load(in);
        }
    }

    public static void setDB(Properties newprops) {
        props = newprops;
    }

    public static boolean hasSQL(String key) {
        return ConnMgr.getProps().containsKey(key);
    }

    public static String getSQL(String key) {
        String SQL = ConnMgr.getProps().getProperty(key);
        if (SQL == null) {
            throw new IllegalArgumentException("No such sql entry " + key + " Make sure the properties files are in the jars and are being loaded");
        }
        return SQL;
    }

    public static String getDriver() {
        return ConnMgr.getProps().getProperty("driver");
    }

    public static String getDB_TYPE() {
        return DB_NAME;
    }

    public static void setURL(String url) {
        if (url == null || url.length() == 0) {
            throw new RuntimeException("URL is empty.");
        }
        if (!firstConnection) {
            throw new RuntimeException("Attemp to set database url a second time: " + url);
        }
        try {
            ConnMgr.url = url;
            if (url.startsWith("jdbc:hsql")) {
                ConnMgr.setDB(HSQL);
            } else if (url.startsWith("jdbc:postgresql")) {
                ConnMgr.setDB(POSTGRES);
            } else if (url.startsWith("jdbc:edb")) {
                ConnMgr.setDB(EDB);
            } else if (url.startsWith("jdbc:mysql")) {
                ConnMgr.setDB(MYSQL);
                String[] splitURL = url.split("\\?");
                if (splitURL.length != 1) {
                    String[] URLparams;
                    for (String param : URLparams = splitURL[1].split("&")) {
                        if (param.startsWith("user=")) {
                            ConnMgr.getProps().setProperty("user", param.substring("user=".length()));
                        }
                        if (!param.startsWith("password=")) continue;
                        ConnMgr.getProps().setProperty("password", param.substring("password=".length()));
                    }
                }
            } else if (url.startsWith("jdbc:oracle")) {
                String[] URLparams;
                ConnMgr.setDB(ORACLE);
                String[] splitURL = url.indexOf("thin") > 0 ? url.split("@//")[0].split("thin:") : (url.indexOf("oci") > 0 ? (url.indexOf("@//") > 0 ? url.split("@//")[0].split("oci:") : url.split("@")[0].split("oci:")) : new String[]{});
                if (splitURL.length > 1 && (URLparams = splitURL[1].split("/")).length != 1) {
                    ConnMgr.getProps().setProperty("user", URLparams[0]);
                    ConnMgr.getProps().setProperty("password", URLparams[1]);
                }
            }
            ConnMgr.checkDriver();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to load driver: " + ConnMgr.getDriver(), e);
        }
    }

    public static void setURL(String url, String databaseUser, String databasePassword) {
        ConnMgr.setURL(url);
        if (databaseUser != null) {
            ConnMgr.getProps().setProperty("user", databaseUser);
        }
        if (databasePassword != null) {
            ConnMgr.getProps().setProperty("password", databasePassword);
        }
    }

    public static String getURL() {
        if (url == null) {
            url = ConnMgr.getProps().getProperty("URL");
        }
        return url;
    }

    public static String getPass() {
        return ConnMgr.getProps().getProperty("password");
    }

    public static String getUser() {
        return ConnMgr.getProps().getProperty("user");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties getProps() {
        Class<ConnMgr> clazz = ConnMgr.class;
        synchronized (ConnMgr.class) {
            if (props == null) {
                try {
                    ConnMgr.setDB();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return props;
        }
    }

    public static Properties getDBProps() {
        return dbProperties;
    }

    static void checkDriver() throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        String driver = ConnMgr.getDriver();
        if (firstTime) {
            logger.debug("Using " + driver + " on " + ConnMgr.getURL() + " for user " + ConnMgr.getUser());
            lastDriverForConnection = driver;
            firstTime = false;
        }
        if (!driver.equals(lastDriverForConnection)) {
            logger.warn("Previous connections were created with " + lastDriverForConnection + " but now " + driver + " is being used");
            lastDriverForConnection = driver;
        }
        Class.forName(ConnMgr.getDriver()).newInstance();
    }

    public static Connection createConnection() throws SQLException {
        try {
            ConnMgr.checkDriver();
        }
        catch (Exception e) {
            SQLException sql = new SQLException("Cannot create driver: " + ConnMgr.getDriver());
            sql.initCause(e);
            throw sql;
        }
        Connection conn = DriverManager.getConnection(ConnMgr.getURL(), ConnMgr.getUser(), ConnMgr.getPass());
        if (firstConnection && ConnMgr.getURL().startsWith("jdbc:hsql") && conn.getMetaData().getDatabaseProductVersion().compareTo("1.8.0") >= 0) {
            Statement stmt = conn.createStatement();
            try {
                stmt.execute("SET PROPERTY \"hsqldb.default_table_type\" 'CACHED'");
                stmt.execute("CHECKPOINT");
            }
            catch (SQLException e) {
                logger.debug("Unable to set default table type to CACHED", (Throwable)e);
            }
            firstConnection = false;
        }
        return conn;
    }

    public static void installDbProperties(Properties sysProperties, Properties dbProperties) {
        ConnMgr.dbProperties = dbProperties;
        if (dbProperties.containsKey(DB_SERVER_PORT)) {
            if (dbProperties.containsKey(DBURL_KEY)) {
                logger.error("-hsql properties and SOD properties are both specifying the db connection.  Using -hsql properties");
            }
            String url = "jdbc:hsqldb:hsql://localhost";
            if (dbProperties.containsKey(DB_SERVER_PORT)) {
                url = url + ":" + dbProperties.getProperty(DB_SERVER_PORT);
            }
            url = url + "/";
            if (dbProperties.containsKey("server.dbname.0")) {
                url = url + dbProperties.getProperty("server.dbname.0");
            }
            logger.debug("Setting db url from server.port to " + url);
            ConnMgr.setURL(url);
        } else if (dbProperties.containsKey(DBURL_KEY)) {
            logger.debug("Setting db url from fissuresUtil.database.url to " + dbProperties.getProperty(DBURL_KEY));
            ConnMgr.setURL(dbProperties.getProperty(DBURL_KEY));
        } else if (sysProperties.containsKey(DBURL_KEY)) {
            logger.debug("Setting db url from fissuresUtil.database.url in sys props to " + sysProperties.getProperty(DBURL_KEY));
            ConnMgr.setURL(sysProperties.getProperty(DBURL_KEY));
        } else {
            logger.debug("using default url of " + ConnMgr.getURL());
        }
        if (dbProperties.containsKey(DBUSER_KEY)) {
            logger.debug("Setting db user from fissuresUtil.database.user (db) to " + dbProperties.get(DBUSER_KEY));
            ConnMgr.getProps().put("user", dbProperties.get(DBUSER_KEY));
        } else if (sysProperties.containsKey(DBUSER_KEY)) {
            logger.debug("Setting db user from fissuresUtil.database.user (sys) to " + sysProperties.get(DBUSER_KEY));
            ConnMgr.getProps().put("user", sysProperties.get(DBUSER_KEY));
        }
        if (dbProperties.containsKey(DBPASSWORD_KEY)) {
            ConnMgr.getProps().put("password", dbProperties.get(DBPASSWORD_KEY));
        } else {
            ConnMgr.getProps().put("password", "");
        }
    }

    public static Properties readDbProperties(String[] args) {
        Properties dbProperties = new Properties();
        boolean loadedFromArg = false;
        for (int i = 0; i < args.length - 1; ++i) {
            if (!args[i].equals("-hsql")) continue;
            System.out.println("Loading db props from " + args[i + 1]);
            try {
                Initializer.loadProps(new FileInputStream(args[i + 1]), dbProperties);
            }
            catch (FileNotFoundException e) {
                logger.error("Unable to find file " + args[i + 1] + " specified by -hsql");
            }
            catch (IOException e) {
                logger.error("Error reading " + args[i + 1] + " specified by -hsql", (Throwable)e);
            }
            loadedFromArg = true;
        }
        if (!loadedFromArg) {
            try {
                logger.debug("No -hsql argument found, trying to load from server.properties in current working directory");
                Initializer.loadProps(new FileInputStream("server.properties"), dbProperties);
                logger.debug("loaded props from server.properties in working directory");
            }
            catch (FileNotFoundException e) {
                logger.debug("Didn't find default server.properties file");
            }
            catch (IOException e) {
                logger.error("Error reading default server.properties file", (Throwable)e);
            }
        }
        return dbProperties;
    }

    public static void installDbProperties(Properties sysProperties, String[] args) {
        ConnMgr.installDbProperties(sysProperties, ConnMgr.readDbProperties(args));
    }

    public static boolean checkDatabaseConn() throws SQLException {
        logger.info("URL: " + ConnMgr.getURL());
        logger.info("Type: " + ConnMgr.getDB_TYPE());
        logger.info("Driver: " + ConnMgr.getDriver());
        logger.info("User: " + ConnMgr.getUser());
        logger.info("Trying connection");
        Connection conn = ConnMgr.createConnection();
        logger.info("Connection ok, database version: " + conn.getMetaData().getDatabaseProductVersion());
        conn.close();
        return true;
    }

    public static void main(String[] args) throws SQLException {
        BasicConfigurator.configure();
        String url = args[0];
        logger.info("setting URL: " + url);
        ConnMgr.setURL(url);
        ConnMgr.checkDatabaseConn();
    }

    static {
        firstTime = true;
        DEFAULT_PROPS = "default.props";
        HSQL_PROPS = "HSQL.props";
        MCKOI_PROPS = "MCKOI.props";
        DB_NAME = HSQL;
        dbProperties = new Properties();
        propLocs = new ArrayList();
        logger = LoggerFactory.getLogger(ConnMgr.class);
        propLocs.add(DEFAULT_LOC);
    }
}

