/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.chooser;

import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.IfNetwork.StationId;
import edu.iris.Fissures.network.ChannelIdUtil;
import edu.sc.seis.fissuresUtil.time.MicroSecondTimeRange;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoarseAvailableData {
    Map<String, List<MicroSecondTimeRange>> cache = new HashMap<String, List<MicroSecondTimeRange>>();
    private static final Logger logger = LoggerFactory.getLogger(CoarseAvailableData.class);

    public synchronized void append(ChannelId chan, MicroSecondTimeRange range) {
        this.getList(chan).add(range);
    }

    public synchronized void update(ChannelId chan, List<MicroSecondTimeRange> rangeList) {
        this.cache.put(ChannelIdUtil.toString((ChannelId)chan), rangeList);
    }

    public synchronized List<MicroSecondTimeRange> get(ChannelId chan) {
        if (this.isCached(chan)) {
            return this.getList(chan);
        }
        return null;
    }

    public synchronized boolean isCached(ChannelId chan) {
        return this.cache.containsKey(ChannelIdUtil.toString((ChannelId)chan));
    }

    public synchronized boolean overlaps(ChannelId chan, MicroSecondTimeRange range) {
        if (this.isCached(chan)) {
            List<MicroSecondTimeRange> chanList = this.get(chan);
            for (MicroSecondTimeRange dataRange : chanList) {
                if (!range.intersects(dataRange)) continue;
                return true;
            }
        }
        return false;
    }

    public synchronized boolean anyChannelOverlaps(StationId station, MicroSecondTimeRange range) {
        String staPrefix = station.network_id.network_code + "." + station.station_code;
        for (String chanStr : this.cache.keySet()) {
            if (!chanStr.startsWith(staPrefix)) continue;
            List<MicroSecondTimeRange> chanList = this.cache.get(chanStr);
            for (MicroSecondTimeRange dataRange : chanList) {
                if (!range.intersects(dataRange)) continue;
                return true;
            }
        }
        return false;
    }

    private synchronized List<MicroSecondTimeRange> getList(ChannelId chan) {
        String chanIdStr = ChannelIdUtil.toString((ChannelId)chan);
        List<MicroSecondTimeRange> chanCache = this.cache.get(chanIdStr);
        if (chanCache == null) {
            chanCache = new ArrayList<MicroSecondTimeRange>();
            this.cache.put(chanIdStr, chanCache);
        }
        return chanCache;
    }
}

