/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.cache;

import edu.iris.Fissures.Dimension;
import edu.iris.Fissures.IfEvent.EventAccess;
import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.IfPlottable.PlottableDC;
import edu.iris.Fissures.IfPlottable.PlottableDCOperations;
import edu.iris.Fissures.IfPlottable.PlottableNotAvailable;
import edu.iris.Fissures.IfPlottable.UnsupportedDimension;
import edu.iris.Fissures.IfSeismogramDC.RequestFilter;
import edu.iris.Fissures.NotImplemented;
import edu.iris.Fissures.Plottable;
import edu.sc.seis.fissuresUtil.cache.ClassicRetryStrategy;
import edu.sc.seis.fissuresUtil.cache.CorbaServerWrapper;
import edu.sc.seis.fissuresUtil.cache.NSPlottableDC;
import edu.sc.seis.fissuresUtil.cache.ProxyPlottableDC;
import edu.sc.seis.fissuresUtil.cache.ProxySeismogramDC;
import edu.sc.seis.fissuresUtil.cache.RetryStrategy;
import org.omg.CORBA.SystemException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryPlottableDC
implements ProxyPlottableDC,
CorbaServerWrapper {
    NSPlottableDC plottable;
    int retry;
    RetryStrategy strat;
    private static final Logger logger = LoggerFactory.getLogger(RetryPlottableDC.class);

    public RetryPlottableDC(NSPlottableDC plottable, int retry) {
        this(plottable, new ClassicRetryStrategy(retry));
    }

    public RetryPlottableDC(NSPlottableDC plottable, RetryStrategy strat) {
        this.plottable = plottable;
        this.strat = strat;
    }

    public boolean custom_sizes() {
        int count = 0;
        SystemException lastException = null;
        try {
            return this.plottable.custom_sizes();
        }
        catch (SystemException t) {
            lastException = t;
        }
        catch (OutOfMemoryError e) {
            throw new RuntimeException("Out of memory", e);
        }
        while (this.strat.shouldRetry(lastException, this, count++)) {
            try {
                boolean result = this.plottable.custom_sizes();
                this.strat.serverRecovered(this);
                return result;
            }
            catch (SystemException t) {
                lastException = t;
            }
            catch (OutOfMemoryError e) {
                throw new RuntimeException("Out of memory", e);
            }
        }
        throw lastException;
    }

    public Plottable[] get_plottable(RequestFilter request, Dimension pixel_size) throws PlottableNotAvailable, UnsupportedDimension, NotImplemented {
        int count = 0;
        SystemException lastException = null;
        try {
            return this.plottable.get_plottable(request, pixel_size);
        }
        catch (SystemException t) {
            lastException = t;
        }
        catch (OutOfMemoryError e) {
            throw new RuntimeException("Out of memory", e);
        }
        while (this.strat.shouldRetry(lastException, this, count++)) {
            try {
                Plottable[] result = this.plottable.get_plottable(request, pixel_size);
                this.strat.serverRecovered(this);
                return result;
            }
            catch (SystemException t) {
                lastException = t;
            }
            catch (OutOfMemoryError e) {
                throw new RuntimeException("Out of memory", e);
            }
        }
        throw lastException;
    }

    public Dimension[] get_whole_day_sizes() {
        int count = 0;
        SystemException lastException = null;
        try {
            return this.plottable.get_whole_day_sizes();
        }
        catch (SystemException t) {
            lastException = t;
        }
        catch (OutOfMemoryError e) {
            throw new RuntimeException("Out of memory", e);
        }
        while (this.strat.shouldRetry(lastException, this, count++)) {
            try {
                Dimension[] result = this.plottable.get_whole_day_sizes();
                this.strat.serverRecovered(this);
                return result;
            }
            catch (SystemException t) {
                lastException = t;
            }
            catch (OutOfMemoryError e) {
                throw new RuntimeException("Out of memory", e);
            }
        }
        throw lastException;
    }

    public Plottable[] get_for_day(ChannelId channel_id, int year, int jday, Dimension pixel_size) throws PlottableNotAvailable, UnsupportedDimension {
        int count = 0;
        SystemException lastException = null;
        try {
            return this.plottable.get_for_day(channel_id, year, jday, pixel_size);
        }
        catch (SystemException t) {
            lastException = t;
        }
        catch (OutOfMemoryError e) {
            throw new RuntimeException("Out of memory", e);
        }
        while (this.strat.shouldRetry(lastException, this, count++)) {
            try {
                Plottable[] result = this.plottable.get_for_day(channel_id, year, jday, pixel_size);
                this.strat.serverRecovered(this);
                return result;
            }
            catch (SystemException t) {
                lastException = t;
            }
            catch (OutOfMemoryError e) {
                throw new RuntimeException("Out of memory", e);
            }
        }
        throw lastException;
    }

    public Dimension[] get_event_sizes() {
        int count = 0;
        SystemException lastException = null;
        try {
            return this.plottable.get_event_sizes();
        }
        catch (SystemException t) {
            lastException = t;
        }
        catch (OutOfMemoryError e) {
            throw new RuntimeException("Out of memory", e);
        }
        while (this.strat.shouldRetry(lastException, this, count++)) {
            try {
                Dimension[] result = this.plottable.get_event_sizes();
                this.strat.serverRecovered(this);
                return result;
            }
            catch (SystemException t) {
                lastException = t;
            }
            catch (OutOfMemoryError e) {
                throw new RuntimeException("Out of memory", e);
            }
        }
        throw lastException;
    }

    public Plottable[] get_for_event(EventAccess event, ChannelId channel_id, Dimension pixel_size) throws PlottableNotAvailable, UnsupportedDimension {
        int count = 0;
        SystemException lastException = null;
        try {
            return this.plottable.get_for_event(event, channel_id, pixel_size);
        }
        catch (SystemException t) {
            lastException = t;
        }
        catch (OutOfMemoryError e) {
            throw new RuntimeException("Out of memory", e);
        }
        while (this.strat.shouldRetry(lastException, this, count++)) {
            try {
                Plottable[] result = this.plottable.get_for_event(event, channel_id, pixel_size);
                this.strat.serverRecovered(this);
                return result;
            }
            catch (SystemException t) {
                lastException = t;
            }
            catch (OutOfMemoryError e) {
                throw new RuntimeException("Out of memory", e);
            }
        }
        throw lastException;
    }

    @Override
    public PlottableDCOperations getWrappedDC() {
        return this.plottable;
    }

    @Override
    public PlottableDCOperations getWrappedDC(Class wrappedClass) {
        if (this.getWrappedDC().getClass().equals(wrappedClass)) {
            return this.getWrappedDC();
        }
        if (this.getWrappedDC() instanceof ProxySeismogramDC) {
            ((ProxyPlottableDC)this.getWrappedDC()).getWrappedDC(wrappedClass);
        }
        throw new IllegalArgumentException("This doesn't contain a DC of class " + wrappedClass);
    }

    @Override
    public void reset() {
        if (this.plottable instanceof ProxyPlottableDC) {
            this.plottable.reset();
        }
    }

    @Override
    public PlottableDC getCorbaObject() {
        if (this.plottable instanceof PlottableDC) {
            return (PlottableDC)this.plottable;
        }
        if (this.plottable instanceof ProxyPlottableDC) {
            return this.plottable.getCorbaObject();
        }
        throw new RuntimeException("subplottable not a PlottableDC or ProxyPlottableDC");
    }

    @Override
    public String getFullName() {
        return this.getServerDNS() + "/" + this.getServerName();
    }

    @Override
    public String getServerDNS() {
        return this.plottable.getServerDNS();
    }

    @Override
    public String getServerName() {
        return this.plottable.getServerName();
    }

    @Override
    public String getServerType() {
        return this.plottable.getServerType();
    }
}

