/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.cache;

import edu.iris.Fissures.IfNetwork.NetworkAccess;
import edu.iris.Fissures.IfNetwork.NetworkFinder;
import edu.iris.Fissures.IfNetwork.NetworkId;
import edu.iris.Fissures.IfNetwork.NetworkNotFound;
import edu.sc.seis.fissuresUtil.cache.ProxyNetworkFinder;
import edu.sc.seis.fissuresUtil.cache.RetryStrategy;
import org.omg.CORBA.SystemException;

public class RetryNetworkFinder
extends ProxyNetworkFinder {
    private RetryStrategy strategy;

    public RetryNetworkFinder(NetworkFinder nf, RetryStrategy strategy) {
        super(nf);
        this.strategy = strategy;
    }

    @Override
    public NetworkAccess[] retrieve_all() {
        SystemException latest;
        int count = 0;
        try {
            return super.retrieve_all();
        }
        catch (SystemException t) {
            latest = t;
        }
        catch (OutOfMemoryError e) {
            throw new RuntimeException("Out of memory", e);
        }
        while (this.shouldRetry(count++, latest)) {
            try {
                NetworkAccess[] result = super.retrieve_all();
                this.strategy.serverRecovered(this);
                return result;
            }
            catch (SystemException t) {
                latest = t;
            }
            catch (OutOfMemoryError e) {
                throw new RuntimeException("Out of memory", e);
            }
        }
        throw latest;
    }

    @Override
    public NetworkAccess[] retrieve_by_code(String code) throws NetworkNotFound {
        SystemException latest;
        int count = 0;
        try {
            return super.retrieve_by_code(code);
        }
        catch (SystemException t) {
            latest = t;
        }
        catch (OutOfMemoryError e) {
            throw new RuntimeException("Out of memory", e);
        }
        while (this.shouldRetry(count++, latest)) {
            try {
                NetworkAccess[] result = super.retrieve_by_code(code);
                this.strategy.serverRecovered(this);
                return result;
            }
            catch (SystemException t) {
                latest = t;
            }
            catch (OutOfMemoryError e) {
                throw new RuntimeException("Out of memory", e);
            }
        }
        throw latest;
    }

    @Override
    public NetworkAccess retrieve_by_id(NetworkId id) throws NetworkNotFound {
        SystemException latest;
        int count = 0;
        try {
            return super.retrieve_by_id(id);
        }
        catch (SystemException t) {
            latest = t;
        }
        catch (OutOfMemoryError e) {
            throw new RuntimeException("Out of memory", e);
        }
        while (this.shouldRetry(count++, latest)) {
            try {
                NetworkAccess result = super.retrieve_by_id(id);
                this.strategy.serverRecovered(this);
                return result;
            }
            catch (SystemException t) {
                latest = t;
            }
            catch (OutOfMemoryError e) {
                throw new RuntimeException("Out of memory", e);
            }
        }
        throw latest;
    }

    @Override
    public NetworkAccess[] retrieve_by_name(String name) throws NetworkNotFound {
        SystemException latest;
        int count = 0;
        try {
            return super.retrieve_by_name(name);
        }
        catch (SystemException t) {
            latest = t;
        }
        catch (OutOfMemoryError e) {
            throw new RuntimeException("Out of memory", e);
        }
        while (this.shouldRetry(count++, latest)) {
            try {
                NetworkAccess[] result = super.retrieve_by_name(name);
                this.strategy.serverRecovered(this);
                return result;
            }
            catch (SystemException t) {
                latest = t;
            }
            catch (OutOfMemoryError e) {
                throw new RuntimeException("Out of memory", e);
            }
        }
        throw latest;
    }

    private boolean shouldRetry(int count, SystemException t) {
        return this.strategy.shouldRetry(t, this, count);
    }
}

