/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.cache;

import edu.iris.Fissures.FissuresException;
import edu.iris.Fissures.IfSeismogramDC.DataCenterCallBack;
import edu.iris.Fissures.IfSeismogramDC.LocalSeismogram;
import edu.iris.Fissures.IfSeismogramDC.RequestFilter;
import edu.iris.Fissures.Time;
import edu.iris.Fissures.seismogramDC.LocalSeismogramImpl;
import edu.sc.seis.fissuresUtil.bag.Cut;
import edu.sc.seis.fissuresUtil.cache.AbstractProxySeismogramDC;
import edu.sc.seis.fissuresUtil.cache.ProxySeismogramDC;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoarseRequestCutSeismogramDC
extends AbstractProxySeismogramDC {
    private static final Logger logger = LoggerFactory.getLogger(CoarseRequestCutSeismogramDC.class);

    public CoarseRequestCutSeismogramDC(ProxySeismogramDC dc) {
        super(dc);
    }

    public RequestFilter[] available_data(RequestFilter[] aFilterseq) {
        return this.getWrappedDC().available_data(aFilterseq);
    }

    public void cancel_request(String aRequest) throws FissuresException {
        this.getWrappedDC().cancel_request(aRequest);
    }

    public String queue_seismograms(RequestFilter[] aFilterseq) throws FissuresException {
        return this.getWrappedDC().queue_seismograms(aFilterseq);
    }

    public String request_seismograms(RequestFilter[] aFilterseq, DataCenterCallBack aClient, boolean longLived, Time expirationTime) throws FissuresException {
        return this.getWrappedDC().request_seismograms(aFilterseq, aClient, longLived, expirationTime);
    }

    public String request_status(String aRequest) throws FissuresException {
        return this.request_status(aRequest);
    }

    public LocalSeismogram[] retrieve_queue(String aRequest) throws FissuresException {
        return this.getWrappedDC().retrieve_queue(aRequest);
    }

    public LocalSeismogram[] retrieve_seismograms(RequestFilter[] aFilterseq) throws FissuresException {
        LocalSeismogram[] orig = this.getWrappedDC().retrieve_seismograms(aFilterseq);
        LocalSeismogramImpl[] out = Cut.coarseCut(aFilterseq, orig);
        int origNpts = 0;
        for (int i = 0; i < orig.length; ++i) {
            origNpts += orig[i].num_points;
        }
        int outNpts = 0;
        for (int i = 0; i < out.length; ++i) {
            outNpts += out[i].num_points;
        }
        if ((double)(origNpts - outNpts) > 0.2 * (double)outNpts) {
            logger.warn("Server sent seismograms significantly beyond request: orig num points=" + origNpts + "  cut num points=" + outNpts);
        }
        return out;
    }

    public String toString() {
        return "CoarseCut " + this.getWrappedDC().toString();
    }
}

