/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.cache;

import edu.sc.seis.fissuresUtil.cache.BaseRetryStrategy;
import edu.sc.seis.fissuresUtil.cache.CorbaServerWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassicRetryStrategy
extends BaseRetryStrategy {
    private static final Logger logger = LoggerFactory.getLogger(ClassicRetryStrategy.class);

    public ClassicRetryStrategy(int numRetries) {
        super(numRetries);
    }

    @Override
    public boolean shouldRetry(Throwable exc, Object server, int tryCount) {
        String tryString = this.numRetries != -1 ? "" + this.numRetries : "infinity";
        String name = server instanceof CorbaServerWrapper ? ((CorbaServerWrapper)server).getFullName() : server.toString();
        logger.debug("Caught exception on " + name + ", retrying " + tryCount + " of " + tryString, exc);
        return this.basicShouldRetry(exc, server, tryCount);
    }

    @Override
    public void serverRecovered(Object server) {
        String name = server instanceof CorbaServerWrapper ? ((CorbaServerWrapper)server).getFullName() : server.toString();
        logger.debug(name + " recovered");
    }
}

