/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.bag;

import edu.iris.Fissures.FissuresException;
import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.IfNetwork.Instrumentation;
import edu.iris.Fissures.IfNetwork.Sensitivity;
import edu.iris.Fissures.IfSeismogramDC.SeismogramAttr;
import edu.iris.Fissures.Unit;
import edu.iris.Fissures.network.ChannelIdUtil;
import edu.iris.Fissures.seismogramDC.LocalSeismogramImpl;
import edu.sc.seis.fissuresUtil.cache.InstrumentationLoader;

public class ResponseGain {
    public static LocalSeismogramImpl apply(LocalSeismogramImpl seis, Instrumentation inst) throws FissuresException {
        if (!InstrumentationLoader.isValid(inst)) {
            throw new IllegalArgumentException("Invalid instrumentation for " + ChannelIdUtil.toString((ChannelId)seis.channel_id));
        }
        return ResponseGain.apply(seis, inst.the_response.the_sensitivity, inst.the_response.stages[0].input_units);
    }

    public static LocalSeismogramImpl apply(LocalSeismogramImpl seis, Sensitivity sensitivity, Unit initialUnits) throws FissuresException {
        return ResponseGain.apply(seis, sensitivity.sensitivity_factor, initialUnits);
    }

    public static LocalSeismogramImpl apply(LocalSeismogramImpl seis, float sensitivity_factor, Unit initialUnits) throws FissuresException {
        LocalSeismogramImpl outSeis;
        if (seis.can_convert_to_float()) {
            float[] fSeries = seis.get_as_floats();
            float[] out = new float[fSeries.length];
            for (int i = 0; i < fSeries.length; ++i) {
                out[i] = fSeries[i] / sensitivity_factor;
            }
            outSeis = new LocalSeismogramImpl((SeismogramAttr)seis, out);
        } else {
            double[] dSeries = seis.get_as_doubles();
            double[] out = new double[dSeries.length];
            for (int i = 0; i < dSeries.length; ++i) {
                out[i] = dSeries[i] / (double)sensitivity_factor;
            }
            outSeis = new LocalSeismogramImpl((SeismogramAttr)seis, out);
        }
        outSeis.y_unit = initialUnits;
        return outSeis;
    }
}

