/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.bag;

import edu.iris.Fissures.FissuresException;
import edu.iris.Fissures.IfSeismogramDC.SeismogramAttr;
import edu.iris.Fissures.Quantity;
import edu.iris.Fissures.Unit;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.model.SamplingImpl;
import edu.iris.Fissures.model.TimeInterval;
import edu.iris.Fissures.model.UnitImpl;
import edu.iris.Fissures.seismogramDC.LocalSeismogramImpl;

public class Calculus {
    public static int[] difference(int[] data) {
        int[] out = new int[data.length - 1];
        for (int i = 0; i < out.length; ++i) {
            out[i] = data[i + 1] - data[i];
        }
        return out;
    }

    public static LocalSeismogramImpl difference(LocalSeismogramImpl seis) throws FissuresException {
        int[] seisData = seis.get_as_longs();
        int[] out = Calculus.difference(seisData);
        return new LocalSeismogramImpl((SeismogramAttr)seis, out);
    }

    public static LocalSeismogramImpl differentiate(LocalSeismogramImpl seis) throws FissuresException {
        LocalSeismogramImpl outSeis;
        Object[] data;
        SamplingImpl samp = seis.getSampling();
        double sampPeriod = samp.getPeriod().convertTo(UnitImpl.SECOND).getValue();
        if (seis.can_convert_to_float()) {
            data = seis.get_as_floats();
            float[] out = new float[data.length - 1];
            for (int i = 0; i < out.length; ++i) {
                out[i] = (float)((double)(data[i + 1] - data[i]) / sampPeriod);
            }
            outSeis = new LocalSeismogramImpl((SeismogramAttr)seis, out);
        } else {
            data = seis.get_as_doubles();
            double[] out = new double[data.length - 1];
            for (int i = 0; i < out.length; ++i) {
                out[i] = (data[i + 1] - data[i]) / sampPeriod;
            }
            outSeis = new LocalSeismogramImpl((SeismogramAttr)seis, out);
        }
        outSeis.y_unit = UnitImpl.divide((UnitImpl)UnitImpl.createUnitImpl((Unit)outSeis.y_unit), (UnitImpl)UnitImpl.SECOND);
        MicroSecondDate begin = outSeis.getBeginTime();
        begin.add(new TimeInterval((Quantity)samp.getPeriod().divideBy(2.0)));
        outSeis.begin_time = begin.getFissuresTime();
        return outSeis;
    }

    public static LocalSeismogramImpl integrate(LocalSeismogramImpl seis) throws FissuresException {
        LocalSeismogramImpl outSeis;
        SamplingImpl samp = seis.getSampling();
        double sampPeriod = samp.getPeriod().convertTo(UnitImpl.SECOND).getValue();
        if (seis.can_convert_to_float()) {
            float[] data = seis.get_as_floats();
            float[] out = new float[data.length];
            out[0] = 0.0f;
            for (int i = 1; i < out.length; ++i) {
                out[i] = out[i - 1] + (data[i - 1] + data[i]) / 2.0f * (float)sampPeriod;
            }
            outSeis = new LocalSeismogramImpl((SeismogramAttr)seis, out);
        } else {
            double[] data = seis.get_as_doubles();
            double[] out = new double[data.length];
            out[0] = 0.0;
            for (int i = 1; i < out.length; ++i) {
                out[i] = out[i - 1] + (data[i - 1] + data[i]) / 2.0 * sampPeriod;
            }
            outSeis = new LocalSeismogramImpl((SeismogramAttr)seis, out);
        }
        outSeis.y_unit = UnitImpl.multiply((UnitImpl)UnitImpl.createUnitImpl((Unit)outSeis.y_unit), (UnitImpl)UnitImpl.SECOND);
        return outSeis;
    }
}

