/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.bag;

import edu.iris.Fissures.Area;
import edu.iris.Fissures.BoxArea;
import edu.iris.Fissures.GlobalArea;
import edu.iris.Fissures.Location;
import edu.iris.Fissures.LocationType;
import edu.iris.Fissures.PointDistanceArea;
import edu.iris.Fissures.Quantity;
import edu.iris.Fissures.model.BoxAreaImpl;
import edu.iris.Fissures.model.QuantityImpl;
import edu.iris.Fissures.model.UnitImpl;
import edu.iris.Fissures.network.ChannelImpl;
import edu.sc.seis.TauP.SphericalCoords;
import edu.sc.seis.fissuresUtil.bag.DistAz;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class AreaUtil {
    public static BoxArea makeContainingBox(Area a) {
        if (a instanceof BoxArea) {
            return (BoxArea)a;
        }
        if (a instanceof GlobalArea) {
            return new BoxAreaImpl(-90.0f, 90.0f, -180.0f, 180.0f);
        }
        if (a instanceof PointDistanceArea) {
            float maxLat;
            PointDistanceArea pda = (PointDistanceArea)a;
            float maxDegree = (float)AreaUtil.distanceToDegrees(pda.max_distance);
            if (maxDegree >= 180.0f) {
                return new BoxAreaImpl(-90.0f, 90.0f, -180.0f, 180.0f);
            }
            float maxLong = AreaUtil.wrapLong((float)SphericalCoords.lonFor((double)pda.latitude, (double)pda.longitude, (double)maxDegree, (double)90.0));
            float minLong = AreaUtil.wrapLong((float)SphericalCoords.lonFor((double)pda.latitude, (double)pda.longitude, (double)maxDegree, (double)-90.0));
            float minLat = pda.latitude - maxDegree;
            if (minLat < -90.0f) {
                minLat = -90.0f;
            }
            if ((maxLat = pda.latitude + maxDegree) > 90.0f) {
                maxLat = 90.0f;
            }
            return new BoxAreaImpl(minLat, maxLat, minLong, maxLong);
        }
        throw new RuntimeException("Unknown Area: " + a.getClass().getName());
    }

    private static float wrapLong(float lon) {
        if (lon > 180.0f) {
            return -180.0f + (lon - 180.0f);
        }
        if (lon < -180.0f) {
            lon = 180.0f + (lon + 180.0f);
        }
        return lon;
    }

    public static List<ChannelImpl> inArea(Area area, List<ChannelImpl> channels) {
        ArrayList<ChannelImpl> out = new ArrayList<ChannelImpl>();
        for (ChannelImpl chan : channels) {
            if (!AreaUtil.inArea(area, chan.getSite().getLocation())) continue;
            out.add(chan);
        }
        return out;
    }

    public static boolean inArea(Area area, Location point) {
        return AreaUtil.inArea(area, point.latitude, point.longitude);
    }

    public static boolean inArea(Area area, double latitude, double longitude) {
        if (area instanceof GlobalArea) {
            return true;
        }
        if (area instanceof BoxArea) {
            return AreaUtil.inBox((BoxArea)area, latitude, longitude);
        }
        if (area instanceof PointDistanceArea) {
            return AreaUtil.inDonut((PointDistanceArea)area, latitude, longitude);
        }
        throw new RuntimeException("Unknown Area type: " + area.getClass().getName());
    }

    private static boolean inDonut(PointDistanceArea a, double latitude, double longitude) {
        DistAz distAz = new DistAz(a.latitude, a.longitude, latitude, longitude);
        double minDegree = AreaUtil.distanceToDegrees(a.min_distance);
        double maxDegree = AreaUtil.distanceToDegrees(a.max_distance);
        return distAz.getDelta() >= minDegree && distAz.getDelta() <= maxDegree;
    }

    private static double distanceToDegrees(Quantity minDist) {
        if (((UnitImpl)minDist.the_units).isConvertableTo(UnitImpl.DEGREE)) {
            return ((QuantityImpl)minDist).getValue(UnitImpl.DEGREE);
        }
        return DistAz.kilometersToDegrees(((QuantityImpl)minDist).getValue(UnitImpl.KILOMETER));
    }

    private static boolean inBox(BoxArea box, double latitude, double longitude) {
        return latitude >= (double)box.min_latitude && latitude <= (double)box.max_latitude && longitude % 360.0 >= (double)(box.min_longitude % 360.0f) && longitude % 360.0 <= (double)(box.max_longitude % 360.0f);
    }

    public static boolean inArea(Location[] bounds, Location point) {
        int inside = 0;
        for (int i = 0; i < bounds.length; ++i) {
            float lonA = bounds[i].longitude - point.longitude;
            float latA = bounds[i].latitude - point.latitude;
            float lonB = bounds[(i + 1) % bounds.length].longitude - point.longitude;
            float latB = bounds[(i + 1) % bounds.length].latitude - point.latitude;
            int check = AreaUtil.polygonPointCheck(lonA, latA, lonB, latB);
            if (check == 4) {
                return true;
            }
            inside += check;
        }
        return inside != 0;
    }

    private static int polygonPointCheck(float lonA, float latA, float lonB, float latB) {
        if (latA * latB > 0.0f) {
            return 0;
        }
        if (lonA * latB != lonB * latA || lonA * lonB > 0.0f) {
            if (latA * latB < 0.0f) {
                if (latA > 0.0f) {
                    if (latA * lonB >= lonA * latB) {
                        return 0;
                    }
                    return -2;
                }
                if (lonA * latB >= latA * lonB) {
                    return 0;
                }
                return 2;
            }
            if (latB == 0.0f) {
                if (latA == 0.0f) {
                    return 0;
                }
                if (lonB > 0.0f) {
                    return 0;
                }
                if (latA > 0.0f) {
                    return -1;
                }
                return 1;
            }
            if (lonA > 0.0f) {
                return 0;
            }
            if (latB > 0.0f) {
                return 1;
            }
            return -1;
        }
        return 4;
    }

    public static Location[] loadPolygon(BufferedReader in) throws IOException {
        String line;
        ArrayList<Location> out = new ArrayList<Location>();
        while ((line = in.readLine()) != null) {
            if ((line = line.trim()).startsWith("#") || line.length() < 3) continue;
            StringTokenizer tokenizer = new StringTokenizer(line);
            float lon = BoxAreaImpl.sanitize((float)Float.parseFloat(tokenizer.nextToken()));
            float lat = Float.parseFloat(tokenizer.nextToken());
            out.add(new Location(lat, lon, null, null, LocationType.GEOGRAPHIC));
        }
        return out.toArray(new Location[0]);
    }
}

