/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.backport.java.util.concurrent;

import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import edu.emory.mathcs.backport.java.util.concurrent.helpers.FIFOWaitQueue;
import edu.emory.mathcs.backport.java.util.concurrent.helpers.Utils;
import edu.emory.mathcs.backport.java.util.concurrent.helpers.WaitQueue;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collection;

public class Semaphore
implements Serializable {
    private static final long serialVersionUID = -3222578661600680210L;
    private final Sync sync;

    public Semaphore(int n) {
        this.sync = new NonfairSync(n);
    }

    public Semaphore(int n, boolean bl) {
        this.sync = bl ? new FairSync(n) : new NonfairSync(n);
    }

    public void acquire() throws InterruptedException {
        this.sync.acquire();
    }

    public void acquireUninterruptibly() {
        boolean bl = false;
        while (true) {
            try {
                this.sync.acquire();
                if (bl) {
                    Thread.currentThread().interrupt();
                }
                return;
            }
            catch (InterruptedException interruptedException) {
                bl = true;
                continue;
            }
            break;
        }
    }

    public boolean tryAcquire() {
        return this.sync.attempt();
    }

    public boolean tryAcquire(long l, TimeUnit timeUnit) throws InterruptedException {
        return this.sync.attempt(timeUnit.toNanos(l));
    }

    public void release() {
        this.sync.release(1);
    }

    public void release(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        this.sync.release(n);
    }

    public int availablePermits() {
        return this.sync.getPermits();
    }

    public int drainPermits() {
        return this.sync.drain();
    }

    protected void reducePermits(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        this.sync.reduce(n);
    }

    public boolean isFair() {
        return this.sync instanceof FairSync;
    }

    public final boolean hasQueuedThreads() {
        return this.sync.hasQueuedThreads();
    }

    public final int getQueueLength() {
        return this.sync.getQueueLength();
    }

    protected Collection getQueuedThreads() {
        return this.sync.getQueuedThreads();
    }

    public String toString() {
        return super.toString() + "[Permits = " + this.sync.getPermits() + "]";
    }

    static final class FairSync
    extends Sync
    implements WaitQueue.QueuedSync {
        private static final long serialVersionUID = 2014338818796000944L;
        private transient WaitQueue wq_ = new FIFOWaitQueue();

        FairSync(int n) {
            super(n);
        }

        public void acquire() throws InterruptedException {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            if (this.precheck()) {
                return;
            }
            WaitQueue.WaitNode waitNode = new WaitQueue.WaitNode();
            waitNode.doWait(this);
        }

        public boolean attempt(long l) throws InterruptedException {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            if (this.precheck()) {
                return true;
            }
            if (l <= 0L) {
                return false;
            }
            WaitQueue.WaitNode waitNode = new WaitQueue.WaitNode();
            return waitNode.doTimedWait(this, l);
        }

        protected synchronized boolean precheck() {
            boolean bl;
            boolean bl2 = bl = this.permits_ > 0;
            if (bl) {
                --this.permits_;
            }
            return bl;
        }

        public synchronized boolean recheck(WaitQueue.WaitNode waitNode) {
            boolean bl;
            boolean bl2 = bl = this.permits_ > 0;
            if (bl) {
                --this.permits_;
            } else {
                this.wq_.insert(waitNode);
            }
            return bl;
        }

        public void takeOver(WaitQueue.WaitNode waitNode) {
        }

        protected synchronized WaitQueue.WaitNode getSignallee() {
            WaitQueue.WaitNode waitNode = this.wq_.extract();
            if (waitNode == null) {
                ++this.permits_;
            }
            return waitNode;
        }

        public void release() {
            WaitQueue.WaitNode waitNode;
            do {
                if ((waitNode = this.getSignallee()) != null) continue;
                return;
            } while (!waitNode.signal(this));
        }

        public void release(int n) {
            if (n < 0) {
                throw new IllegalArgumentException("Negative argument");
            }
            for (int i = 0; i < n; ++i) {
                this.release();
            }
        }

        public synchronized boolean hasQueuedThreads() {
            return this.wq_.hasNodes();
        }

        public synchronized int getQueueLength() {
            return this.wq_.getLength();
        }

        public synchronized Collection getQueuedThreads() {
            return this.wq_.getWaitingThreads();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.defaultReadObject();
            FairSync fairSync = this;
            synchronized (fairSync) {
                this.wq_ = new FIFOWaitQueue();
            }
        }
    }

    static final class NonfairSync
    extends Sync {
        private static final long serialVersionUID = -2694183684443567898L;

        protected NonfairSync(int n) {
            super(n);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void acquire() throws InterruptedException {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            NonfairSync nonfairSync = this;
            synchronized (nonfairSync) {
                try {
                    while (this.permits_ <= 0) {
                        this.wait();
                    }
                    --this.permits_;
                }
                catch (InterruptedException interruptedException) {
                    this.notify();
                    throw interruptedException;
                }
            }
        }

        public boolean attempt(long l) throws InterruptedException {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            NonfairSync nonfairSync = this;
            synchronized (nonfairSync) {
                if (this.permits_ > 0) {
                    --this.permits_;
                    return true;
                }
                if (l <= 0L) {
                    return false;
                }
                try {
                    long l2 = Utils.nanoTime() + l;
                    do {
                        TimeUnit.NANOSECONDS.timedWait(this, l);
                        if (this.permits_ <= 0) continue;
                        --this.permits_;
                        return true;
                    } while ((l = l2 - Utils.nanoTime()) > 0L);
                    return false;
                }
                catch (InterruptedException interruptedException) {
                    this.notify();
                    throw interruptedException;
                }
            }
        }

        public synchronized void release(int n) {
            if (n < 0) {
                throw new IllegalArgumentException("Negative argument");
            }
            this.permits_ += n;
            for (int i = 0; i < n; ++i) {
                this.notify();
            }
        }

        public boolean hasQueuedThreads() {
            throw new UnsupportedOperationException("Use FAIR version");
        }

        public int getQueueLength() {
            throw new UnsupportedOperationException("Use FAIR version");
        }

        public Collection getQueuedThreads() {
            throw new UnsupportedOperationException("Use FAIR version");
        }
    }

    static abstract class Sync
    implements Serializable {
        private static final long serialVersionUID = 1192457210091910933L;
        int permits_;

        protected Sync(int n) {
            this.permits_ = n;
        }

        abstract void acquire() throws InterruptedException;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean attempt() {
            Sync sync = this;
            synchronized (sync) {
                if (this.permits_ > 0) {
                    --this.permits_;
                    return true;
                }
                return false;
            }
        }

        abstract boolean attempt(long var1) throws InterruptedException;

        abstract void release(int var1);

        public synchronized int getPermits() {
            return this.permits_;
        }

        public synchronized int drain() {
            int n = this.permits_;
            this.permits_ = 0;
            return n;
        }

        public synchronized void reduce(int n) {
            this.permits_ -= n;
        }

        abstract boolean hasQueuedThreads();

        abstract int getQueueLength();

        abstract Collection getQueuedThreads();
    }
}

