/*
 * Decompiled with CFR 0.152.
 */
package net.sf.nachocalendar.components;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.util.Date;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.UIManager;
import net.sf.nachocalendar.components.CalendarUtils;
import net.sf.nachocalendar.components.DayRenderer;

public class DayPanel
extends JComponent {
    private Date date;
    private Color cselected;
    private Color cunselected;
    private Object data;
    JTable d;
    private boolean antiAliased;
    private DayRenderer renderer;
    private boolean working;
    private boolean componentEnabled;
    private boolean enabled;
    private boolean selected;
    private int index;

    public DayPanel(DayRenderer renderer, int index) {
        this.renderer = renderer;
        this.index = index;
        this.componentEnabled = true;
        this.setBorder(null);
        this.setOpaque(false);
        this.setLayout(new BorderLayout());
        this.date = new Date();
        this.cunselected = UIManager.getLookAndFeel().getDefaults().getColor("text");
        this.cselected = UIManager.getLookAndFeel().getDefaults().getColor("textHighlight");
        this.setFocusable(true);
    }

    public void setDate(Date d) {
        this.date = d;
        this.repaint();
    }

    public Date getDate() {
        return this.date;
    }

    public void setData(Object d) {
        this.data = d;
        this.repaint();
    }

    public Object getData() {
        return this.data;
    }

    public DayRenderer getRenderer() {
        return this.renderer;
    }

    public void setRenderer(DayRenderer renderer) {
        this.renderer = renderer;
    }

    public boolean isWorking() {
        return this.working;
    }

    public void setWorking(boolean working) {
        this.working = working;
    }

    public void paint(Graphics g) {
        Component comp = this.renderer.getDayRenderer(this, this.date, this.data, this.isSelected(), this.working, this.isEnabled() && this.isComponentEnabled());
        comp.setBounds(this.getBounds());
        Graphics2D g2 = (Graphics2D)g;
        if (this.isAntiAliased()) {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        comp.paint(g);
        if (this.isEnabled() && CalendarUtils.isToday(this.date)) {
            g.setColor(Color.red);
            g.drawOval(1, 1, this.getWidth() - 2, this.getHeight() - 2);
        }
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public boolean isComponentEnabled() {
        return this.componentEnabled;
    }

    public void setComponentEnabled(boolean componentEnabled) {
        this.componentEnabled = componentEnabled;
        super.setEnabled(this.enabled && componentEnabled);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        super.setEnabled(enabled && this.componentEnabled);
    }

    public boolean isAntiAliased() {
        return this.antiAliased;
    }

    public void setAntiAliased(boolean antiAliased) {
        this.antiAliased = antiAliased;
    }
}

