/*
 * Decompiled with CFR 0.152.
 */
package net.sf.nachocalendar.components;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.DateFormatter;
import net.sf.nachocalendar.components.ArrowButton;
import net.sf.nachocalendar.components.CalendarUtils;
import net.sf.nachocalendar.components.DatePanel;
import net.sf.nachocalendar.components.DayRenderer;
import net.sf.nachocalendar.components.HeaderRenderer;
import net.sf.nachocalendar.model.DataModel;

public class DateField
extends JPanel
implements ActionListener,
PropertyChangeListener {
    private WindowPanel windowpanel;
    private Date fecha;
    private DatePanel datepanel;
    private JFormattedTextField field;
    private JButton button;
    private Calendar calendar;
    private boolean showWeekNumbers;
    private DateFormatter formatter;
    private boolean antiAliased;
    private transient ArrayList changeListenerList;
    private boolean showOkCancel;
    private int firstDayOfWeek;
    private boolean[] workingDays;

    public DateField() {
        this(false);
    }

    public DateField(boolean showWeekNumbers) {
        this(new DateFormatter(DateFormat.getDateInstance(3)), showWeekNumbers);
    }

    public DateField(DateFormatter formatter, boolean showWeekNumbers) {
        this.formatter = formatter;
        this.showWeekNumbers = showWeekNumbers;
        this.init();
    }

    private void init() {
        this.calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        this.calendar.set(10, 0);
        this.calendar.set(12, 0);
        this.calendar.set(14, 0);
        this.datepanel = new DatePanel(this.showWeekNumbers);
        this.datepanel.setFirstDayOfWeek(this.firstDayOfWeek);
        this.datepanel.setWorkingDays(this.workingDays);
        this.datepanel.setSelectionMode(0);
        this.setLayout(new BorderLayout());
        this.field = new JFormattedTextField(this.formatter);
        this.add((Component)this.field, "Center");
        this.button = new ArrowButton(5);
        this.add((Component)this.button, "East");
        this.button.addActionListener(this);
        this.field.setValue(new Date());
        this.field.addPropertyChangeListener("value", this);
        Border border = this.field.getBorder();
        this.field.setBorder(null);
        this.setBorder(border);
    }

    private void aceptar() {
        this.windowpanel.setVisible(false);
        this.field.setValue(this.windowpanel.getDate());
    }

    private void cancelar() {
        this.windowpanel.setVisible(false);
    }

    private void createWindow() {
        Container c;
        Object d = null;
        for (c = this; !(c instanceof Dialog) && c != null; c = c.getParent()) {
        }
        if (c != null) {
            this.windowpanel = new WindowPanel((Dialog)c, this.showWeekNumbers);
            return;
        }
        Frame f = JOptionPane.getFrameForComponent(this);
        this.windowpanel = new WindowPanel(f, this.showWeekNumbers);
    }

    public void actionPerformed(ActionEvent e) {
        Date da;
        if (this.windowpanel == null) {
            this.createWindow();
        }
        if ((da = (Date)this.field.getValue()) == null) {
            da = this.calendar.getTime();
        }
        this.windowpanel.setDate(da);
        Point p = this.getLocationOnScreen();
        p.y += this.getHeight();
        this.windowpanel.setLocation(p);
        this.windowpanel.setVisible(true);
    }

    public void setValue(Object value) {
        try {
            Date d = CalendarUtils.convertToDate(value);
            this.field.setValue(d);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    public Object getValue() {
        return this.field.getValue();
    }

    public synchronized void addChangeListener(ChangeListener listener) {
        if (this.changeListenerList == null) {
            this.changeListenerList = new ArrayList();
        }
        this.changeListenerList.add(listener);
    }

    public synchronized void removeChangeListener(ChangeListener listener) {
        if (this.changeListenerList != null) {
            this.changeListenerList.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChangeListenerStateChanged(ChangeEvent event) {
        ArrayList list;
        DateField dateField = this;
        synchronized (dateField) {
            if (this.changeListenerList == null) {
                return;
            }
            list = (ArrayList)this.changeListenerList.clone();
        }
        for (int i = 0; i < list.size(); ++i) {
            ((ChangeListener)list.get(i)).stateChanged(event);
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this.fireChangeListenerStateChanged(new ChangeEvent(this));
    }

    public DayRenderer getRenderer() {
        return this.datepanel.getRenderer();
    }

    public void setRenderer(DayRenderer renderer) {
        this.datepanel.setRenderer(renderer);
    }

    public DataModel getModel() {
        return this.datepanel.getModel();
    }

    public void setModel(DataModel model) {
        this.datepanel.setModel(model);
    }

    public HeaderRenderer getHeaderRenderer() {
        return this.datepanel.getHeaderRenderer();
    }

    public void setHeaderRenderer(HeaderRenderer headerRenderer) {
        this.datepanel.setHeaderRenderer(headerRenderer);
    }

    public boolean getShowOkCancel() {
        return this.showOkCancel;
    }

    public void setShowOkCancel(boolean showOkCancel) {
        if (this.showOkCancel == showOkCancel) {
            return;
        }
        boolean old = this.showOkCancel;
        this.showOkCancel = showOkCancel;
        this.windowpanel = null;
        this.firePropertyChange("showOkCancel", old, showOkCancel);
    }

    public boolean getAllowsInvalid() {
        return this.formatter.getAllowsInvalid();
    }

    public void setAllowsInvalid(boolean b) {
        boolean old = this.formatter.getAllowsInvalid();
        this.formatter.setAllowsInvalid(b);
        this.firePropertyChange("allowsInvalid", old, b);
    }

    public int getFirstDayOfWeek() {
        return this.firstDayOfWeek;
    }

    public void setFirstDayOfWeek(int firstDayOfWeek) {
        if (firstDayOfWeek == 2 || firstDayOfWeek == 1) {
            int old = this.firstDayOfWeek;
            if (this.datepanel != null) {
                this.datepanel.setFirstDayOfWeek(firstDayOfWeek);
            }
            this.firstDayOfWeek = firstDayOfWeek;
            this.firePropertyChange("firstDayOfWeek", old, firstDayOfWeek);
        }
    }

    public boolean[] getWorkingDays() {
        return this.workingDays;
    }

    public void setWorkingDays(boolean[] workingDays) {
        boolean[] old = this.workingDays;
        if (this.datepanel != null) {
            this.datepanel.setWorkingDays(workingDays);
        }
        this.workingDays = workingDays;
        this.firePropertyChange("workingDays", old, workingDays);
    }

    public void setEnabled(boolean enabled) {
        this.button.setEnabled(enabled);
        this.field.setEnabled(enabled);
        super.setEnabled(enabled);
    }

    public boolean isEnabled() {
        return this.button.isEnabled();
    }

    public JFormattedTextField getFormattedTextField() {
        return this.field;
    }

    public boolean isAntiAliased() {
        return this.antiAliased;
    }

    public void setAntiAliased(boolean antiAliased) {
        boolean old = this.antiAliased;
        this.antiAliased = antiAliased;
        this.datepanel.setAntiAliased(antiAliased);
        this.firePropertyChange("antiAliased", old, antiAliased);
    }

    static /* synthetic */ void access$300(DateField x0) {
        x0.aceptar();
    }

    static /* synthetic */ void access$400(DateField x0) {
        x0.cancelar();
    }

    class WindowPanel
    extends JDialog {
        public WindowPanel(Frame parent, boolean showWeekNumbers) {
            super(parent, false);
            this.init(showWeekNumbers);
        }

        public WindowPanel(Dialog parent, boolean showWeekNumbers) {
            super(parent, false);
            this.init(showWeekNumbers);
        }

        private void init(boolean showWeekNumbers) {
            this.setUndecorated(true);
            this.setFocusable(true);
            JPanel todo = new JPanel(new BorderLayout());
            this.getContentPane().add(todo);
            todo.add(DateField.this.datepanel);
            todo.setBorder(BorderFactory.createLineBorder(Color.black));
            if (DateField.this.showOkCancel) {
                JPanel abajo = new JPanel();
                todo.add((Component)abajo, "South");
                JButton ok = new JButton("Ok");
                JButton cancel = new JButton("Cancel");
                abajo.add(ok);
                abajo.add(cancel);
                this.getRootPane().setDefaultButton(ok);
                ok.addActionListener(new ActionListener(this){
                    private final /* synthetic */ WindowPanel this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void actionPerformed(ActionEvent e) {
                        DateField.access$300(WindowPanel.access$200(this.this$1));
                    }
                });
                cancel.addActionListener(new ActionListener(this){
                    private final /* synthetic */ WindowPanel this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void actionPerformed(ActionEvent e) {
                        DateField.access$400(WindowPanel.access$200(this.this$1));
                    }
                });
            } else {
                DateField.this.datepanel.addActionListener(new ActionListener(this){
                    private final /* synthetic */ WindowPanel this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void actionPerformed(ActionEvent e) {
                        DateField.access$300(WindowPanel.access$200(this.this$1));
                    }
                });
            }
            KeyAdapter klistener = new KeyAdapter(this){
                private final /* synthetic */ WindowPanel this$1;
                {
                    this.this$1 = this$1;
                }

                public void keyTyped(KeyEvent e) {
                    if (e.getKeyChar() == '\n') {
                        DateField.access$300(WindowPanel.access$200(this.this$1));
                    }
                    if (e.getKeyChar() == '\u001b') {
                        DateField.access$400(WindowPanel.access$200(this.this$1));
                    }
                }
            };
            DateField.this.datepanel.addKeyListener(klistener);
            this.addKeyListener(klistener);
            this.addWindowListener(new WindowAdapter(this){
                private final /* synthetic */ WindowPanel this$1;
                {
                    this.this$1 = this$1;
                }

                public void windowDeactivated(WindowEvent e) {
                    DateField.access$400(WindowPanel.access$200(this.this$1));
                }
            });
            this.pack();
        }

        public Date getDate() {
            return DateField.this.datepanel.getDate();
        }

        public void setDate(Date d) {
            DateField.this.datepanel.setDate(d);
        }

        static /* synthetic */ DateField access$200(WindowPanel x0) {
            return x0.DateField.this;
        }
    }
}

