/*
 * Decompiled with CFR 0.152.
 */
package net.sf.nachocalendar.components;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public final class CalendarUtils {
    private static DateFormat dateformat = DateFormat.getDateInstance();
    private static Calendar calendar1;
    private static Calendar calendar2;

    private CalendarUtils() {
    }

    public static Date convertToDate(Object o) throws ParseException {
        if (o == null) {
            return null;
        }
        if (o instanceof Date) {
            return (Date)o;
        }
        if (o instanceof java.sql.Date) {
            return new Date(((java.sql.Date)o).getTime());
        }
        return dateformat.parse(o.toString());
    }

    private static synchronized boolean isSameDay() {
        if (calendar1.get(6) != calendar2.get(6)) {
            return false;
        }
        return calendar1.get(1) == calendar2.get(1);
    }

    public static synchronized boolean isSameDay(Date d1, Date d2) {
        calendar1.setTime(d1);
        calendar2.setTime(d2);
        return CalendarUtils.isSameDay();
    }

    public static synchronized boolean isToday(Date date) {
        calendar1.setTimeInMillis(System.currentTimeMillis());
        calendar2.setTime(date);
        return CalendarUtils.isSameDay();
    }

    static {
        dateformat.setTimeZone(TimeZone.getTimeZone("GMT"));
        calendar1 = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        calendar2 = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
    }
}

