/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.vectorgraphics2d;

import de.erichseifert.vectorgraphics2d.VectorGraphics2D;
import de.erichseifert.vectorgraphics2d.util.DataUtils;
import de.erichseifert.vectorgraphics2d.util.GraphicsUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Map;

public class EPSGraphics2D
extends VectorGraphics2D {
    protected static final double MM_IN_UNITS = 2.834645669291339;
    private static final Map<Integer, Integer> STROKE_ENDCAPS = DataUtils.map(new Integer[]{0, 1, 2}, new Integer[]{0, 1, 2});
    private static final Map<Integer, Integer> STROKE_LINEJOIN = DataUtils.map(new Integer[]{0, 1, 2}, new Integer[]{0, 1, 2});

    public EPSGraphics2D(double x, double y, double width, double height) {
        super(x, y, width, height);
        this.writeHeader();
    }

    protected void writeString(String str, double x, double y) {
        str = str.replaceAll("\\\\", "\\\\\\\\").replaceAll("\t", "\\\\t").replaceAll("\b", "\\\\b").replaceAll("\f", "\\\\f").replaceAll("\\(", "\\\\(").replaceAll("\\)", "\\\\)");
        this.write("gsave 1 -1 scale ");
        str = str.replaceAll("[\r\n]", "");
        this.write(x, " -", y, " M (", str, ") show ");
        this.writeln("grestore");
    }

    public void setStroke(Stroke s) {
        BasicStroke bsPrev = this.getStroke() instanceof BasicStroke ? (BasicStroke)this.getStroke() : new BasicStroke();
        super.setStroke(s);
        if (s instanceof BasicStroke) {
            BasicStroke bs = (BasicStroke)s;
            if (bs.getLineWidth() != bsPrev.getLineWidth()) {
                this.writeln(Float.valueOf(bs.getLineWidth()), " setlinewidth");
            }
            if (bs.getLineJoin() != bsPrev.getLineJoin()) {
                this.writeln(STROKE_LINEJOIN.get(bs.getLineJoin()), " setlinejoin");
            }
            if (bs.getEndCap() != bsPrev.getEndCap()) {
                this.writeln(STROKE_ENDCAPS.get(bs.getEndCap()), " setlinecap");
            }
            if (!Arrays.equals(bs.getDashArray(), bsPrev.getDashArray()) || bs.getDashPhase() != bsPrev.getDashPhase()) {
                this.writeln("[", DataUtils.join(" ", bs.getDashArray()), "] ", Float.valueOf(bs.getDashPhase()), " setdash");
            }
        }
    }

    protected void writeImage(Image img, int imgWidth, int imgHeight, double x, double y, double width, double height) {
        BufferedImage bufferedImg = GraphicsUtils.toBufferedImage(img);
        String imgData = EPSGraphics2D.getEps(bufferedImg);
        int bands = bufferedImg.getSampleModel().getNumBands();
        int bitsPerSample = DataUtils.max(bufferedImg.getSampleModel().getSampleSize());
        bitsPerSample = (int)(Math.ceil((double)bitsPerSample / 8.0) * 8.0);
        if (bands > 3) {
            bands = 3;
        }
        this.writeln("gsave");
        this.writeln(x, " ", y, " ", width, " ", height, " ", imgWidth, " ", imgHeight, " ", bitsPerSample, " img false ", bands, " colorimage");
        this.writeln(imgData, ">");
        this.writeln("grestore");
    }

    public void setColor(Color c) {
        Color color = this.getColor();
        if (c != null) {
            super.setColor(c);
            if (color.getRed() != c.getRed() || color.getGreen() != c.getGreen() || color.getBlue() != c.getBlue()) {
                double r = (double)c.getRed() / 255.0;
                double g = (double)c.getGreen() / 255.0;
                double b = (double)c.getBlue() / 255.0;
                this.writeln(r, " ", g, " ", b, " rgb");
            }
        }
    }

    public void setFont(Font font) {
        if (!this.getFont().equals(font)) {
            super.setFont(font);
            this.writeln("/", font.getPSName(), " ", Float.valueOf(font.getSize2D()), " selectfont");
        }
    }

    public void setClip(Shape clip) {
        if (this.getClip() != null) {
            this.writeln("cliprestore");
        }
        super.setClip(clip);
        if (this.getClip() != null) {
            this.writeShape(this.getClip());
            this.writeln(" clip");
        }
    }

    public void setTransform(AffineTransform tx) {
        if (this.getTransform().equals(tx)) {
            return;
        }
        super.setTransform(tx);
        double[] matrix = new double[6];
        this.getTransform().getMatrix(matrix);
        this.writeln("basematrix setmatrix [", DataUtils.join(" ", matrix), "] concat");
    }

    public void translate(double tx, double ty) {
        super.translate(tx, ty);
        if (tx != 0.0 || ty != 0.0) {
            this.writeln(tx, " ", ty, " translate");
        }
    }

    public void scale(double sx, double sy) {
        super.scale(sx, sy);
        if (sx != 1.0 || sy != 1.0) {
            this.writeln(sx, " ", sy, " scale");
        }
    }

    public void rotate(double theta) {
        super.rotate(theta);
        if (theta != 0.0) {
            this.writeln(theta / Math.PI * 180.0, " rotate");
        }
    }

    public void rotate(double theta, double x, double y) {
        super.rotate(theta, x, y);
        if (theta != 0.0) {
            this.writeln(x, " ", y, " translate ", theta / Math.PI * 180.0, " rotate ", -x, " ", -y, " translate");
        }
    }

    public void shear(double sx, double sy) {
        super.shear(sx, sy);
        if (sx != 0.0 || sy != 0.0) {
            this.setTransform(this.getTransform());
        }
    }

    protected void writeHeader() {
        Rectangle2D bounds = this.getBounds();
        double x = bounds.getX() * 2.834645669291339;
        double y = bounds.getY() * 2.834645669291339;
        double w = bounds.getWidth() * 2.834645669291339;
        double h = bounds.getHeight() * 2.834645669291339;
        this.writeln("%!PS-Adobe-3.0 EPSF-3.0");
        this.writeln("%%BoundingBox: ", (int)Math.floor(x), " ", (int)Math.floor(y), " ", (int)Math.ceil(x + w), " ", (int)Math.ceil(y + h));
        this.writeln("%%HiResBoundingBox: ", x, " ", y, " ", x + w, " ", y + h);
        this.writeln("%%LanguageLevel: 3");
        this.writeln("%%Pages: 1");
        this.writeln("%%Page: 1 1");
        this.writeln("/M /moveto load def");
        this.writeln("/L /lineto load def");
        this.writeln("/C /curveto load def");
        this.writeln("/Z /closepath load def");
        this.writeln("/RL /rlineto load def");
        this.writeln("/rgb /setrgbcolor load def");
        this.writeln("/rect { ", "/height exch def /width exch def /y exch def /x exch def ", "x y M width 0 RL 0 height RL width neg 0 RL ", "} bind def");
        this.writeln("/ellipse { ", "/endangle exch def /startangle exch def ", "/ry exch def /rx exch def /y exch def /x exch def ", "/savematrix matrix currentmatrix def ", "x y translate rx ry scale 0 0 1 startangle endangle arcn ", "savematrix setmatrix ", "} bind def");
        this.writeln("/img { ", "/bits exch def /imgheight exch def /imgwidth exch def ", "/height exch def /width exch def /y exch def /x exch def ", "x y translate width height scale ", "imgwidth imgheight bits [imgwidth 0 0 imgheight 0 0] currentfile ", "/ASCIIHexDecode filter ", "} bind def");
        this.writeln("/", this.getFont().getPSName(), " ", Float.valueOf(this.getFont().getSize2D()), " selectfont");
        this.writeln("gsave");
        this.writeln("clipsave");
        this.writeln("/DeviceRGB setcolorspace");
        this.writeln("0 ", h, " translate");
        this.writeln(2.834645669291339, " -", 2.834645669291339, " scale");
        this.writeln("/basematrix matrix currentmatrix def");
    }

    protected void writeClosingDraw(Shape s) {
        this.writeln(" stroke");
    }

    protected void writeClosingFill(Shape s) {
        this.writeln(" fill");
        if (!(this.getPaint() instanceof Color)) {
            super.writeClosingFill(s);
        }
    }

    protected void writeShape(Shape s) {
        this.write("newpath ");
        if (s instanceof Line2D) {
            Line2D l = (Line2D)s;
            double x1 = l.getX1();
            double y1 = l.getY1();
            double x2 = l.getX2();
            double y2 = l.getY2();
            this.write(x1, " ", y1, " M ", x2, " ", y2, " L");
            return;
        }
        if (s instanceof Rectangle2D) {
            Rectangle2D r = (Rectangle2D)s;
            double x = r.getX();
            double y = r.getY();
            double width = r.getWidth();
            double height = r.getHeight();
            this.write(x, " ", y, " ", width, " ", height, " rect Z");
            return;
        }
        if (s instanceof Ellipse2D) {
            Ellipse2D e = (Ellipse2D)s;
            double x = e.getX() + e.getWidth() / 2.0;
            double y = e.getY() + e.getHeight() / 2.0;
            double rx = e.getWidth() / 2.0;
            double ry = e.getHeight() / 2.0;
            this.write(x, " ", y, " ", rx, " ", ry, " ", 360.0, " ", 0.0, " ellipse Z");
            return;
        }
        if (s instanceof Arc2D) {
            Arc2D e = (Arc2D)s;
            double x = e.getX() + e.getWidth() / 2.0;
            double y = e.getY() + e.getHeight() / 2.0;
            double rx = e.getWidth() / 2.0;
            double ry = e.getHeight() / 2.0;
            double startAngle = -e.getAngleStart();
            double endAngle = -(e.getAngleStart() + e.getAngleExtent());
            this.write(x, " ", y, " ", rx, " ", ry, " ", startAngle, " ", endAngle, " ellipse");
            if (e.getArcType() == 1) {
                this.write(" Z");
            } else if (e.getArcType() == 2) {
                this.write(" ", x, " ", y, " L Z");
            }
            return;
        }
        PathIterator segments = s.getPathIterator(null);
        double[] coordsCur = new double[6];
        double[] pointPrev = new double[2];
        int i = 0;
        while (!segments.isDone()) {
            if (i > 0) {
                this.write(" ");
            }
            int segmentType = segments.currentSegment(coordsCur);
            switch (segmentType) {
                case 0: {
                    this.write(coordsCur[0], " ", coordsCur[1], " M");
                    pointPrev[0] = coordsCur[0];
                    pointPrev[1] = coordsCur[1];
                    break;
                }
                case 1: {
                    this.write(coordsCur[0], " ", coordsCur[1], " L");
                    pointPrev[0] = coordsCur[0];
                    pointPrev[1] = coordsCur[1];
                    break;
                }
                case 3: {
                    this.write(coordsCur[0], " ", coordsCur[1], " ", coordsCur[2], " ", coordsCur[3], " ", coordsCur[4], " ", coordsCur[5], " C");
                    pointPrev[0] = coordsCur[4];
                    pointPrev[1] = coordsCur[5];
                    break;
                }
                case 2: {
                    double x1 = pointPrev[0] + 0.6666666666666666 * (coordsCur[0] - pointPrev[0]);
                    double y1 = pointPrev[1] + 0.6666666666666666 * (coordsCur[1] - pointPrev[1]);
                    double x2 = coordsCur[0] + 0.3333333333333333 * (coordsCur[2] - coordsCur[0]);
                    double y2 = coordsCur[1] + 0.3333333333333333 * (coordsCur[3] - coordsCur[1]);
                    double x3 = coordsCur[2];
                    double y3 = coordsCur[3];
                    this.write(x1, " ", y1, " ", x2, " ", y2, " ", x3, " ", y3, " C");
                    pointPrev[0] = x3;
                    pointPrev[1] = y3;
                    break;
                }
                case 4: {
                    this.write("Z");
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown path operation.");
                }
            }
            ++i;
            segments.next();
        }
    }

    private static String getEps(BufferedImage bufferedImg) {
        int width = bufferedImg.getWidth();
        int height = bufferedImg.getHeight();
        int bands = bufferedImg.getSampleModel().getNumBands();
        StringBuffer str = new StringBuffer(width * height * bands * 2);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int pixel = bufferedImg.getRGB(x, y) & 0xFFFFFF;
                if (bands >= 3) {
                    String hex = String.format("%06x", pixel);
                    str.append(hex);
                    continue;
                }
                if (bands != 1) continue;
                str.append(String.format("%02x", pixel));
            }
            str.append("\n");
        }
        return str.toString();
    }

    protected String getFooter() {
        return "grestore  % Restore state\n%%EOF\n";
    }

    public byte[] getBytes() {
        try {
            return this.toString().getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            return super.getBytes();
        }
    }
}

