/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.web.jsonapi;

import edu.iris.Fissures.IfEvent.NoPreferredOrigin;
import edu.iris.Fissures.event.OriginImpl;
import edu.sc.seis.sod.hibernate.StatefulEvent;
import edu.sc.seis.sod.web.jsonapi.AbstractJsonApiData;
import edu.sc.seis.sod.web.jsonapi.JsonApiData;
import edu.sc.seis.sod.web.jsonapi.MagnitudeJson;
import edu.sc.seis.sod.web.jsonapi.OriginJson;
import java.util.List;
import org.json.JSONException;
import org.json.JSONWriter;

public class EventJson
extends AbstractJsonApiData {
    StatefulEvent event;

    public EventJson(StatefulEvent event, String baseUrl) {
        super(baseUrl);
        this.event = event;
    }

    @Override
    public String getType() {
        return "quake";
    }

    @Override
    public String getId() {
        return "" + this.event.getDbid();
    }

    @Override
    public void encodeAttributes(JSONWriter out) throws JSONException {
        out.key("name").value((Object)this.event.get_attributes().name).key("sod-status").value((Object)this.event.getStatus().toString());
    }

    @Override
    public boolean hasRelationships() {
        return true;
    }

    @Override
    public void encodeRelationships(JSONWriter out) throws JSONException {
        try {
            OriginImpl pref = this.event.getPreferred();
            out.key("pref-origin").object();
            out.key("data").object().key("id").value((Object)("" + this.event.getPreferred().getDbid())).key("type").value((Object)"origin").endObject();
            out.endObject();
            out.key("pref-magnitude").object();
            out.key("data").object().key("id").value((Object)EventJson.createMagId(this.event.getPreferred(), 0)).key("type").value((Object)"magnitude").endObject();
            out.endObject();
            out.key("esps").object().key("links").object().key("related").value((Object)this.formStationRelationshipURL());
            out.endObject();
            out.endObject();
        }
        catch (NoPreferredOrigin e) {
            throw new RuntimeException("no pref origin???", e);
        }
    }

    @Override
    public boolean hasLinks() {
        return false;
    }

    @Override
    public void encodeLinks(JSONWriter out) throws JSONException {
    }

    @Override
    public List<JsonApiData> included() {
        List<JsonApiData> out = super.included();
        try {
            out.add(new OriginJson(this.event.getPreferred(), this.getBaseUrl()));
            out.add(new MagnitudeJson(this.event.getPreferred().getMagnitudes()[0], EventJson.createMagId(this.event.getPreferred(), 0), this.getBaseUrl()));
        }
        catch (NoPreferredOrigin e) {
            throw new RuntimeException(e);
        }
        return out;
    }

    public static String createMagId(OriginImpl o, int magIndex) {
        return o.getDbid() + "m" + magIndex;
    }

    public String formStationRelationshipURL() {
        String out = this.baseUrl + "/quakes/" + this.getId() + "/stations";
        return out;
    }
}

