/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.web.jsonapi;

import edu.iris.Fissures.model.QuantityImpl;
import edu.iris.Fissures.model.SamplingImpl;
import edu.iris.Fissures.model.UnitImpl;
import edu.iris.Fissures.network.ChannelImpl;
import edu.sc.seis.sod.web.jsonapi.AbstractJsonApiData;
import edu.sc.seis.sod.web.jsonapi.StationJson;
import org.json.JSONException;
import org.json.JSONWriter;

public class ChannelJson
extends AbstractJsonApiData {
    ChannelImpl chan;

    public ChannelJson(ChannelImpl chan, String baseUrl) {
        super(baseUrl);
        this.chan = chan;
    }

    @Override
    public String getType() {
        return "channel";
    }

    @Override
    public String getId() {
        return "" + this.chan.getDbid();
    }

    @Override
    public void encodeAttributes(JSONWriter out) throws JSONException {
        out.key("site-code").value((Object)this.chan.getSite().get_code()).key("channel-code").value((Object)this.chan.get_code()).key("station").value((long)this.chan.getStationImpl().getDbid()).key("sps").value(((SamplingImpl)this.chan.getSamplingInfo()).getFrequency().getValue(UnitImpl.HERTZ)).key("latitude").value((double)this.chan.getSite().getLocation().latitude).key("longitude").value((double)this.chan.getSite().getLocation().longitude).key("elevation").value(((QuantityImpl)this.chan.getSite().getLocation().elevation).getValue(UnitImpl.METER)).key("depth").value(((QuantityImpl)this.chan.getSite().getLocation().depth).getValue(UnitImpl.METER));
    }

    @Override
    public boolean hasRelationships() {
        return true;
    }

    @Override
    public void encodeRelationships(JSONWriter out) throws JSONException {
        StationJson staJson = new StationJson(this.chan.getStationImpl(), this.getBaseUrl());
        out.key("station").object();
        out.key("id").value((Object)staJson.getId());
        out.key("type").value((Object)staJson.getType());
        out.endObject();
    }

    @Override
    public boolean hasLinks() {
        return false;
    }

    @Override
    public void encodeLinks(JSONWriter out) throws JSONException {
    }
}

