/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.web;

import edu.sc.seis.sod.Arm;
import edu.sc.seis.sod.ArmListener;
import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.Start;
import edu.sc.seis.sod.web.ArmStatusServlet;
import edu.sc.seis.sod.web.ChannelServlet;
import edu.sc.seis.sod.web.EventServlet;
import edu.sc.seis.sod.web.EventStationServlet;
import edu.sc.seis.sod.web.EventVectorServlet;
import edu.sc.seis.sod.web.NetworkServlet;
import edu.sc.seis.sod.web.StationsServlet;
import edu.sc.seis.sod.web.TauPServlet;
import edu.sc.seis.sod.web.WaveformServlet;
import java.io.File;
import java.io.IOException;
import java.net.BindException;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.util.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebAdmin
implements ArmListener {
    Thread keepAliveThread;
    Server server;
    private static final Logger logger = LoggerFactory.getLogger(WebAdmin.class);

    public void start() throws Exception {
        int initialPort;
        ResourceHandler resource_handler = new ResourceHandler();
        resource_handler.setDirectoriesListed(true);
        resource_handler.setWelcomeFiles(new String[]{"index.html"});
        resource_handler.setBaseResource(Resource.newResource((File)new File("site")));
        ContextHandler siteContext = new ContextHandler("/");
        siteContext.setHandler((Handler)resource_handler);
        ServletHandler servlets = new ServletHandler();
        servlets.setEnsureDefaultServlet(false);
        servlets.addServletWithMapping(ArmStatusServlet.class, "/api/arms");
        this.addServlets(servlets, EventServlet.class, "quakes");
        this.addServlets(servlets, NetworkServlet.class, "networks");
        this.addServlets(servlets, StationsServlet.class, "stations");
        this.addServlets(servlets, ChannelServlet.class, "channels");
        this.addServlets(servlets, EventStationServlet.class, "quake-stations");
        this.addServlets(servlets, EventVectorServlet.class, "quake-vectors");
        this.addServlets(servlets, WaveformServlet.class, "waveform");
        this.addServlets(servlets, WaveformServlet.class, "waveforms");
        this.addServlets(servlets, TauPServlet.class, "taup");
        HandlerList handlers = new HandlerList();
        handlers.setHandlers(new Handler[]{siteContext, servlets, new DefaultHandler(){

            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                System.out.println("missed get: " + request.getRequestURL());
                super.handle(target, baseRequest, request, response);
            }
        }, new DefaultHandler()});
        int port = initialPort = 8080;
        int maxPortTries = 10;
        while (this.server == null) {
            try {
                this.server = new Server(port);
                this.server.setHandler((Handler)handlers);
                this.server.start();
            }
            catch (BindException e) {
                if (port - initialPort < maxPortTries) {
                    logger.info("port " + port + " in use, trying next in line.", (Object)e.getMessage());
                    ++port;
                    continue;
                }
                throw e;
            }
        }
        final Server serverInContext = this.server;
        logger.info("Web Admin started at " + this.server.getURI());
        System.out.println("Web Admin started at " + this.server.getURI());
        if (Start.getArgs().isStatus() || Start.getRunProps().isStatusWebKeepAlive()) {
            this.keepAliveThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        System.err.println("Before join jetty");
                        serverInContext.join();
                        System.err.println("After join, guess jetty quit");
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }, "JettyKeepAlive");
            this.keepAliveThread.start();
        }
    }

    void addServlets(ServletHandler servlets, Class<? extends Servlet> servletClass, String partialUrl) {
        servlets.addServletWithMapping(servletClass, "/api/" + partialUrl);
        servlets.addServletWithMapping(servletClass, "/api/" + partialUrl + "/");
        servlets.addServletWithMapping(servletClass, "/api/" + partialUrl + "/*");
    }

    @Override
    public void finished(Arm arm) {
        this.checkIfStayAlive();
    }

    @Override
    public void starting(Arm arm) throws ConfigurationException {
    }

    @Override
    public void started() throws ConfigurationException {
        this.checkIfStayAlive();
    }

    void checkIfStayAlive() {
        System.err.println("check if stay alive");
        if (!Start.isAnyWaveformArmActive()) {
            if (Start.getRunProps().isStatusWebKeepAlive()) {
                System.err.println("--status to keep SOD alive true, so control-c to quit SOD.");
            } else {
                try {
                    System.err.println("All finished, stopping web admin");
                    this.server.stop();
                }
                catch (Exception e) {
                    logger.error("Unable to stop jetty web server", (Throwable)e);
                }
            }
        }
    }

    public void join() throws InterruptedException {
        System.err.println("Before Join");
        this.server.join();
        System.err.println("After Join");
    }

    public static String getBaseUrl() {
        return "/api";
    }
}

