/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.web;

import edu.iris.Fissures.network.ChannelImpl;
import edu.sc.seis.fissuresUtil.cache.CacheEvent;
import edu.sc.seis.fissuresUtil.hibernate.AbstractHibernateDB;
import edu.sc.seis.fissuresUtil.hibernate.EventSeismogramFileReference;
import edu.sc.seis.fissuresUtil.hibernate.SeismogramFileRefDB;
import edu.sc.seis.fissuresUtil.xml.SeismogramFileTypes;
import edu.sc.seis.fissuresUtil.xml.UnsupportedFileTypeException;
import edu.sc.seis.sod.AbstractEventChannelPair;
import edu.sc.seis.sod.EventChannelPair;
import edu.sc.seis.sod.EventVectorPair;
import edu.sc.seis.sod.hibernate.SodDB;
import edu.sc.seis.sod.web.jsonapi.JsonApi;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.hibernate.Query;
import org.json.JSONWriter;

public class WaveformServlet
extends HttpServlet {
    Pattern mseedPattern = Pattern.compile(".*/waveforms?/([0-9]+)");

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String URL2 = req.getRequestURL().toString();
        System.out.println("GET: " + URL2);
        Matcher m = this.mseedPattern.matcher(URL2);
        if (m.matches()) {
            AbstractEventChannelPair ecp = this.getECP(m.group(1));
            ChannelImpl[] chans = ecp instanceof EventVectorPair ? ((EventVectorPair)ecp).getChannelGroup().getChannels() : new ChannelImpl[]{((EventChannelPair)ecp).getChannel()};
            ArrayList seisRefList = new ArrayList();
            for (int j = 0; j < chans.length; ++j) {
                seisRefList.addAll(SeismogramFileRefDB.getSingleton().getSeismogramsForEventForChannel((CacheEvent)ecp.getEvent(), chans[j].getId()));
            }
            resp.setContentType("application/vnd.fdsn.mseed");
            ServletOutputStream outBinary = resp.getOutputStream();
            System.out.println("SeisFileRef size: " + seisRefList.size());
            for (EventSeismogramFileReference ref : seisRefList) {
                System.out.println("FileRef: " + ref.getFilePath());
                try {
                    if (SeismogramFileTypes.fromInt((int)ref.getFileType()).equals((Object)SeismogramFileTypes.MSEED)) {
                        BufferedInputStream bufIn = new BufferedInputStream(ref.getFilePathAsURL().openStream());
                        byte[] buf = new byte[1024];
                        int bufNum = 0;
                        while ((bufNum = bufIn.read(buf)) != -1) {
                            outBinary.write(buf, 0, bufNum);
                        }
                        bufIn.close();
                        continue;
                    }
                    System.err.println("Not miniseed: " + ref.getFileType());
                }
                catch (UnsupportedFileTypeException e) {
                    throw new RuntimeException("Should never happen", e);
                }
            }
            outBinary.flush();
        } else {
            PrintWriter writer = resp.getWriter();
            JSONWriter out = new JSONWriter((Writer)writer);
            JsonApi.encodeError(out, "url does not match " + this.mseedPattern.pattern());
            writer.close();
        }
        AbstractHibernateDB.rollback();
    }

    AbstractEventChannelPair getECP(String dbid) {
        Query q = AbstractHibernateDB.getSession().createQuery("from " + SodDB.getSingleton().getEcpClass().getName() + " where dbid = " + dbid);
        AbstractEventChannelPair esp = (AbstractEventChannelPair)q.uniqueResult();
        return esp;
    }
}

