/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.web;

import edu.iris.Fissures.network.ChannelImpl;
import edu.sc.seis.fissuresUtil.database.NotFound;
import edu.sc.seis.fissuresUtil.hibernate.NetworkDB;
import edu.sc.seis.sod.web.WebAdmin;
import edu.sc.seis.sod.web.jsonapi.ChannelJson;
import edu.sc.seis.sod.web.jsonapi.JsonApi;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONWriter;

public class ChannelServlet
extends HttpServlet {
    Pattern channelDbidPattern = Pattern.compile(".*/channels/([0-9]+)");

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String URL2 = req.getRequestURL().toString();
        System.out.println("GET: " + URL2);
        if (req.getHeader("accept") != null && req.getHeader("accept").contains("application/vnd.api+json")) {
            resp.setContentType("application/vnd.api+json");
            System.out.println("      contentType: application/vnd.api+json");
        } else {
            resp.setContentType("application/json");
            System.out.println("      contentType: application/json");
        }
        PrintWriter writer = resp.getWriter();
        JSONWriter out = new JSONWriter((Writer)writer);
        NetworkDB netdb = NetworkDB.getSingleton();
        Matcher matcher = this.channelDbidPattern.matcher(URL2);
        if (matcher.matches()) {
            String dbid = matcher.group(1);
            ChannelImpl chan = null;
            try {
                chan = netdb.getChannel(Integer.parseInt(dbid));
                if (chan != null) {
                    JsonApi.encodeJson(out, new ChannelJson(chan, WebAdmin.getBaseUrl()));
                    resp.setStatus(200);
                } else {
                    JsonApi.encodeError(out, "Channel is null for dbid " + dbid);
                }
            }
            catch (NumberFormatException e) {
                JsonApi.encodeError(out, "NumberFormatException " + e.getMessage());
            }
            catch (NotFound e) {
                JsonApi.encodeError(out, "NotFound " + e.getMessage());
            }
            writer.close();
        } else {
            JsonApi.encodeError(out, "bad url for servlet: regex=" + this.channelDbidPattern.toString());
            writer.close();
            resp.sendError(500);
        }
        NetworkDB.rollback();
    }
}

