/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.web;

import edu.sc.seis.sod.SodConfig;
import edu.sc.seis.sod.Start;
import edu.sc.seis.sod.WaveformArm;
import edu.sc.seis.sod.hibernate.SodDB;
import edu.sc.seis.sod.web.WebAdmin;
import edu.sc.seis.sod.web.jsonapi.ArmStatusJson;
import edu.sc.seis.sod.web.jsonapi.JsonApi;
import edu.sc.seis.sod.web.jsonapi.JsonApiData;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONWriter;

public class ArmStatusServlet
extends HttpServlet {
    Pattern armsPattern = Pattern.compile(".*/arms");
    Pattern recipePattern = Pattern.compile(".*/arms/([^/]+)/recipe");

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String URL2 = req.getRequestURL().toString();
        System.out.println("GET: " + URL2);
        if (req.getHeader("accept") != null && req.getHeader("accept").contains("application/vnd.api+json")) {
            resp.setContentType("application/vnd.api+json");
            System.out.println("      contentType: application/vnd.api+json");
        } else {
            resp.setContentType("application/json");
            System.out.println("      contentType: application/json");
        }
        PrintWriter writer = resp.getWriter();
        JSONWriter out = new JSONWriter((Writer)writer);
        Matcher matcher = this.armsPattern.matcher(URL2);
        if (matcher.matches()) {
            ArrayList<JsonApiData> json = new ArrayList<JsonApiData>();
            json.add(new ArmStatusJson(Start.getNetworkArm(), WebAdmin.getBaseUrl()));
            json.add(new ArmStatusJson(Start.getEventArm(), WebAdmin.getBaseUrl()));
            WaveformArm[] waveformArms = Start.getWaveformArms();
            for (int i = 0; i < waveformArms.length; ++i) {
                json.add(new ArmStatusJson(waveformArms[i], WebAdmin.getBaseUrl()));
            }
            JsonApi.encodeJson(out, json);
        } else {
            matcher = this.recipePattern.matcher(URL2);
            if (matcher.matches()) {
                SodConfig config = SodDB.getSingleton().getCurrentConfig();
                String string = config.getConfig();
            }
        }
        writer.close();
        resp.setStatus(200);
    }
}

