/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.velocity.network;

import edu.iris.Fissures.IfNetwork.NetworkAttr;
import edu.iris.Fissures.IfNetwork.NetworkId;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.network.NetworkAttrImpl;
import edu.iris.Fissures.network.NetworkIdUtil;
import edu.sc.seis.sod.status.FissuresFormatter;
import edu.sc.seis.sod.velocity.SimpleVelocitizer;
import edu.sc.seis.sod.velocity.network.VelocityStation;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.velocity.VelocityContext;

public class VelocityNetwork
extends NetworkAttr {
    private List<VelocityStation> stations;
    private NetworkAttrImpl net;
    Comparator<VelocityStation> byCodeSorter = new Comparator<VelocityStation>(){

        @Override
        public int compare(VelocityStation sta0, VelocityStation sta1) {
            return sta0.get_code().compareTo(sta1.get_code());
        }
    };

    public VelocityNetwork(NetworkAttrImpl net) {
        this(net, null);
    }

    public VelocityNetwork(List<VelocityStation> stations) {
        this((NetworkAttrImpl)VelocityNetwork.getFirstStation(stations).getWrapped().getNetworkAttr(), stations);
    }

    private static final VelocityStation getFirstStation(List<VelocityStation> stations) {
        if (stations.size() == 0) {
            throw new IllegalArgumentException("station list cannot be of size 0");
        }
        return stations.get(0);
    }

    public VelocityNetwork(NetworkAttrImpl net, List<VelocityStation> stations) {
        this.net = net;
        this.stations = stations;
        if (stations != null) {
            Collections.sort(this.stations, this.byCodeSorter);
        }
        this.setName(net.getName());
        this.setDescription(net.getDescription());
        this.setOwner(net.getOwner());
        this.setEffectiveTime(net.getEffectiveTime());
    }

    public NetworkAttrImpl getWrapped() {
        return this.net;
    }

    public NetworkId get_id() {
        return this.net.get_id();
    }

    public String get_code() {
        return this.net.get_code();
    }

    public String getCode() {
        return this.get_code();
    }

    public String getCodeWithYear() {
        return NetworkIdUtil.toStringNoDates((NetworkId)this.net.get_id());
    }

    public String getName() {
        return FissuresFormatter.oneLineAndClean(super.getName());
    }

    public String getRawName() {
        return super.getName();
    }

    public String getRawBeginDate() {
        return this.net.get_id().begin_time.date_time;
    }

    public String getRawBeginLeapSeconds() {
        return "" + this.net.get_id().begin_time.leap_seconds_version;
    }

    public MicroSecondDate getStart() {
        return new MicroSecondDate(this.getEffectiveTime().start_time);
    }

    public String getStart(String format) {
        return SimpleVelocitizer.format(this.getStart(), format);
    }

    public MicroSecondDate getStartDate() {
        return this.getStart();
    }

    public MicroSecondDate getEnd() {
        return new MicroSecondDate(this.getEffectiveTime().end_time);
    }

    public String getEnd(String format) {
        return SimpleVelocitizer.format(this.getEnd(), format);
    }

    public MicroSecondDate getEndDate() {
        return this.getEnd();
    }

    public String getEntityRefName() {
        String s = this.getName();
        s = s.replaceAll("&", "&amp;");
        s = s.replaceAll("<", "&lt;");
        s = s.replaceAll(">", "&gt;");
        s = s.replaceAll("'", "&apos;");
        s = s.replaceAll("\"", "&quote;");
        return s;
    }

    public List<VelocityStation> getStations() {
        if (this.stations == null) {
            throw new UnsupportedOperationException("Stations have not been added for this network!");
        }
        return this.stations;
    }

    public int getDbid() {
        return this.getWrapped().getDbid();
    }

    public int getDbId() {
        return this.getDbid();
    }

    public String toString() {
        return this.getCodeWithYear();
    }

    public void insertIntoContext(VelocityContext ctx) {
        ctx.put("network", (Object)this);
        ctx.put("net", (Object)this);
    }

    public static VelocityNetwork wrap(NetworkAttr net) {
        if (net instanceof VelocityNetwork) {
            return (VelocityNetwork)net;
        }
        return new VelocityNetwork((NetworkAttrImpl)net);
    }
}

