/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.velocity.network;

import edu.iris.Fissures.IfNetwork.ChannelNotFound;
import edu.iris.Fissures.IfNetwork.Instrumentation;
import edu.iris.Fissures.network.ChannelImpl;
import edu.sc.seis.fissuresUtil.sac.InvalidResponse;
import edu.sc.seis.sod.source.SodSourceException;
import edu.sc.seis.sod.source.network.NetworkSource;
import edu.sc.seis.sod.velocity.network.VelocitySensitivity;

public class VelocityInstrumentation {
    boolean didTryLoad = false;
    Instrumentation inst = null;
    NetworkSource source;
    ChannelImpl chan;

    public VelocityInstrumentation(NetworkSource source, ChannelImpl chan) {
        this.source = source;
        this.chan = chan;
    }

    public String toString() {
        return this.getSensitivity() + " " + this.getSensorModel();
    }

    void checkLoadInstrumentation() {
        if (!this.didTryLoad) {
            this.didTryLoad = true;
            try {
                this.inst = this.source.getInstrumentation(this.chan);
            }
            catch (ChannelNotFound channelNotFound) {
            }
            catch (InvalidResponse invalidResponse) {
            }
            catch (SodSourceException sodSourceException) {
                // empty catch block
            }
        }
    }

    public VelocitySensitivity getSensitivity() {
        this.checkLoadInstrumentation();
        if (this.inst != null) {
            return new VelocitySensitivity(this.inst.the_response.the_sensitivity);
        }
        return null;
    }

    public String getSensorModel() {
        this.checkLoadInstrumentation();
        if (this.inst != null) {
            return this.inst.the_sensor.model;
        }
        return "unknown";
    }

    public String getDataLoggerModel() {
        this.checkLoadInstrumentation();
        if (this.inst != null) {
            return this.inst.das.model;
        }
        return "unknown";
    }
}

