/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.validator.model;

import edu.sc.seis.fissuresUtil.xml.XMLUtil;
import edu.sc.seis.sod.SodUtil;
import edu.sc.seis.sod.Start;
import edu.sc.seis.sod.validator.ModelWalker;
import edu.sc.seis.sod.validator.model.AbstractForm;
import edu.sc.seis.sod.validator.model.AbstractMultigenitorForm;
import edu.sc.seis.sod.validator.model.Annotation;
import edu.sc.seis.sod.validator.model.AnyXMLElement;
import edu.sc.seis.sod.validator.model.Attribute;
import edu.sc.seis.sod.validator.model.Choice;
import edu.sc.seis.sod.validator.model.Data;
import edu.sc.seis.sod.validator.model.DataList;
import edu.sc.seis.sod.validator.model.Definition;
import edu.sc.seis.sod.validator.model.Empty;
import edu.sc.seis.sod.validator.model.Form;
import edu.sc.seis.sod.validator.model.FormProvider;
import edu.sc.seis.sod.validator.model.Grammar;
import edu.sc.seis.sod.validator.model.Group;
import edu.sc.seis.sod.validator.model.Interleave;
import edu.sc.seis.sod.validator.model.ModelDatatype;
import edu.sc.seis.sod.validator.model.NamedElement;
import edu.sc.seis.sod.validator.model.NotAllowed;
import edu.sc.seis.sod.validator.model.Ref;
import edu.sc.seis.sod.validator.model.Text;
import edu.sc.seis.sod.validator.model.Value;
import edu.sc.seis.sod.validator.model.datatype.AnyText;
import edu.sc.seis.sod.validator.model.datatype.BooleanDatatype;
import edu.sc.seis.sod.validator.model.datatype.DoubleDatatype;
import edu.sc.seis.sod.validator.model.datatype.FloatDatatype;
import edu.sc.seis.sod.validator.model.datatype.IntegerDatatype;
import edu.sc.seis.sod.validator.model.datatype.NonnegativeIntegerDatatype;
import edu.sc.seis.sod.validator.model.datatype.Token;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class StAXModelBuilder
implements XMLStreamConstants {
    private Map<String, String> waiters = new HashMap<String, String>();
    private XMLStreamReader reader;
    private Grammar definedGrammar;
    private static Map<String, Grammar> parsedGrammars = new HashMap<String, Grammar>();

    public StAXModelBuilder(String relaxLoc) throws XMLStreamException, IOException {
        if (parsedGrammars.containsKey(relaxLoc)) {
            this.definedGrammar = parsedGrammars.get(relaxLoc);
        } else {
            if (relaxLoc.endsWith("anyXML.rng")) {
                this.definedGrammar = new Grammar(relaxLoc);
                NamedElement anyXML = new NamedElement(1, 1, "anyXML");
                anyXML.setChild(new Empty(anyXML));
                Definition start = new Definition("", this.definedGrammar);
                start.set(anyXML);
                Annotation ann = new Annotation();
                ann.setSummary("Any well-formed XML");
                ann.setDescription("This ingredient describes any well formed XML document.  You must replace it with a root element, and then inside of it, any well formed XML will do.");
                this.definedGrammar.add(start);
            } else {
                ClassLoader cl = this.getClass().getClassLoader();
                InputStream relaxSource = Start.createInputStream(cl, relaxLoc);
                this.reader = XMLUtil.getStaxInputFactory().createXMLStreamReader(relaxSource);
                this.definedGrammar = new Grammar(relaxLoc);
                this.reader.next();
                this.reader.next();
                try {
                    this.handleGrammar();
                }
                catch (XMLStreamException e) {
                    System.out.println("ERROR ON " + relaxLoc);
                    e.printStackTrace();
                    System.exit(0);
                }
                this.reader.close();
            }
            parsedGrammars.put(relaxLoc, this.definedGrammar);
            if (this.waiters.size() > 0) {
                for (Map.Entry<String, String> entry : this.waiters.entrySet()) {
                    this.definedGrammar.add(entry.getKey(), this.definedGrammar.getDef(entry.getValue()));
                }
            }
        }
    }

    private void handleGrammar() throws XMLStreamException {
        block3: while (this.reader.hasNext()) {
            switch (this.reader.next()) {
                case 1: {
                    String tag = this.reader.getLocalName();
                    if (tag.equals("start")) {
                        Definition root = this.handleStart();
                        this.definedGrammar.add(root);
                        break;
                    }
                    if (tag.equals("define")) {
                        Definition def = this.handleDef();
                        if (def == null) continue block3;
                        this.definedGrammar.add(def);
                        break;
                    }
                    if (tag.equals("include")) {
                        this.handleInclude();
                        break;
                    }
                    System.out.println("I DON'T THINK THIS SHOULD BE HERE");
                    this.whatIs();
                    break;
                }
            }
        }
    }

    public void whatIs() {
        switch (this.reader.getEventType()) {
            case 1: {
                System.out.println("START " + this.reader.getLocalName());
                break;
            }
            case 2: {
                System.out.println("END " + this.reader.getLocalName());
                break;
            }
            case 5: {
                System.out.println("COMMENT " + this.reader.getText());
                break;
            }
            default: {
                System.out.println("DUNNO");
            }
        }
    }

    private void handleInclude() {
        this.definedGrammar.include(this.getGrammar(this.getAbsPath()));
    }

    private Definition handleStart() throws XMLStreamException {
        Definition def = new Definition("", this.definedGrammar);
        this.nextTag();
        FormProvider result = this.handleAll();
        def.set(result);
        return def;
    }

    private Definition handleDef() throws XMLStreamException {
        int combo = 0;
        String name = "";
        for (int i = 0; i < this.reader.getAttributeCount(); ++i) {
            if (this.reader.getAttributeLocalName(i).equals("combine")) {
                String value = this.reader.getAttributeValue(i);
                if (value.equals("choice")) {
                    combo = 1;
                    continue;
                }
                if (!value.equals("interleave")) continue;
                combo = 2;
                continue;
            }
            if (!this.reader.getAttributeLocalName(i).equals("name")) continue;
            name = this.reader.getAttributeValue(i);
        }
        Definition def = new Definition(name, this.definedGrammar, combo);
        this.nextTag();
        FormProvider result = this.handleAll();
        def.set(result);
        if (result instanceof Ref) {
            Ref ref = (Ref)result;
            def = ref.getDef();
            this.waiters.put(name, ref.getName());
        }
        return def;
    }

    private void nextTag() throws XMLStreamException {
        if (this.reader.hasNext()) {
            int ev = this.reader.next();
            while (this.reader.hasNext() && ev != 1 && ev != 2) {
                ev = this.reader.next();
            }
        }
    }

    private FormProvider handleAll() throws XMLStreamException {
        ArrayList<Object> kids = new ArrayList<Object>();
        while (this.reader.getEventType() == 1) {
            String tag = this.reader.getLocalName();
            if (this.isCardinality(tag)) {
                kids.add(this.handleCardinality());
                continue;
            }
            if (tag.equals("element")) {
                kids.add(this.handleElement());
                continue;
            }
            if (tag.equals("attribute")) {
                kids.add(this.handleAttr());
                continue;
            }
            if (this.isMulitgen(tag)) {
                kids.add(this.handleMultigen());
                continue;
            }
            if (tag.equals("ref")) {
                kids.add(this.handleRef());
                continue;
            }
            if (tag.equals("externalRef")) {
                kids.add(this.handleExtRef());
                continue;
            }
            if (tag.equals("anyName")) {
                this.nextTag();
                this.nextTag();
                continue;
            }
            if (this.isData(tag)) {
                kids.add(this.handleData());
                continue;
            }
            throw new RuntimeException("Unknown tag! " + tag + " " + this.definedGrammar);
        }
        if (kids.size() == 0) {
            return null;
        }
        if (kids.size() == 1) {
            return (FormProvider)kids.get(0);
        }
        Group g = new Group(1, 1);
        Iterator it = kids.iterator();
        while (it.hasNext()) {
            g.add((FormProvider)it.next());
        }
        return g;
    }

    private boolean isAnn(String tag) {
        return tag.equals("annotation");
    }

    private Annotation handleAnn() throws XMLStreamException {
        Annotation note = new Annotation();
        if (this.isAnn(this.reader.getLocalName())) {
            while (this.reader.next() != 2 || !this.reader.getLocalName().equals("annotation")) {
                if (this.reader.getEventType() != 1) continue;
                if (this.reader.getLocalName().equals("summary")) {
                    this.reader.next();
                    note.setSummary(this.reader.getText());
                    continue;
                }
                if (this.reader.getLocalName().equals("description")) {
                    note.setDescription(this.extractSubstructure());
                    continue;
                }
                if (this.reader.getLocalName().equals("deprecated")) {
                    note.setDeprecation(this.extractSubstructure());
                    continue;
                }
                if (this.reader.getLocalName().equals("include")) {
                    this.reader.next();
                    note.setInclude(true);
                    continue;
                }
                if (this.reader.getLocalName().equals("example")) {
                    String example = this.extractSubstructure();
                    example = example.replaceAll("\\t", "        ");
                    int j = 0;
                    for (int i = 0; i < example.length(); ++i) {
                        if (example.charAt(i) == '\n') {
                            j = 0;
                            continue;
                        }
                        if (example.charAt(i) != ' ') break;
                        ++j;
                    }
                    example = example.trim();
                    note.setExample(example.replaceAll("[ \\t]{" + j + "}", ""));
                    continue;
                }
                if (this.reader.getLocalName().equals("velocity")) {
                    this.reader.next();
                    note.setVelocity(this.reader.getText());
                    continue;
                }
                if (this.reader.getLocalName().equals("documentation")) continue;
                System.out.println("Unrecognized tag " + this.reader.getLocalName() + " in annotation in " + this.definedGrammar);
            }
            this.reader.nextTag();
        }
        return note;
    }

    public String extractSubstructure() throws XMLStreamException {
        String stopTagName = this.reader.getLocalName();
        StringBuffer buf = new StringBuffer();
        this.reader.next();
        int prevEventType = -1;
        while (this.reader.getEventType() != 2 || !this.reader.getLocalName().equals(stopTagName)) {
            int curEventType = this.reader.getEventType();
            if (prevEventType == 1 && curEventType == 2) {
                buf.setCharAt(buf.length() - 1, ' ');
                buf.append("/>");
            } else {
                buf.append(XMLUtil.readEvent((XMLStreamReader)this.reader));
            }
            this.reader.next();
            prevEventType = curEventType;
        }
        return buf.toString();
    }

    private FormProvider handleCardinality() throws XMLStreamException {
        int min = 1;
        int max = 1;
        String tag = this.reader.getLocalName();
        if (tag.equals("zeroOrMore") || tag.equals("optional")) {
            min = 0;
        }
        if (tag.equals("zeroOrMore") || tag.equals("oneOrMore")) {
            max = Integer.MAX_VALUE;
        }
        this.reader.nextTag();
        if (this.isAnn(this.reader.getLocalName())) {
            Annotation note = this.handleAnn();
            throw new RuntimeException("Annotation with summary " + note.getSummary() + " not allowed directly in cardinality tag");
        }
        FormProvider result = this.handleAll();
        if (min == 0) {
            result.setMin(min);
        }
        if (max == Integer.MAX_VALUE) {
            result.setMax(max);
        }
        this.reader.nextTag();
        return result;
    }

    private boolean isCardinality(String tag) {
        return tag.equals("oneOrMore") || tag.equals("zeroOrMore") || tag.equals("optional");
    }

    private FormProvider handleElement() throws XMLStreamException {
        if (this.reader.getAttributeCount() == 0) {
            this.nextTag();
            AnyXMLElement out = new AnyXMLElement(1, 1);
            out.setNamespace(ModelWalker.getNamespaceFromAncestors(out));
            out.setAnnotation(this.handleAnn());
            out.setChild(this.handleAll());
            this.nextTag();
            return out;
        }
        String name = this.reader.getAttributeValue(0);
        String ns = this.reader.getAttributeValue(null, "ns");
        this.nextTag();
        NamedElement result = new NamedElement(1, 1, name);
        if (ns == null) {
            ns = ModelWalker.getNamespaceFromAncestors(result);
        }
        result.setNamespace(ns);
        result.setAnnotation(this.handleAnn());
        try {
            result.setChild(this.handleAll());
        }
        catch (RuntimeException e) {
            throw new RuntimeException("in " + name, e);
        }
        this.nextTag();
        return result;
    }

    private Object handleAttr() throws XMLStreamException {
        String name = this.reader.getAttributeCount() == 0 ? "anyAttribute" : this.reader.getAttributeValue(0);
        String ns = this.reader.getAttributeValue(null, "ns");
        this.nextTag();
        Attribute result = new Attribute(1, 1, name);
        if (ns == null) {
            ns = ModelWalker.getNamespaceFromAncestors(result);
        }
        result.setNamespace(ns);
        result.setAnnotation(this.handleAnn());
        FormProvider child = this.handleAll();
        if (child == null) {
            child = new Text();
        }
        result.setChild(child);
        this.nextTag();
        return result;
    }

    private FormProvider handleMultigen() throws XMLStreamException {
        String tag = this.reader.getLocalName();
        AbstractMultigenitorForm parent = tag.equals("choice") ? new Choice(1, 1) : (tag.equals("group") ? new Group(1, 1) : (tag.equals("list") ? new DataList(1, 1) : new Interleave(1, 1)));
        this.nextTag();
        Annotation followingNote = this.handleAnn();
        FormProvider child = this.handleAll();
        this.nextTag();
        if (child instanceof AbstractMultigenitorForm) {
            FormProvider[] myKids = ((AbstractMultigenitorForm)child).getFormProviders();
            for (int i = 0; i < myKids.length; ++i) {
                parent.add(myKids[i].copyWithNewParent(parent));
            }
            parent.setAnnotation(followingNote);
            return parent;
        }
        return child;
    }

    private boolean isMulitgen(String tag) {
        return tag.equals("choice") || tag.equals("group") || tag.equals("interleave") || tag.equals("list");
    }

    private Ref handleRef() throws XMLStreamException {
        String name = this.reader.getAttributeValue(0);
        this.nextTag();
        Ref ref = new Ref(this.definedGrammar, name);
        ref.setAnnotation(this.handleAnn());
        this.nextTag();
        return ref;
    }

    private Ref handleExtRef() throws XMLStreamException {
        String refGramLoc = this.getAbsPath();
        this.nextTag();
        Ref ref = new Ref(this.getGrammar(refGramLoc));
        ref.setAnnotation(this.handleAnn());
        this.nextTag();
        return ref;
    }

    private Form handleData() throws XMLStreamException {
        FormProvider listInternals;
        String tag = this.reader.getLocalName();
        AbstractForm result = null;
        if (tag.equals("notAllowed")) {
            result = new NotAllowed();
        } else if (tag.equals("empty")) {
            result = new Empty();
        } else if (tag.equals("text")) {
            result = new Text();
        } else if (tag.equals("value") || tag.equals("data")) {
            ModelDatatype type = this.handleType();
            if (tag.equals("data")) {
                result = new Data(1, 1, type);
            } else {
                this.reader.next();
                result = new Value(1, 1, this.reader.getText(), type);
            }
        } else if (!tag.equals("list") || (listInternals = this.handleAll()) instanceof AbstractMultigenitorForm) {
            // empty if block
        }
        this.nextTag();
        result.setAnnotation(this.handleAnn());
        while (this.reader.getEventType() == 1 && this.reader.getLocalName().equals("param")) {
            this.handleParam((Data)result);
        }
        this.nextTag();
        return result;
    }

    private void handleParam(Data result) throws XMLStreamException {
        while (this.reader.getEventType() != 2) {
            this.reader.next();
        }
        this.reader.nextTag();
    }

    private boolean isData(String tag) {
        return tag.equals("empty") || tag.equals("data") || tag.equals("value") || tag.equals("text") || tag.equals("notAllowed");
    }

    private ModelDatatype handleType() {
        if (this.reader.getAttributeCount() > 0) {
            String type = this.reader.getAttributeValue(0);
            if (type.equals("float")) {
                return new FloatDatatype();
            }
            if (type.equals("string")) {
                return new AnyText();
            }
            if (type.equals("double")) {
                return new DoubleDatatype();
            }
            if (type.equals("integer")) {
                return new IntegerDatatype();
            }
            if (type.equals("nonNegativeInteger")) {
                return new NonnegativeIntegerDatatype();
            }
            if (type.equals("boolean")) {
                return new BooleanDatatype();
            }
            return new Token();
        }
        return null;
    }

    private String getAbsPath() {
        String href = this.reader.getAttributeValue(0);
        String curLoc = this.definedGrammar.getLoc();
        try {
            return SodUtil.getAbsolutePath(curLoc, href);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Form getRoot() {
        return this.definedGrammar.getRoot();
    }

    Grammar getGrammar(String loc) {
        if (!parsedGrammars.containsKey(loc)) {
            try {
                new StAXModelBuilder(loc);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return parsedGrammars.get(loc);
    }

    public static Collection<Definition> getAllDefinitions() {
        HashSet<Definition> defs = new HashSet<Definition>();
        for (Grammar cur : parsedGrammars.values()) {
            defs.addAll(cur.getDefs());
        }
        return defs;
    }
}

