/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.validator.model;

import edu.sc.seis.sod.validator.model.Annotation;
import edu.sc.seis.sod.validator.model.Definition;
import edu.sc.seis.sod.validator.model.Form;
import edu.sc.seis.sod.validator.model.FormProvider;
import edu.sc.seis.sod.validator.model.Grammar;

public class Ref
implements FormProvider {
    private int max = 1;
    private int min = 1;
    private Grammar owner;
    private String name = "";
    private Form parent;
    private Form derefedForm;
    private Annotation ann = new Annotation();

    public Ref(Grammar owner) {
        this(owner, "");
    }

    public Ref(Grammar owner, String name) {
        this(owner, name, null);
    }

    public Ref(Grammar owner, String name, Form parent) {
        this.owner = owner;
        this.name = name;
        this.parent = parent;
        this.ann.setFormProvider(this);
    }

    @Override
    public FormProvider copyWithNewParent(Form newParent) {
        Ref copy = new Ref(this.owner, this.name, newParent);
        copy.setMin(this.min);
        copy.setMax(this.max);
        if (this.ann != null) {
            copy.setAnnotation(this.ann);
        }
        return copy;
    }

    @Override
    public Form getForm() {
        if (this.derefedForm == null) {
            Definition def = this.getDef();
            Form refedForm = def.getForm();
            this.derefedForm = refedForm.deref(this.parent, def);
            if (this.getMin() == 0) {
                this.derefedForm.setMin(this.getMin());
            }
            if (this.getMax() > 1) {
                this.derefedForm.setMax(this.getMax());
            }
        }
        return this.derefedForm;
    }

    public String getName() {
        return this.name;
    }

    public Definition getDef() {
        Definition d = this.owner.getDef(this.name);
        if (d == null) {
            throw new NullPointerException("definition of '" + this.name + "' should not be null");
        }
        return d;
    }

    @Override
    public int getMin() {
        return this.min;
    }

    @Override
    public void setMin(int min) {
        this.min = min;
    }

    @Override
    public int getMax() {
        return this.max;
    }

    @Override
    public void setAnnotation(Annotation ann) {
        this.ann = ann;
        ann.setFormProvider(this);
    }

    @Override
    public void setMax(int max) {
        this.max = max;
    }

    public int hashCode() {
        int result = 382;
        result += 37 * this.owner.hashCode();
        return (result += 37 * this.name.hashCode()) + 37 * this.parent.hashCode();
    }
}

