/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.subsetter.station;

import edu.iris.Fissures.IfNetwork.StationId;
import edu.iris.Fissures.network.StationImpl;
import edu.sc.seis.fissuresUtil.cache.FilterNetworkAccess;
import edu.sc.seis.fissuresUtil.cache.FilterNetworkDC;
import edu.sc.seis.fissuresUtil.display.configuration.DOMHelper;
import edu.sc.seis.sod.SodUtil;
import edu.sc.seis.sod.source.network.NetworkSource;
import edu.sc.seis.sod.status.Fail;
import edu.sc.seis.sod.status.Pass;
import edu.sc.seis.sod.status.StringTree;
import edu.sc.seis.sod.subsetter.station.StationSubsetter;
import java.io.IOException;
import java.util.regex.Pattern;
import org.w3c.dom.Element;

public class StationRegularExpression
implements StationSubsetter {
    private Pattern[] patterns;

    public StationRegularExpression(Element el) throws IOException {
        if (DOMHelper.hasElement((Element)el, (String)"url")) {
            String url = DOMHelper.extractText((Element)el, (String)"url");
            this.patterns = FilterNetworkDC.readPattern((String)url);
        } else if (DOMHelper.hasElement((Element)el, (String)"code")) {
            this.patterns = new Pattern[]{Pattern.compile(SodUtil.getNestedText(DOMHelper.getElement((Element)el, (String)"code")))};
        }
    }

    @Override
    public StringTree accept(StationImpl station, NetworkSource network) throws Exception {
        for (int i = 0; i < this.patterns.length; ++i) {
            if (!this.patterns[i].matcher(FilterNetworkAccess.getStationString((StationId)station.get_id())).matches()) continue;
            return new Pass(this);
        }
        return new Fail(this);
    }
}

