/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.subsetter.station;

import edu.iris.Fissures.network.StationImpl;
import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.source.network.NetworkSource;
import edu.sc.seis.sod.status.StringTree;
import edu.sc.seis.sod.status.StringTreeBranch;
import edu.sc.seis.sod.subsetter.LogicalSubsetter;
import edu.sc.seis.sod.subsetter.Subsetter;
import edu.sc.seis.sod.subsetter.network.NetworkLogicalSubsetter;
import edu.sc.seis.sod.subsetter.network.NetworkSubsetter;
import edu.sc.seis.sod.subsetter.station.StationSubsetter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.w3c.dom.Element;

public abstract class StationLogicalSubsetter
extends LogicalSubsetter {
    public static final List<String> packages = new LinkedList<String>();

    public StationLogicalSubsetter(Element config) throws ConfigurationException {
        super(config);
    }

    @Override
    public List<String> getPackages() {
        return packages;
    }

    @Override
    protected Subsetter getSubsetter(Subsetter s) throws ConfigurationException {
        return StationLogicalSubsetter.createSubsetter(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StringTree accept(StationImpl sta, NetworkSource network) throws Exception {
        ArrayList<StringTree> reasons = new ArrayList<StringTree>(this.filterList.size());
        Iterator it = this.filterList.iterator();
        while (it.hasNext()) {
            StringTree result;
            StationSubsetter processor;
            StationSubsetter stationSubsetter = processor = (StationSubsetter)it.next();
            synchronized (stationSubsetter) {
                result = processor.accept(sta, network);
            }
            reasons.add(result);
            if (this.shouldContinue(result)) continue;
            break;
        }
        StringTree[] results = reasons.toArray(new StringTree[0]);
        return new StringTreeBranch((Object)this, this.isSuccess(results), results);
    }

    public abstract boolean shouldContinue(StringTree var1);

    public abstract boolean isSuccess(StringTree[] var1);

    public static StationSubsetter createSubsetter(final Subsetter s) throws ConfigurationException {
        if (s instanceof StationSubsetter) {
            return (StationSubsetter)s;
        }
        return new StationSubsetter(){
            NetworkSubsetter ns;
            {
                this.ns = NetworkLogicalSubsetter.createSubsetter(s);
            }

            @Override
            public StringTree accept(StationImpl station, NetworkSource network) throws Exception {
                return this.ns.accept(station.getNetworkAttrImpl());
            }
        };
    }

    static {
        packages.add("station");
        packages.addAll(NetworkLogicalSubsetter.packages);
    }
}

