/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.subsetter.requestGenerator;

import edu.iris.Fissures.IfEvent.EventAccessOperations;
import edu.iris.Fissures.IfNetwork.Channel;
import edu.iris.Fissures.IfSeismogramDC.RequestFilter;
import edu.iris.Fissures.model.TimeInterval;
import edu.iris.Fissures.network.ChannelImpl;
import edu.sc.seis.TauP.TauModelException;
import edu.sc.seis.fissuresUtil.cache.CacheEvent;
import edu.sc.seis.fissuresUtil.display.configuration.DOMHelper;
import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.CookieJar;
import edu.sc.seis.sod.SodUtil;
import edu.sc.seis.sod.subsetter.requestGenerator.RequestGenerator;
import org.w3c.dom.Element;

public class PhaseRequest
implements RequestGenerator {
    private edu.sc.seis.fissuresUtil.bag.PhaseRequest phaseReq;

    public PhaseRequest(Element config) throws ConfigurationException {
        String model = DOMHelper.extractText((Element)config, (String)"model", (String)"prem");
        String beginPhase = DOMHelper.extractText((Element)config, (String)"beginPhase");
        String endPhase = DOMHelper.extractText((Element)config, (String)"endPhase");
        TimeInterval beginOffset = null;
        double beginOffsetRatio = 1.0;
        TimeInterval beginOffsetRatioMinimum = null;
        boolean negateBeginOffsetRatio = false;
        boolean negateEndOffsetRatio = false;
        Element beginEl = DOMHelper.extractElement((Element)config, (String)"beginOffset");
        if (DOMHelper.hasElement((Element)beginEl, (String)"ratio")) {
            beginOffsetRatio = DOMHelper.extractDouble((Element)beginEl, (String)"ratio", (double)1.0);
            beginOffsetRatioMinimum = SodUtil.loadTimeInterval(DOMHelper.getElement((Element)beginEl, (String)"minimum"));
            if (DOMHelper.hasElement((Element)beginEl, (String)"negative")) {
                negateBeginOffsetRatio = true;
            }
        } else {
            beginOffset = SodUtil.loadTimeInterval(beginEl);
        }
        try {
            Element endEl = DOMHelper.extractElement((Element)config, (String)"endOffset");
            if (DOMHelper.hasElement((Element)endEl, (String)"ratio")) {
                double endOffsetRatio = DOMHelper.extractDouble((Element)endEl, (String)"ratio", (double)1.0);
                TimeInterval endOffsetRatioMinimum = SodUtil.loadTimeInterval(DOMHelper.getElement((Element)endEl, (String)"minimum"));
                if (DOMHelper.hasElement((Element)endEl, (String)"negative")) {
                    negateEndOffsetRatio = true;
                }
                this.phaseReq = beginOffset != null ? new edu.sc.seis.fissuresUtil.bag.PhaseRequest(beginPhase, beginOffset, endPhase, endOffsetRatio, endOffsetRatioMinimum, negateEndOffsetRatio, model) : new edu.sc.seis.fissuresUtil.bag.PhaseRequest(beginPhase, beginOffsetRatio, beginOffsetRatioMinimum, negateBeginOffsetRatio, endPhase, endOffsetRatio, endOffsetRatioMinimum, negateEndOffsetRatio, model);
            } else {
                TimeInterval endOffset = SodUtil.loadTimeInterval(endEl);
                this.phaseReq = beginOffset != null ? new edu.sc.seis.fissuresUtil.bag.PhaseRequest(beginPhase, beginOffset, endPhase, endOffset, model) : new edu.sc.seis.fissuresUtil.bag.PhaseRequest(beginPhase, beginOffsetRatio, beginOffsetRatioMinimum, negateBeginOffsetRatio, endPhase, endOffset, model);
            }
        }
        catch (TauModelException e) {
            throw new ConfigurationException("Problem with TauPUtil.", e);
        }
    }

    public PhaseRequest(String beginPhase, TimeInterval beginOffset, String endPhase, TimeInterval endOffset, String model) throws TauModelException {
        this.phaseReq = new edu.sc.seis.fissuresUtil.bag.PhaseRequest(beginPhase, beginOffset, endPhase, endOffset, model);
    }

    @Override
    public RequestFilter[] generateRequest(CacheEvent event, ChannelImpl channel, CookieJar jar) throws Exception {
        RequestFilter rf = this.generateRequest((EventAccessOperations)event, (Channel)channel);
        if (rf == null) {
            return new RequestFilter[0];
        }
        return new RequestFilter[]{rf};
    }

    public RequestFilter generateRequest(EventAccessOperations event, Channel channel) throws Exception {
        return this.phaseReq.generateRequest(event, channel);
    }

    public edu.sc.seis.fissuresUtil.bag.PhaseRequest getPhaseReq() {
        return this.phaseReq;
    }
}

