/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.subsetter.origin;

import edu.iris.Fissures.IfEvent.Origin;
import edu.iris.Fissures.Quantity;
import edu.iris.Fissures.Unit;
import edu.iris.Fissures.event.EventAttrImpl;
import edu.iris.Fissures.event.OriginImpl;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.model.QuantityImpl;
import edu.iris.Fissures.model.TimeInterval;
import edu.iris.Fissures.model.UnitImpl;
import edu.sc.seis.fissuresUtil.bag.DistAz;
import edu.sc.seis.fissuresUtil.cache.CacheEvent;
import edu.sc.seis.fissuresUtil.time.MicroSecondTimeRange;
import edu.sc.seis.fissuresUtil.xml.XMLUtil;
import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.SodUtil;
import edu.sc.seis.sod.Standing;
import edu.sc.seis.sod.hibernate.StatefulEvent;
import edu.sc.seis.sod.hibernate.StatefulEventDB;
import edu.sc.seis.sod.status.StringTree;
import edu.sc.seis.sod.status.StringTreeLeaf;
import edu.sc.seis.sod.subsetter.origin.OriginSubsetter;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.omg.CORBA.Object;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class RemoveEventDuplicate
implements OriginSubsetter {
    protected QuantityImpl timeVariance = new QuantityImpl(10.0, (Unit)UnitImpl.SECOND);
    protected QuantityImpl distanceVariance = new QuantityImpl(0.5, (Unit)UnitImpl.DEGREE);
    protected QuantityImpl depthVariance = new QuantityImpl(100.0, (Unit)UnitImpl.KILOMETER);
    private StatefulEventDB eventTable;
    private static Logger logger = LoggerFactory.getLogger(RemoveEventDuplicate.class);

    public RemoveEventDuplicate(Element config) throws ConfigurationException {
        Element el = XMLUtil.getElement((Element)config, (String)"timeVariance");
        if (el != null) {
            this.setTimeVariance(SodUtil.loadQuantity(el));
        }
        if ((el = XMLUtil.getElement((Element)config, (String)"distanceVariance")) != null) {
            this.setDistanceVariance(SodUtil.loadQuantity(el));
        }
        if ((el = XMLUtil.getElement((Element)config, (String)"depthVariance")) != null) {
            this.setDepthVariance(SodUtil.loadQuantity(el));
        }
    }

    public RemoveEventDuplicate(QuantityImpl timeVariance, QuantityImpl distanceVariance, QuantityImpl depthVariance) throws ConfigurationException {
        this.setTimeVariance(timeVariance);
        this.setDistanceVariance(distanceVariance);
        this.setDepthVariance(depthVariance);
    }

    public RemoveEventDuplicate() {
    }

    public StatefulEventDB getEventStatusTable() throws SQLException {
        if (this.eventTable == null) {
            this.eventTable = StatefulEventDB.getSingleton();
        }
        return this.eventTable;
    }

    @Override
    public StringTree accept(CacheEvent eventAccess, EventAttrImpl eventAttr, OriginImpl preferred_origin) throws Exception {
        for (StatefulEvent e : this.getEventsNearTimeAndDepth((Origin)preferred_origin)) {
            if (e.equals((Object)eventAccess) || !this.isDistanceClose(e, (Origin)preferred_origin)) continue;
            return new StringTreeLeaf(this, false);
        }
        return new StringTreeLeaf(this, true);
    }

    public boolean isDistanceClose(CacheEvent eventA, Origin originB) {
        OriginImpl curOrig = eventA.getOrigin();
        DistAz distAz = new DistAz(curOrig.getLocation(), originB.getLocation());
        if (this.distanceVariance.getUnit().isConvertableTo(UnitImpl.DEGREE)) {
            return distAz.getDelta() < this.distanceVariance.convertTo((UnitImpl)UnitImpl.DEGREE).value;
        }
        return distAz.getDelta() * 6371.0 < this.distanceVariance.convertTo((UnitImpl)UnitImpl.KILOMETER).value;
    }

    public List getEventsNearTimeAndDepth(Origin preferred_origin) throws SQLException {
        MicroSecondDate originTime = new MicroSecondDate(preferred_origin.getOriginTime());
        MicroSecondDate minTime = originTime.subtract(new TimeInterval((Quantity)this.timeVariance));
        MicroSecondDate maxTime = originTime.add(new TimeInterval((Quantity)this.timeVariance));
        QuantityImpl originDepth = QuantityImpl.createQuantityImpl((Quantity)preferred_origin.getLocation().depth);
        QuantityImpl depthRangeImpl = QuantityImpl.createQuantityImpl((Quantity)this.depthVariance);
        QuantityImpl minDepth = originDepth.subtract(depthRangeImpl);
        QuantityImpl maxDepth = originDepth.add(depthRangeImpl);
        List<StatefulEvent> timeEvents = this.getEventStatusTable().getEventInTimeRangeRegardlessOfStatus(new MicroSecondTimeRange(minTime, maxTime));
        ArrayList<StatefulEvent> out = new ArrayList<StatefulEvent>();
        for (StatefulEvent e : timeEvents) {
            if (e.getStatus().getStanding().equals(Standing.INIT) || e.getStatus().getStanding().equals(Standing.IN_PROG) || e.getStatus().getStanding().equals(Standing.SUCCESS)) {
                QuantityImpl depth = (QuantityImpl)e.getOrigin().getLocation().depth;
                if (depth.greaterThanEqual(minDepth) && depth.lessThanEqual(maxDepth)) {
                    out.add(e);
                    logger.debug("Considering for RemoveEventDup: " + (java.lang.Object)((java.lang.Object)e));
                    continue;
                }
                logger.debug("Not considering (depth=" + depth + ") for RemoveEventDup: " + (java.lang.Object)((java.lang.Object)e));
                continue;
            }
            logger.debug("Not considering (status=" + e.getStatus() + ") for RemoveEventDup: " + (java.lang.Object)((java.lang.Object)e));
        }
        return out;
    }

    protected void setTimeVariance(QuantityImpl timeVariance) throws ConfigurationException {
        if (!timeVariance.getUnit().isConvertableTo(UnitImpl.SECOND)) {
            throw new ConfigurationException("Units must be convertible to SECOND: " + timeVariance.getUnit());
        }
        this.timeVariance = timeVariance;
    }

    protected void setDistanceVariance(QuantityImpl maxDistance) throws ConfigurationException {
        if (!maxDistance.getUnit().isConvertableTo(UnitImpl.DEGREE) && !maxDistance.getUnit().isConvertableTo(UnitImpl.KILOMETER)) {
            throw new ConfigurationException("Units must be convertible to DEGREE or KILOMETER: " + maxDistance.getUnit());
        }
        this.distanceVariance = maxDistance;
    }

    protected void setDepthVariance(QuantityImpl depthVariance) throws ConfigurationException {
        if (!depthVariance.getUnit().isConvertableTo(UnitImpl.KILOMETER)) {
            throw new ConfigurationException("Units must be convertible to KILOMETER: " + depthVariance.getUnit());
        }
        this.depthVariance = depthVariance;
    }
}

