/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.subsetter.eventStation;

import edu.iris.Fissures.event.EventAttrImpl;
import edu.iris.Fissures.network.StationImpl;
import edu.sc.seis.fissuresUtil.cache.CacheEvent;
import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.CookieJar;
import edu.sc.seis.sod.Start;
import edu.sc.seis.sod.status.StringTree;
import edu.sc.seis.sod.subsetter.LogicalSubsetter;
import edu.sc.seis.sod.subsetter.Subsetter;
import edu.sc.seis.sod.subsetter.eventStation.EventStationSubsetter;
import edu.sc.seis.sod.subsetter.origin.EventLogicalSubsetter;
import edu.sc.seis.sod.subsetter.origin.OriginSubsetter;
import edu.sc.seis.sod.subsetter.station.StationLogicalSubsetter;
import edu.sc.seis.sod.subsetter.station.StationSubsetter;
import java.util.LinkedList;
import java.util.List;
import org.w3c.dom.Element;

public class EventStationLogicalSubsetter
extends LogicalSubsetter {
    public static final List<String> packages = new LinkedList<String>();

    public EventStationLogicalSubsetter(Element config) throws ConfigurationException {
        super(config);
    }

    @Override
    public List<String> getPackages() {
        return packages;
    }

    @Override
    protected Subsetter getSubsetter(Subsetter s) throws ConfigurationException {
        return EventStationLogicalSubsetter.createSubsetter(s);
    }

    public static EventStationSubsetter createSubsetter(final Subsetter s) throws ConfigurationException {
        if (s instanceof EventStationSubsetter) {
            return (EventStationSubsetter)s;
        }
        if (s instanceof OriginSubsetter) {
            return new EventStationSubsetter(){
                OriginSubsetter ecs;
                {
                    this.ecs = EventLogicalSubsetter.createSubsetter(s);
                }

                @Override
                public StringTree accept(CacheEvent event, StationImpl station, CookieJar cookieJar) throws Exception {
                    return this.ecs.accept(event, (EventAttrImpl)event.get_attributes(), event.getPreferred());
                }
            };
        }
        return new EventStationSubsetter(){
            StationSubsetter ecs;
            {
                this.ecs = StationLogicalSubsetter.createSubsetter(s);
            }

            @Override
            public StringTree accept(CacheEvent event, StationImpl station, CookieJar cookieJar) throws Exception {
                return this.ecs.accept(station, Start.getNetworkArm().getNetworkSource());
            }
        };
    }

    static {
        packages.add("eventStation");
        packages.addAll(StationLogicalSubsetter.packages);
        packages.addAll(EventLogicalSubsetter.packages);
    }
}

